/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.viewers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.internal.databinding.swt.SWTUtil;
import org.eclipse.jface.internal.provisional.databinding.AbstractUpdatableSet;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.ITreeProvider;
import org.eclipse.jface.internal.provisional.databinding.updatables.EmptyReadableSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public final class UpdatableTreeContentProvider
implements ITreeContentProvider {
    private ITreeProvider treeProvider;
    private Map mapElementToValueTreeNode = new HashMap();
    private TreeViewer treeViewer;
    private ArrayList dirtyListeners = new ArrayList();
    private int dirtyCount;
    private int avoidViewerUpdates = 0;
    private ITreeViewerListener expandListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            ValueTreeNode node = (ValueTreeNode)UpdatableTreeContentProvider.this.mapElementToValueTreeNode.get(event.getElement());
            if (node == null) {
                return;
            }
            node.expanded();
        }
    };
    private KnownElementsSet elements = new KnownElementsSet();
    private Object inputElement;

    public UpdatableTreeContentProvider(ITreeProvider provider) {
        this.treeProvider = provider;
    }

    private void fireStale(Object node, boolean isStale) {
        ChangeEvent event = new ChangeEvent(node, 64, null, isStale ? Boolean.TRUE : Boolean.FALSE);
        Iterator iter = this.dirtyListeners.iterator();
        while (iter.hasNext()) {
            IChangeListener next = (IChangeListener)iter.next();
            try {
                next.handleChange(event);
            }
            catch (Exception e) {
                SWTUtil.logException(e);
            }
        }
    }

    public int getDirtyCount() {
        return this.dirtyCount;
    }

    public void addDirtyListener(IChangeListener toAdd) {
        this.dirtyListeners.add(toAdd);
    }

    public void removeDirtyListener(IChangeListener toRemove) {
        this.dirtyListeners.remove(toRemove);
    }

    private void doFireAdd(Collection added) {
        this.elements.doFireAdd(added);
    }

    private boolean isDisposed() {
        return this.treeViewer.getControl().isDisposed();
    }

    private void doFireRemove(Collection removed) {
        this.elements.doFireRemove(removed);
    }

    private ValueTreeNode createSubtree(Object parent, Object object, boolean childrenAddedToViewer) {
        ValueTreeNode result = (ValueTreeNode)this.mapElementToValueTreeNode.get(object);
        if (result == null) {
            result = new ValueTreeNode(object);
            this.mapElementToValueTreeNode.put(object, result);
        }
        if (childrenAddedToViewer) {
            result.childrenAddedToViewer();
        }
        if (parent != null) {
            result.addParent(parent);
        }
        if (parent == null || parent == this.inputElement || this.treeViewer.getExpandedState(parent)) {
            result.startListening();
        }
        return result;
    }

    private boolean pruneSubtree(Object parent, Object child) {
        ValueTreeNode result = (ValueTreeNode)this.mapElementToValueTreeNode.get(child);
        if (result != null) {
            result.removeParent(parent);
            if (result.getParents().isEmpty()) {
                result.dispose();
                return true;
            }
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (this.treeViewer == null) {
            return new Object[0];
        }
        ValueTreeNode node = (ValueTreeNode)this.mapElementToValueTreeNode.get(parentElement);
        if (node == null) {
            node = this.createSubtree(null, parentElement, true);
        }
        return node.getChildren().toArray();
    }

    public Object getParent(Object element) {
        if (this.treeViewer == null) {
            return null;
        }
        ValueTreeNode node = (ValueTreeNode)this.mapElementToValueTreeNode.get(element);
        if (node == null) {
            return null;
        }
        return node.parent;
    }

    public boolean hasChildren(Object element) {
        if (this.treeViewer == null) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        if (this.treeViewer == null) return;
        try {
            ++this.avoidViewerUpdates;
            Object[] keys = this.mapElementToValueTreeNode.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                Object key = keys[i];
                ValueTreeNode result = (ValueTreeNode)this.mapElementToValueTreeNode.get(key);
                result.dispose();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.avoidViewerUpdates;
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.avoidViewerUpdates;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setViewer(viewer);
        if (oldInput != null && newInput != null && oldInput.equals(newInput)) {
            return;
        }
        this.inputElement = newInput;
        try {
            ++this.avoidViewerUpdates;
            this.pruneSubtree(null, oldInput);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.avoidViewerUpdates;
            throw throwable;
        }
        {
            Object var4_6 = null;
            --this.avoidViewerUpdates;
            return;
        }
    }

    private void setViewer(Viewer viewer) {
        if (!(viewer instanceof TreeViewer)) {
            throw new IllegalArgumentException("This content provider can only be used with TreeViewers");
        }
        TreeViewer newTreeViewer = (TreeViewer)viewer;
        if (newTreeViewer != this.treeViewer) {
            if (this.treeViewer != null) {
                this.treeViewer.removeTreeListener(this.expandListener);
            }
            this.treeViewer = newTreeViewer;
            if (newTreeViewer != null) {
                newTreeViewer.addTreeListener(this.expandListener);
            }
        }
    }

    public IReadableSet getKnownElements() {
        return this.elements;
    }

    private Collection computeKnownElements() {
        return Collections.unmodifiableCollection(this.mapElementToValueTreeNode.keySet());
    }

    public boolean isDirty(Object element) {
        ValueTreeNode node = (ValueTreeNode)this.mapElementToValueTreeNode.get(element);
        if (node == null) {
            return false;
        }
        return node.isDirty();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    private class KnownElementsSet
    extends AbstractUpdatableSet {
        KnownElementsSet() {
        }

        protected Collection computeElements() {
            return UpdatableTreeContentProvider.this.computeKnownElements();
        }

        public void doFireAdd(Collection added) {
            this.fireAdded(added);
        }

        public void doFireRemove(Collection removed) {
            this.fireRemoved(removed);
        }

        public void doFireStale(boolean isStale) {
            this.fireStale(isStale);
        }
    }

    private class ValueTreeNode
    implements IChangeListener {
        private HashSet parents = new HashSet();
        private Object node;
        private Object parent;
        private IReadableSet model;
        private boolean childrenAddedToViewer = false;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public ValueTreeNode(Object key) {
            this.node = key;
        }

        public void childrenAddedToViewer() {
            this.childrenAddedToViewer = true;
        }

        public void addParent(Object parent) {
            if (this.parent == null) {
                this.parent = parent;
            }
            this.parents.add(parent);
        }

        public void removeParent(Object parent) {
            this.parents.remove(parent);
            if (parent == this.parent) {
                this.parent = this.parents.isEmpty() ? null : this.parents.iterator().next();
            }
        }

        public final Collection getChildren() {
            if (this.model == null) {
                return Collections.EMPTY_SET;
            }
            return this.model.toCollection();
        }

        public void expanded() {
            Iterator iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                ValueTreeNode childProvider = (ValueTreeNode)UpdatableTreeContentProvider.this.mapElementToValueTreeNode.get(next);
                childProvider.startListening();
            }
        }

        public void startListening() {
            if (this.model == null) {
                this.model = UpdatableTreeContentProvider.this.treeProvider.createChildList(this.node);
                if (this.model == null) {
                    this.model = EmptyReadableSet.getInstance();
                }
                this.model.addChangeListener(this);
                if (!this.childrenAddedToViewer) {
                    this.childrenAddedToViewer = true;
                    this.doAdd(this.model.toCollection());
                }
                if (this.model.isStale()) {
                    this.setStale(this.node, true);
                }
            }
        }

        public void setStale(Object staleObject, boolean isStale) {
            if (isStale) {
                UpdatableTreeContentProvider updatableTreeContentProvider = UpdatableTreeContentProvider.this;
                updatableTreeContentProvider.dirtyCount = updatableTreeContentProvider.dirtyCount + 1;
                if (UpdatableTreeContentProvider.this.dirtyCount == 1) {
                    UpdatableTreeContentProvider.this.elements.doFireStale(true);
                }
            } else {
                UpdatableTreeContentProvider updatableTreeContentProvider = UpdatableTreeContentProvider.this;
                updatableTreeContentProvider.dirtyCount = updatableTreeContentProvider.dirtyCount - 1;
                if (UpdatableTreeContentProvider.this.dirtyCount == 0) {
                    UpdatableTreeContentProvider.this.elements.doFireStale(false);
                }
            }
            UpdatableTreeContentProvider.this.fireStale(this.node, isStale);
        }

        public void stopListening() {
            if (this.model != null) {
                if (this.childrenAddedToViewer) {
                    this.doRemove(this.model.toCollection());
                    this.childrenAddedToViewer = false;
                }
                if (this.model.isStale()) {
                    this.setStale(this.node, false);
                }
                this.model.removeChangeListener(this);
                this.model = null;
            }
        }

        public void dispose() {
            this.stopListening();
            UpdatableTreeContentProvider.this.mapElementToValueTreeNode.remove(this.node);
        }

        public void handleChange(ChangeEvent changeEvent) {
            if (UpdatableTreeContentProvider.this.isDisposed() || this.model == null) {
                return;
            }
            switch (changeEvent.getChangeType()) {
                case 256: {
                    this.doAdd((Collection)changeEvent.getNewValue());
                    break;
                }
                case 512: {
                    this.doRemove((Collection)changeEvent.getNewValue());
                    break;
                }
                case 64: {
                    this.setStale(this.node, (Boolean)changeEvent.getNewValue());
                }
            }
        }

        private void doAdd(Collection added) {
            if (added.isEmpty()) {
                return;
            }
            Iterator iter = added.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                UpdatableTreeContentProvider.this.createSubtree(this.node, object, false);
            }
            if (UpdatableTreeContentProvider.this.mapElementToValueTreeNode.containsKey(this.node)) {
                UpdatableTreeContentProvider.this.treeViewer.add(this.node, added.toArray());
            }
            UpdatableTreeContentProvider.this.doFireAdd(added);
        }

        private void doRemove(Collection removed) {
            if (removed.isEmpty()) {
                return;
            }
            ArrayList<Object> actuallyRemoved = new ArrayList<Object>();
            Iterator iter = removed.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!UpdatableTreeContentProvider.this.pruneSubtree(this.node, object)) continue;
                actuallyRemoved.add(this.node);
            }
            if (!UpdatableTreeContentProvider.this.treeViewer.getControl().isDisposed() && UpdatableTreeContentProvider.this.avoidViewerUpdates == 0) {
                if (UpdatableTreeContentProvider.this.mapElementToValueTreeNode.containsKey(this.node)) {
                    Method removeMethod = null;
                    boolean haveRemoveMethod32 = false;
                    try {
                        Class<?> clazz = UpdatableTreeContentProvider.this.treeViewer.getClass();
                        Class[] classArray = new Class[2];
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("java.lang.Object");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz2;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$1 = Class.forName("[Ljava.lang.Object;");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[1] = clazz3;
                        removeMethod = clazz.getDeclaredMethod("remove", classArray);
                        if (removeMethod != null) {
                            haveRemoveMethod32 = true;
                        }
                    }
                    catch (Exception exception) {}
                    if (haveRemoveMethod32) {
                        try {
                            removeMethod.invoke((Object)UpdatableTreeContentProvider.this.treeViewer, new Object[]{removed.toArray()});
                        }
                        catch (Exception exception) {
                            UpdatableTreeContentProvider.this.treeViewer.remove(removed.toArray());
                        }
                    } else {
                        UpdatableTreeContentProvider.this.treeViewer.remove(removed.toArray());
                    }
                }
                UpdatableTreeContentProvider.this.doFireRemove(actuallyRemoved);
            }
        }

        public boolean isDirty() {
            return this.model != null && this.model.isStale();
        }

        public Set getParents() {
            return this.parents;
        }
    }
}

