/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.viewers;

import java.util.Map;
import org.eclipse.jface.internal.databinding.viewers.StructuredViewerUpdatableValue;
import org.eclipse.jface.internal.databinding.viewers.TableViewerUpdatableCollectionExtended;
import org.eclipse.jface.internal.databinding.viewers.TreeViewerUpdatableTree;
import org.eclipse.jface.internal.databinding.viewers.TreeViewerUpdatableTreeExtended;
import org.eclipse.jface.internal.databinding.viewers.UpdatableCollectionViewer;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.IUpdatable;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableFactory;
import org.eclipse.jface.internal.provisional.databinding.Property;
import org.eclipse.jface.internal.provisional.databinding.viewers.TableViewerDescription;
import org.eclipse.jface.internal.provisional.databinding.viewers.TableViewerUpdatableTable;
import org.eclipse.jface.internal.provisional.databinding.viewers.TreeViewerDescription;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;

public final class ViewersUpdatableFactory
implements IUpdatableFactory {
    private int updateTime;

    public ViewersUpdatableFactory() {
    }

    public ViewersUpdatableFactory(int updateTime) {
        this.updateTime = updateTime;
    }

    public IUpdatable createUpdatable(Map properties, Object description, IDataBindingContext bindingContext) {
        if (description instanceof Property) {
            Object object = ((Property)description).getObject();
            Object attribute = ((Property)description).getPropertyID();
            if (object instanceof StructuredViewer && "single_selection".equals(attribute)) {
                return new StructuredViewerUpdatableValue((StructuredViewer)object, (String)attribute);
            }
            if (object instanceof AbstractListViewer && "single_selection".equals(attribute)) {
                return new StructuredViewerUpdatableValue((StructuredViewer)((AbstractListViewer)object), (String)attribute);
            }
            if (object instanceof AbstractListViewer && "content".equals(attribute)) {
                return new UpdatableCollectionViewer((AbstractListViewer)object);
            }
            if (object instanceof TableViewer && "content".equals(attribute)) {
                return new TableViewerUpdatableTable((TableViewer)object);
            }
            if (object instanceof TreeViewer && "content".equals(attribute)) {
                return new TreeViewerUpdatableTree((TreeViewer)object);
            }
        }
        if (description instanceof AbstractListViewer) {
            return new UpdatableCollectionViewer((AbstractListViewer)description);
        }
        if (description instanceof TableViewerDescription) {
            return new TableViewerUpdatableCollectionExtended((TableViewerDescription)description, bindingContext, this.updateTime);
        }
        if (description instanceof TreeViewerDescription) {
            return new TreeViewerUpdatableTreeExtended((TreeViewerDescription)description, bindingContext);
        }
        return null;
    }
}

