/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.quickfix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.ui.AptUIPlugin;
import org.eclipse.jdt.apt.ui.internal.quickfix.Messages;
import org.eclipse.jdt.apt.ui.quickfix.IAPTQuickFixProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTQuickFixProcessor
implements IQuickFixProcessor {
    private ListMap<String, IAPTQuickFixProvider> fFixProviders = new ListMap();

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 900;
    }

    public APTQuickFixProcessor() {
        this.loadProviders();
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        ListMap<String, IProblemLocation> locationMapByErrorCode = new ListMap<String, IProblemLocation>();
        ListMap<String, IProblemLocation> locationMapByPluginId = new ListMap<String, IProblemLocation>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = 0;
        int n2 = iProblemLocationArray.length;
        while (n < n2) {
            IProblemLocation location = iProblemLocationArray[n];
            if (location.getProblemId() == 900) {
                String[] arguments = location.getProblemArguments();
                assert (arguments.length >= 2);
                String pluginID = arguments[0];
                String errorCode = String.valueOf(pluginID) + "." + arguments[1];
                locationMapByErrorCode.put(errorCode, location);
                locationMapByPluginId.put(errorCode, location);
            }
            ++n;
        }
        for (String errorCode : locationMapByErrorCode.keySet()) {
            List<IProblemLocation> sortedLocations = locationMapByErrorCode.get(errorCode);
            this.addProposalsFromProviders(errorCode, context, sortedLocations, proposals);
        }
        for (String pluginId : locationMapByPluginId.keySet()) {
            List<IProblemLocation> sortedLocations = locationMapByPluginId.get(pluginId);
            this.addProposalsFromProviders(String.valueOf(pluginId) + "." + "*", context, sortedLocations, proposals);
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    private void addProposalsFromProviders(String key, IInvocationContext context, List<IProblemLocation> sortedLocations, List<IJavaCompletionProposal> proposals) throws CoreException {
        List<IAPTQuickFixProvider> providers = this.fFixProviders.get(key);
        for (IAPTQuickFixProvider fix : providers) {
            IJavaCompletionProposal[] fixProposals;
            IJavaCompletionProposal[] iJavaCompletionProposalArray = fixProposals = fix.getProposals(context, sortedLocations.toArray(new IProblemLocation[sortedLocations.size()]));
            int n = 0;
            int n2 = iJavaCompletionProposalArray.length;
            while (n < n2) {
                IJavaCompletionProposal fixProposal = iJavaCompletionProposalArray[n];
                proposals.add(fixProposal);
                ++n;
            }
        }
    }

    public void addQuickFixProvider(String pluginID, String errorCode, IAPTQuickFixProvider fix) {
        this.fFixProviders.put(String.valueOf(pluginID) + "." + errorCode, fix);
    }

    private void loadProviders() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.apt.ui", "aptQuickFixProvider");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IExtension extension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = 0;
            int n4 = iConfigurationElementArray.length;
            while (n3 < n4) {
                IConfigurationElement providerConfig = iConfigurationElementArray[n3];
                if ("quickFixProvider".equals(providerConfig.getName())) {
                    String pluginId = providerConfig.getAttribute("pluginId");
                    String errorCode = providerConfig.getAttribute("errorCode");
                    try {
                        Object object = providerConfig.createExecutableExtension("className");
                        if (object instanceof IAPTQuickFixProvider) {
                            IAPTQuickFixProvider provider = (IAPTQuickFixProvider)object;
                            this.addQuickFixProvider(pluginId, errorCode != null ? errorCode : "*", provider);
                        } else {
                            AptUIPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.apt.ui", 1, Messages.APTQuickFixProcessor_classMustBeIAPTQuickFixProvider, null));
                        }
                    }
                    catch (CoreException e) {
                        AptUIPlugin.log(e);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListMap<K, V> {
        private Map<K, List<V>> fData = new HashMap<K, List<V>>();

        ListMap() {
        }

        public void put(K key, V value) {
            List<V> list = this.fData.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                this.fData.put(key, list);
            }
            list.add(value);
        }

        public List<V> get(K key) {
            List<V> list = this.fData.get(key);
            return list != null ? list : Collections.emptyList();
        }

        public Set<K> keySet() {
            return this.fData.keySet();
        }
    }
}

