/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.cheatsheets.IEditableTask;
import org.eclipse.ui.cheatsheets.TaskEditor;
import org.eclipse.ui.cheatsheets.TaskExplorer;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.actions.IMenuContributor;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.SuccesorTaskFinder;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskEditorManager;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskExplorerManager;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.part.PageBook;

public class CompositeCheatSheetPage
extends Page
implements ISelectionChangedListener,
IMenuContributor {
    private static final String REVIEW_TAG = "Review:";
    private static final String NEXT_TASK_TAG = "Next:";
    private ManagedForm mform;
    private PageBook explorerContainer;
    private PageBook taskEditorContainer;
    private CompositeCheatSheetModel model;
    private TaskExplorer currentExplorer;
    private ScrolledFormText descriptionPanel;
    private ScrolledFormText completePanel;
    private CompositeCheatSheetSaveHelper saveHelper;
    private static final String START_HREF = "__start__";
    private static final String SKIP_HREF = "__skip__";
    private ICompositeCheatSheetTask selectedTask;

    public CompositeCheatSheetPage(CompositeCheatSheetModel model) {
        this.model = model;
        this.saveHelper = new CompositeCheatSheetSaveHelper();
    }

    public void createPart(Composite parent) {
        this.init(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        FormColors colors = this.toolkit.getColors();
        colors.initializeSectionToolBarColors();
        Color gbg = colors.getColor("org.eclipse.ui.forms.TB_GBG");
        Color bg = colors.getBackground();
        this.form.getForm().setTextBackground(new Color[]{bg, gbg}, new int[]{100}, true);
        this.form.getForm().setSeparatorColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        this.form.getForm().setSeparatorVisible(true);
        this.mform = new ManagedForm(this.toolkit, this.form);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        this.form.getBody().setLayout((Layout)glayout);
        final SashForm sash = new SashForm(this.form.getBody(), 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 10;
        gd.heightHint = 10;
        sash.setLayoutData((Object)gd);
        sash.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = sash.getSize();
                if (size.x > size.y) {
                    sash.setOrientation(256);
                } else {
                    sash.setOrientation(512);
                }
                CompositeCheatSheetPage.this.updateSashPanelMargins(sash);
            }
        });
        sash.setBackground(colors.getColor("org.eclipse.ui.forms.TB_GBG"));
        Composite explorerPanel = new Composite((Composite)sash, 0);
        explorerPanel.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        GridLayout playout = new GridLayout();
        playout.marginWidth = 0;
        playout.marginHeight = 0;
        explorerPanel.setLayout((Layout)playout);
        this.explorerContainer = new PageBook(explorerPanel, 0);
        this.explorerContainer.setLayoutData((Object)new GridData(1808));
        Composite editorPanel = new Composite((Composite)sash, 0);
        playout = new GridLayout();
        playout.marginWidth = 0;
        playout.marginHeight = 0;
        editorPanel.setLayout((Layout)playout);
        editorPanel.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        this.taskEditorContainer = new PageBook(editorPanel, 0);
        this.toolkit.adapt((Composite)this.taskEditorContainer);
        this.taskEditorContainer.setLayoutData((Object)new GridData(1808));
    }

    private void updateSashPanelMargins(SashForm sash) {
        Control[] children = sash.getChildren();
        int orientation = sash.getOrientation();
        GridLayout layout = (GridLayout)((Composite)children[0]).getLayout();
        if (orientation == 256) {
            layout.marginBottom = 0;
            layout.marginRight = 1;
        } else {
            layout.marginBottom = 1;
            layout.marginRight = 0;
        }
        layout = (GridLayout)((Composite)children[1]).getLayout();
        if (orientation == 256) {
            layout.marginTop = 0;
            layout.marginLeft = 1;
        } else {
            layout.marginTop = 1;
            layout.marginLeft = 0;
        }
        ((Composite)children[0]).layout();
        ((Composite)children[1]).layout();
    }

    public void dispose() {
        this.mform.dispose();
        super.dispose();
    }

    private void setInputModel(CompositeCheatSheetModel model) {
        this.model = model;
        this.mform.getForm().setText(model.getName());
        String explorerId = model.getTaskExplorerId();
        this.setCurrentExplorerFromId(explorerId);
        model.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ICompositeCheatSheetTask task = (ICompositeCheatSheetTask)arg;
                if (CompositeCheatSheetPage.this.currentExplorer != null) {
                    CompositeCheatSheetPage.this.currentExplorer.taskUpdated(task);
                }
                CompositeCheatSheetPage.this.updateTask(task);
            }
        });
    }

    private void setCurrentExplorerFromId(String explorerId) {
        TaskExplorer explorer = this.getTaskExplorer(explorerId);
        if (explorer != null) {
            explorer.setCompositeCheatSheet(this.model);
            explorer.setFocus();
            this.setExplorerVisible(explorerId);
        }
    }

    private void setExplorerVisible(String id) {
        Control[] excontrols = this.explorerContainer.getChildren();
        TaskExplorer explorer = null;
        int i = 0;
        while (i < excontrols.length) {
            Control excontrol = excontrols[i];
            explorer = (TaskExplorer)excontrol.getData("explorer");
            if (explorer.getId().equals(id)) {
                this.explorerContainer.showPage(excontrol);
                this.setCurrentExplorer(explorer);
                return;
            }
            ++i;
        }
    }

    private void setCurrentExplorer(TaskExplorer explorer) {
        if (this.currentExplorer != null) {
            this.currentExplorer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentExplorer = explorer;
        this.currentExplorer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateForSelection(this.currentExplorer.getSelectionProvider().getSelection());
    }

    private TaskExplorer getTaskExplorer(String id) {
        Control[] excontrols = this.explorerContainer.getChildren();
        TaskExplorer explorer = null;
        int i = 0;
        while (i < excontrols.length) {
            Control excontrol = excontrols[i];
            Object data = excontrol.getData("explorer");
            if (data instanceof TaskExplorer && (explorer = (TaskExplorer)data).getId().equals(id)) {
                return explorer;
            }
            ++i;
        }
        TaskExplorerManager explorerManager = TaskExplorerManager.getInstance();
        explorer = explorerManager.getExplorer(id);
        if (explorer != null) {
            explorer.createControl((Composite)this.explorerContainer, this.mform.getToolkit());
            explorer.getControl().setData("explorer", (Object)explorer);
        }
        return explorer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateForSelection(event.getSelection());
    }

    private void updateForSelection(ISelection selection) {
        this.selectedTask = (ICompositeCheatSheetTask)((IStructuredSelection)selection).getFirstElement();
        this.updateTask(this.selectedTask);
    }

    private void updateTask(ICompositeCheatSheetTask task) {
        if (task == null) {
            return;
        }
        int state = task.getState();
        switch (state) {
            case 0: {
                this.showDescription(task);
                break;
            }
            case 1: {
                if (task instanceof IEditableTask) {
                    this.showTaskEditor((EditableTask)task);
                    break;
                }
                this.showDescription(task);
                break;
            }
            case 2: 
            case 3: {
                this.showComplete(task);
            }
        }
    }

    private void showTaskEditor(EditableTask task) {
        this.startIfSelected(task);
        TaskEditor editor = this.getTaskEditor(task);
        if (editor != null) {
            this.setCurrentEditor((Control)editor.getControl().getParent());
        }
    }

    public void saveState() {
        this.saveHelper.saveCompositeState(this.model);
    }

    private void showDescription(ICompositeCheatSheetTask task) {
        FormText text;
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new ScrolledFormText((Composite)this.taskEditorContainer, false);
            this.mform.getToolkit().adapt((Control)this.descriptionPanel, false, false);
            text = this.mform.getToolkit().createFormText((Composite)this.descriptionPanel, true);
            text.marginWidth = 5;
            text.marginHeight = 5;
            text.setFont("header", JFaceResources.getHeaderFont());
            text.setColor("title", this.mform.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
            text.setImage("start", CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_START"));
            text.setImage("skip", CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_SKIP"));
            this.descriptionPanel.setFormText(text);
            text.addHyperlinkListener((IHyperlinkListener)new DescriptionLinkListener());
        } else {
            text = this.descriptionPanel.getFormText();
        }
        String desc = task.getDescription().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        buf.append("<p><span color=\"title\" font=\"header\">");
        buf.append(task.getName());
        buf.append("</span></p>");
        if (desc.charAt(0) != '<') {
            buf.append("<p>");
            buf.append(desc);
            buf.append("</p>");
        } else {
            buf.append(desc);
        }
        if (!task.requiredTasksCompleted()) {
            this.showBlockedTasks(task, buf);
        } else {
            if (task instanceof IEditableTask) {
                this.addStartHyperlink(buf);
            } else {
                this.showSuccesorTaskLinks(task, buf);
            }
            AbstractTask abstractTask = (AbstractTask)task;
            if (abstractTask.isSkippable()) {
                this.addSkipHyperlink(buf);
            }
        }
        buf.append("</form>");
        text.setText(buf.toString(), true, false);
        this.descriptionPanel.setData("task", (Object)task);
        this.descriptionPanel.reflow(true);
        this.setCurrentEditor((Control)this.descriptionPanel);
    }

    private void showBlockedTasks(ICompositeCheatSheetTask task, StringBuffer buf) {
        buf.append("<p/>");
        buf.append("<p>");
        buf.append("<b>");
        buf.append(Messages.COMPOSITE_PAGE_BLOCKED);
        buf.append("</b>");
        buf.append("</p>");
        ICompositeCheatSheetTask[] requiredTasks = task.getRequiredTasks();
        int i = 0;
        while (i < requiredTasks.length) {
            this.addIfIncomplete(buf, requiredTasks[i]);
            ++i;
        }
        buf.append("<p>");
        buf.append("</p>");
    }

    private void addSkipHyperlink(StringBuffer buf) {
        buf.append("<p/>");
        buf.append("<p><a href=\"");
        buf.append(SKIP_HREF);
        buf.append("\">");
        buf.append("<img href=\"skip\"/> ");
        buf.append(Messages.COMPOSITE_PAGE_SKIP_TASK);
        buf.append("</a></p>");
    }

    private void addStartHyperlink(StringBuffer buf) {
        buf.append("<p/>");
        buf.append("<p><a href=\"");
        buf.append(START_HREF);
        buf.append("\">");
        buf.append("<img href=\"start\"/> ");
        buf.append(Messages.COMPOSITE_PAGE_START_TASK);
        buf.append("</a></p>");
    }

    private void addIfIncomplete(StringBuffer buf, ICompositeCheatSheetTask task) {
        if (task.getState() != 3 && task.getState() != 2) {
            buf.append("<li>");
            String message = NLS.bind((String)Messages.COMPOSITE_PAGE_TASK_NOT_COMPLETE, (Object[])new Object[]{task.getName()});
            buf.append(message);
            buf.append("</li>");
        }
    }

    private void startIfSelected(ICompositeCheatSheetTask task) {
        TaskEditor editor;
        if (task == this.selectedTask && (editor = this.getTaskEditor(task)) != null) {
            this.setCurrentEditor(editor.getControl());
        }
    }

    private void setCurrentEditor(Control c) {
        this.taskEditorContainer.showPage(c);
    }

    private void checkForTaskLink(String ref) {
        if (ref.startsWith(NEXT_TASK_TAG)) {
            String next = ref.substring(NEXT_TASK_TAG.length());
            AbstractTask nextTask = this.model.getDependencies().getTask(next);
            this.currentExplorer.setSelection((ISelection)new StructuredSelection((Object)nextTask), true);
        }
    }

    private void showComplete(ICompositeCheatSheetTask task) {
        if (this.completePanel == null) {
            this.completePanel = new ScrolledFormText((Composite)this.taskEditorContainer, false);
            this.mform.getToolkit().adapt((Control)this.completePanel, false, false);
            FormText text = this.mform.getToolkit().createFormText((Composite)this.completePanel, true);
            text.marginWidth = 5;
            text.marginHeight = 5;
            text.setFont("header", JFaceResources.getHeaderFont());
            text.setColor("title", this.mform.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.completePanel.setFormText(text);
            text.addHyperlinkListener((IHyperlinkListener)new CompletionHyperlinkAdapter());
        }
        String desc = task.getCompletionMessage().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        buf.append("<p><span color=\"title\" font=\"header\">");
        buf.append(task.getName());
        buf.append("</span></p>");
        if (desc.charAt(0) != '<') {
            buf.append("<p>");
            buf.append(desc);
            buf.append("</p>");
        } else {
            buf.append(desc);
        }
        this.showSuccesorTaskLinks(task, buf);
        if (task instanceof IEditableTask) {
            buf.append("<p/>");
            buf.append("<p><a href=\"");
            buf.append(REVIEW_TAG);
            buf.append(task.getId());
            buf.append("\">");
            buf.append(Messages.COMPOSITE_PAGE_REVIEW_TASK);
            buf.append("</a></p>");
        }
        buf.append("</form>");
        this.completePanel.setText(buf.toString());
        this.completePanel.reflow(true);
        this.setCurrentEditor((Control)this.completePanel);
    }

    private void showSuccesorTaskLinks(ICompositeCheatSheetTask task, StringBuffer buf) {
        ICompositeCheatSheetTask[] successorTasks = new SuccesorTaskFinder(task).getRecommendedSuccessors();
        int i = 0;
        while (i < successorTasks.length) {
            this.addSuccessorTask(buf, successorTasks[i]);
            ++i;
        }
    }

    private void addSuccessorTask(StringBuffer buf, ICompositeCheatSheetTask task) {
        buf.append("<p/>");
        buf.append("<p><a href=\"");
        buf.append(NEXT_TASK_TAG);
        buf.append(task.getId());
        buf.append("\">");
        buf.append(NLS.bind((String)Messages.COMPOSITE_PAGE_GOTO_TASK, (Object[])new Object[]{task.getName()}));
        buf.append("</a></p>");
    }

    private TaskEditor getTaskEditor(ICompositeCheatSheetTask task) {
        if (task instanceof EditableTask) {
            TaskEditor editor;
            EditableTask editable = (EditableTask)task;
            if (editable.getEditor() == null && (editor = TaskEditorManager.getInstance().getEditor(task.getKind())) != null) {
                editor.createControl((Composite)this.taskEditorContainer, this.mform.getToolkit());
                editor.setInput(editable, this.model.getTaskMemento(task.getId()));
                editable.setEditor(editor);
            }
            return editable.getEditor();
        }
        return null;
    }

    public Control getControl() {
        return this.form;
    }

    protected String getTitle() {
        return this.model.getName();
    }

    public void initialized() {
        this.model.setSaveHelper(this.saveHelper);
        this.model.loadState();
        this.setInputModel(this.model);
    }

    public int contributeToViewMenu(Menu menu, int index) {
        index = this.contributeExplorerItem(menu, index);
        return this.contributeRestartItem(menu, index);
    }

    private int contributeRestartItem(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 8, index++);
        item.setText(Messages.RESTART_ALL_MENU);
        item.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompositeCheatSheetPage.this.model != null && MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.COMPOSITE_RESTART_DIALOG_TITLE, (String)Messages.COMPOSITE_RESTART_CONFIRM_MESSAGE)) {
                    CompositeCheatSheetPage.this.model.resetAllTasks();
                    CompositeCheatSheetPage.this.currentExplorer.setSelection((ISelection)new StructuredSelection((Object)CompositeCheatSheetPage.this.model.getRootTask()), true);
                }
            }
        });
        return index;
    }

    private int contributeExplorerItem(Menu menu, int index) {
        String[] explorerIds = CheatSheetRegistryReader.getInstance().getExplorerIds();
        if (explorerIds.length == 1) {
            return index;
        }
        MenuItem menuItem = new MenuItem(menu, 64, index++);
        menuItem.setText(Messages.EXPLORER_PULLDOWN_MENU);
        Menu subMenu = new Menu(menu);
        menuItem.setMenu(subMenu);
        int i = 0;
        while (i < explorerIds.length) {
            final String id = explorerIds[i];
            CheatSheetRegistryReader.TaskExplorerNode node = CheatSheetRegistryReader.getInstance().findTaskExplorer(id);
            boolean isCurrentExplorer = id.equals(this.currentExplorer.getId());
            int style = isCurrentExplorer ? 16 : 8;
            MenuItem item = new MenuItem(subMenu, style);
            item.setText(node.getName());
            item.setSelection(isCurrentExplorer);
            item.setImage(TaskExplorerManager.getInstance().getImage(id));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompositeCheatSheetPage.this.setCurrentExplorerFromId(id);
                }
            });
            ++i;
        }
        return index;
    }

    private final class DescriptionLinkListener
    extends HyperlinkAdapter {
        DescriptionLinkListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            AbstractTask task;
            Object data;
            String ref = (String)e.getHref();
            if (ref.equals(CompositeCheatSheetPage.START_HREF) && (data = CompositeCheatSheetPage.this.descriptionPanel.getData("task")) instanceof EditableTask) {
                task = (EditableTask)data;
                ((EditableTask)task).setStarted();
                CompositeCheatSheetPage.this.startIfSelected(task);
            }
            if (ref.equals(CompositeCheatSheetPage.SKIP_HREF) && (data = CompositeCheatSheetPage.this.descriptionPanel.getData("task")) instanceof AbstractTask) {
                task = (AbstractTask)data;
                task.setState(2);
            }
            CompositeCheatSheetPage.this.checkForTaskLink(ref);
        }
    }

    private final class CompletionHyperlinkAdapter
    extends HyperlinkAdapter {
        CompletionHyperlinkAdapter() {
        }

        public void linkActivated(HyperlinkEvent e) {
            String ref = (String)e.getHref();
            if (ref.startsWith(CompositeCheatSheetPage.REVIEW_TAG)) {
                String review = ref.substring(CompositeCheatSheetPage.REVIEW_TAG.length());
                AbstractTask reviewTask = CompositeCheatSheetPage.this.model.getDependencies().getTask(review);
                if (reviewTask instanceof EditableTask) {
                    CompositeCheatSheetPage.this.showTaskEditor((EditableTask)reviewTask);
                }
            }
            CompositeCheatSheetPage.this.checkForTaskLink(ref);
        }
    }
}

