/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointFieldChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;

public class BreakpointRenameFieldParticipant
extends BreakpointRenameParticipant {
    protected boolean accepts(IJavaElement element) {
        return element instanceof IField;
    }

    protected void gatherChanges(IMarker[] markers, List changes, String destFieldName) throws CoreException, OperationCanceledException {
        IField originalField = (IField)this.getOriginalElement();
        int i = 0;
        while (i < markers.length) {
            IJavaWatchpoint watchpoint;
            IType breakpointType;
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaWatchpoint && (breakpointType = BreakpointUtils.getType((IJavaBreakpoint)(watchpoint = (IJavaWatchpoint)breakpoint))) != null && originalField.getDeclaringType().equals(breakpointType)) {
                IField destField = originalField.getDeclaringType().getField(destFieldName);
                changes.add(new WatchpointFieldChange(watchpoint, destField, originalField));
            }
            ++i;
        }
    }
}

