/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.core.refactoring.JDTDebugRefactoringUtil;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;

public class LaunchConfigurationITypeMoveParticipant
extends MoveParticipant {
    private IType fType;
    private IJavaElement fDestination;

    protected boolean initialize(Object element) {
        this.fType = (IType)element;
        try {
            IType declaringType = this.fType;
            while (declaringType != null) {
                if (this.fType.isLocal()) {
                    return false;
                }
                declaringType = declaringType.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        Object destination = this.getArguments().getDestination();
        if (destination instanceof IPackageFragment || destination instanceof IType) {
            this.fDestination = (IJavaElement)destination;
            return true;
        }
        return false;
    }

    public String getName() {
        return RefactoringMessages.LaunchConfigurationParticipant_0;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        return JDTDebugRefactoringUtil.createChangesForTypeMove(this.fType, this.fDestination);
    }
}

