/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.LineBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class LineBreakpointTypeChange
extends LineBreakpointChange {
    private IType fDestType;
    private IType fOriginalType;

    public LineBreakpointTypeChange(IJavaLineBreakpoint breakpoint, IType destType, IType originalType) throws CoreException {
        super(breakpoint);
        this.fDestType = destType;
        this.fOriginalType = originalType;
    }

    public String getName() {
        return RefactoringMessages.LineBreakpointTypeChange_0;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)this.fDestType);
        HashMap map = new HashMap();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)this.fDestType);
        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)this.fDestType.getFullyQualifiedName(), (int)this.getLineNumber(), (int)this.getCharStart(), (int)this.getCharEnd(), (int)0, (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

