/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class WatchpointFieldChange
extends WatchpointChange {
    private IField fDestField;
    private IField fOriginalField;

    public WatchpointFieldChange(IJavaWatchpoint watchpoint, IField destField, IField originalField) throws CoreException {
        super(watchpoint);
        this.fDestField = destField;
        this.fOriginalField = originalField;
    }

    public String getName() {
        return RefactoringMessages.WatchpointFieldChange_0;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        HashMap map = new HashMap();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)this.fDestField);
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)this.fDestField);
        IJavaWatchpoint breakpoint = JDIDebugModel.createWatchpoint((IResource)resource, (String)this.fDestField.getDeclaringType().getFullyQualifiedName(), (String)this.fDestField.getElementName(), (int)this.getLineNumber(), (int)this.getCharStart(), (int)this.getCharEnd(), (int)0, (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

