/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIPlaceholderVariable;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.internal.debug.ui.actions.PrimitiveOptionsAction;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class JavaDebugHover
implements IJavaEditorTextHover,
ITextHoverExtension {
    private IEditorPart fEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    protected IJavaStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IJavaStackFrame)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IJavaStackFrame frame = this.getFrame();
        if (frame != null) {
            block56: {
                IDocument document = textViewer.getDocument();
                if (document != null) {
                    try {
                        String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (!variableName.equals("this")) break block56;
                        try {
                            IJavaVariable variable = frame.findVariable(variableName);
                            if (variable != null) {
                                return JavaDebugHover.getVariableText((IVariable)variable);
                            }
                        }
                        catch (DebugException debugException) {
                            return null;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            ICodeAssist codeAssist = null;
            if (this.fEditor != null) {
                IEditorInput input = this.fEditor.getEditorInput();
                Object element = JavaUI.getWorkingCopyManager().getWorkingCopy(input);
                if (element == null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jdt.core.IClassFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    element = input.getAdapter((Class)clazz);
                }
                if (element instanceof ICodeAssist) {
                    codeAssist = (ICodeAssist)element;
                }
            }
            if (codeAssist == null) {
                return this.getRemoteHoverInfo(frame, textViewer, hoverRegion);
            }
            IJavaElement[] resolve = null;
            try {
                resolve = codeAssist.codeSelect(hoverRegion.getOffset(), 0);
            }
            catch (JavaModelException javaModelException) {
                resolve = new IJavaElement[]{};
            }
            try {
                int i = 0;
                while (i < resolve.length) {
                    IJavaElement javaElement = resolve[i];
                    if (javaElement instanceof IField) {
                        IField field = (IField)javaElement;
                        IJavaFieldVariable variable = null;
                        IJavaDebugTarget debugTarget = (IJavaDebugTarget)frame.getDebugTarget();
                        if (Flags.isStatic((int)field.getFlags())) {
                            IJavaType[] javaTypes = debugTarget.getJavaTypes(field.getDeclaringType().getFullyQualifiedName());
                            if (javaTypes != null) {
                                int j = 0;
                                while (j < javaTypes.length) {
                                    IJavaType type = javaTypes[j];
                                    if (type instanceof IJavaReferenceType) {
                                        IJavaReferenceType referenceType = (IJavaReferenceType)type;
                                        variable = referenceType.getField(field.getElementName());
                                    }
                                    if (variable != null) break;
                                    ++j;
                                }
                            }
                            if (variable == null) {
                                Object constant = field.getConstant();
                                if (constant != null) {
                                    IJavaValue value = null;
                                    if (constant instanceof Integer) {
                                        value = debugTarget.newValue(((Integer)constant).intValue());
                                    } else if (constant instanceof Byte) {
                                        value = debugTarget.newValue(((Byte)constant).byteValue());
                                    } else if (constant instanceof Boolean) {
                                        value = debugTarget.newValue(((Boolean)constant).booleanValue());
                                    } else if (constant instanceof Character) {
                                        value = debugTarget.newValue(((Character)constant).charValue());
                                    } else if (constant instanceof Double) {
                                        value = debugTarget.newValue(((Double)constant).doubleValue());
                                    } else if (constant instanceof Float) {
                                        value = debugTarget.newValue(((Float)constant).floatValue());
                                    } else if (constant instanceof Long) {
                                        value = debugTarget.newValue(((Long)constant).longValue());
                                    } else if (constant instanceof Short) {
                                        value = debugTarget.newValue(((Short)constant).shortValue());
                                    } else if (constant instanceof String) {
                                        value = debugTarget.newValue((String)constant);
                                    }
                                    if (value != null) {
                                        variable = new JDIPlaceholderVariable(field.getElementName(), value);
                                    }
                                }
                                if (variable == null) {
                                    return null;
                                }
                            }
                        } else if (!frame.isStatic()) {
                            String typeSignature = Signature.createTypeSignature((String)field.getDeclaringType().getFullyQualifiedName(), (boolean)true);
                            typeSignature = typeSignature.replace('.', '/');
                            variable = frame.getThis().getField(field.getElementName(), typeSignature);
                        }
                        if (variable != null) {
                            return JavaDebugHover.getVariableText(variable);
                        }
                        break;
                    }
                    if (javaElement instanceof ILocalVariable) {
                        ILocalVariable var = (ILocalVariable)javaElement;
                        IJavaElement parent = var.getParent();
                        while (!(parent instanceof IMethod) && parent != null) {
                            parent = parent.getParent();
                        }
                        if (parent instanceof IMethod) {
                            IMethod method = (IMethod)parent;
                            boolean equal = false;
                            if (method.isBinary()) {
                                if (method.getSignature().equals(frame.getSignature())) {
                                    equal = true;
                                }
                            } else if ((frame.isConstructor() && method.isConstructor() || frame.getMethodName().equals(method.getElementName())) && frame.getDeclaringTypeName().endsWith(method.getDeclaringType().getElementName()) && frame.getArgumentTypeNames().size() == method.getNumberOfParameters()) {
                                equal = true;
                            }
                            if (equal) {
                                return this.generateHoverForLocal(frame, var.getElementName());
                            }
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JDIDebugPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    private String getRemoteHoverInfo(IJavaStackFrame frame, ITextViewer textViewer, IRegion hoverRegion) {
        if (frame != null) {
            try {
                IDocument document = textViewer.getDocument();
                if (document != null) {
                    String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    return this.generateHoverForLocal(frame, variableName);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private String generateHoverForLocal(IJavaStackFrame frame, String varName) {
        String variableText;
        block3: {
            variableText = null;
            try {
                IJavaVariable variable = frame.findVariable(varName);
                if (variable != null) {
                    variableText = JavaDebugHover.getVariableText((IVariable)variable);
                }
            }
            catch (DebugException x) {
                if (x.getStatus().getCode() == 100) break block3;
                JDIDebugUIPlugin.log(x);
            }
        }
        return variableText;
    }

    private static String getVariableText(IVariable variable) {
        StringBuffer buffer = new StringBuffer();
        JDIModelPresentation modelPresentation = JavaDebugHover.getModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getVariableText((IJavaVariable)variable);
        buffer.append(JavaDebugHover.replaceHTMLChars(variableText));
        buffer.append("</pre></p>");
        modelPresentation.dispose();
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static JDIModelPresentation getModelPresentation() {
        JDIModelPresentation presentation = new JDIModelPresentation();
        String[][] booleanPrefs = new String[][]{{IJDIPreferencesConstants.PREF_SHOW_HEX, "SHOW_HEX_VALUES"}, {IJDIPreferencesConstants.PREF_SHOW_CHAR, "SHOW_CHAR_VALUES"}, {IJDIPreferencesConstants.PREF_SHOW_UNSIGNED, "SHOW_UNSIGNED_VALUES"}, {IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES, "DISPLAY_QUALIFIED_NAMES"}};
        String viewId = "org.eclipse.debug.ui.VariableView";
        int i = 0;
        while (i < booleanPrefs.length) {
            boolean preferenceValue = PrimitiveOptionsAction.getBooleanPreferenceValue(viewId, booleanPrefs[i][0]);
            presentation.setAttribute(booleanPrefs[i][1], preferenceValue ? Boolean.TRUE : Boolean.FALSE);
            ++i;
        }
        return presentation;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), DebugUIMessages.JavaDebugHover_16);
                }
            };
        }
        return null;
    }
}

