/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddExceptionDialogExtension
extends TypeSelectionExtension {
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private boolean fCaught = false;
    private boolean fUncaught = false;

    public AddExceptionDialogExtension(boolean caught, boolean uncaught) {
        this.fCaught = caught;
        this.fUncaught = uncaught;
    }

    public Control createContentArea(Composite parent) {
        super.createContentArea(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(768));
        this.fCaughtButton = new Button(comp, 32);
        this.fCaughtButton.setLayoutData((Object)new GridData(768));
        this.fCaughtButton.setFont(comp.getFont());
        this.fCaughtButton.setText(BreakpointMessages.AddExceptionDialog_15);
        this.fCaughtButton.setSelection(this.fCaught);
        this.fCaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddExceptionDialogExtension.this.fCaught = AddExceptionDialogExtension.this.fCaughtButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fUncaughtButton = new Button(comp, 32);
        this.fUncaughtButton.setLayoutData((Object)new GridData(768));
        this.fUncaughtButton.setFont(comp.getFont());
        this.fUncaughtButton.setText(BreakpointMessages.AddExceptionDialog_16);
        this.fUncaughtButton.setSelection(this.fUncaught);
        this.fUncaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddExceptionDialogExtension.this.fUncaught = AddExceptionDialogExtension.this.fUncaughtButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return comp;
    }

    public boolean catchExceptions() {
        return this.fCaught;
    }

    public ISelectionStatusValidator getSelectionValidator() {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IType type = null;
                int i = 0;
                while (i < selection.length) {
                    type = (IType)selection[i];
                    if (!AddExceptionDialogExtension.this.isException(type)) {
                        return new StatusInfo(4, BreakpointMessages.AddExceptionDialogExtension_0);
                    }
                    ++i;
                }
                return new StatusInfo(0, "");
            }
        };
        return validator;
    }

    protected boolean isException(IType type) {
        if (type != null) {
            try {
                ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType curr = type;
                while (curr != null) {
                    if ("java.lang.Throwable".equals(curr.getFullyQualifiedName('.'))) {
                        return true;
                    }
                    curr = hierarchy.getSuperclass(curr);
                }
            }
            catch (JavaModelException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return false;
    }

    public boolean uncaughtExceptions() {
        return this.fUncaught;
    }
}

