/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.jres.ExecutionEnvironmentsPreferencePage;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsPreferencePage;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class JREsComboBlock {
    public static final String PROPERTY_JRE = "PROPERTY_JRE";
    private Composite fControl;
    private List fVMs = new ArrayList();
    private Combo fCombo;
    private Button fManageButton;
    private ListenerList fListeners = new ListenerList();
    private JREDescriptor fDefaultDescriptor = null;
    private JREDescriptor fSpecificDescriptor = null;
    private Button fDefaultButton = null;
    private Button fSpecificButton = null;
    private String fTitle = null;
    private Button fEnvironmentsButton = null;
    private Combo fEnvironmentsCombo = null;
    private Button fManageEnvironmentsButton = null;
    private List fEnvironments = new ArrayList();
    private IStatus fStatus = OK_STATUS;
    private static IStatus OK_STATUS = new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, "", null);

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void firePropertyChange() {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_JRE, null, (Object)this.getPath());
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        GridData data;
        Font font = ancestor.getFont();
        Composite comp = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fControl = comp;
        comp.setFont(font);
        Group group = new Group(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        if (this.fTitle == null) {
            this.fTitle = JREMessages.JREsComboBlock_3;
        }
        group.setText(this.fTitle);
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton = new Button((Composite)group, 16);
            this.fDefaultButton.setText(this.fDefaultDescriptor.getDescription());
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (JREsComboBlock.this.fDefaultButton.getSelection()) {
                        JREsComboBlock.this.setUseDefaultJRE();
                        JREsComboBlock.this.setStatus(OK_STATUS);
                        JREsComboBlock.this.firePropertyChange();
                    }
                }
            });
            data = new GridData();
            data.horizontalSpan = 3;
            this.fDefaultButton.setLayoutData((Object)data);
            this.fDefaultButton.setFont(font);
        }
        this.fSpecificButton = new Button((Composite)group, 16);
        if (this.fSpecificDescriptor != null) {
            this.fSpecificButton.setText(this.fSpecificDescriptor.getDescription());
        } else {
            this.fSpecificButton.setText(JREMessages.JREsComboBlock_1);
        }
        this.fSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JREsComboBlock.this.fSpecificButton.getSelection()) {
                    JREsComboBlock.this.fCombo.setEnabled(true);
                    if (JREsComboBlock.this.fCombo.getText().length() == 0 && !JREsComboBlock.this.fVMs.isEmpty()) {
                        JREsComboBlock.this.fCombo.select(0);
                    }
                    if (JREsComboBlock.this.fVMs.isEmpty()) {
                        JREsComboBlock.this.setError(JREMessages.JREsComboBlock_0);
                    } else {
                        JREsComboBlock.this.setStatus(OK_STATUS);
                    }
                    JREsComboBlock.this.fEnvironmentsCombo.setEnabled(false);
                    JREsComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fSpecificButton.setFont(font);
        data = new GridData(1);
        this.fSpecificButton.setLayoutData((Object)data);
        this.fCombo = new Combo((Composite)group, 12);
        this.fCombo.setFont(font);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fCombo.setLayoutData((Object)data);
        ControlAccessibleListener.addListener((Control)this.fCombo, this.fSpecificButton.getText());
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREsComboBlock.this.firePropertyChange();
            }
        });
        this.fManageButton = this.createPushButton((Composite)group, JREMessages.JREsComboBlock_2);
        this.fManageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JREsPreferencePage page = new JREsPreferencePage();
                JREsComboBlock.this.showPrefPage("org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (IPreferencePage)page);
            }
        });
        this.fillWithWorkspaceJREs();
        this.fEnvironmentsButton = new Button((Composite)group, 16);
        this.fEnvironmentsButton.setText(JREMessages.JREsComboBlock_4);
        this.fEnvironmentsButton.setFont(font);
        this.fEnvironmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JREsComboBlock.this.fEnvironmentsButton.getSelection()) {
                    JREsComboBlock.this.fCombo.setEnabled(false);
                    if (JREsComboBlock.this.fEnvironmentsCombo.getText().length() == 0 && !JREsComboBlock.this.fEnvironments.isEmpty()) {
                        JREsComboBlock.this.fEnvironmentsCombo.select(0);
                    }
                    JREsComboBlock.this.fEnvironmentsCombo.setEnabled(true);
                    if (JREsComboBlock.this.fEnvironments.isEmpty()) {
                        JREsComboBlock.this.setError(JREMessages.JREsComboBlock_5);
                    } else {
                        JREsComboBlock.this.setStatus(OK_STATUS);
                    }
                    JREsComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fEnvironmentsCombo = new Combo((Composite)group, 12);
        this.fEnvironmentsCombo.setFont(font);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fEnvironmentsCombo.setLayoutData((Object)data);
        this.fEnvironmentsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREsComboBlock.this.setPath(JavaRuntime.newJREContainerPath((IExecutionEnvironment)JREsComboBlock.this.getEnvironment()));
                JREsComboBlock.this.firePropertyChange();
            }
        });
        this.fManageEnvironmentsButton = this.createPushButton((Composite)group, JREMessages.JREsComboBlock_14);
        this.fManageEnvironmentsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionEnvironmentsPreferencePage page = new ExecutionEnvironmentsPreferencePage();
                JREsComboBlock.this.showPrefPage("org.eclipse.jdt.debug.ui.jreProfiles", (IPreferencePage)page);
            }
        });
        this.fillWithWorkspaceProfiles();
    }

    private void showPrefPage(String id, IPreferencePage page) {
        IVMInstall prevJRE = this.getJRE();
        IExecutionEnvironment prevEnv = this.getEnvironment();
        JDIDebugUIPlugin.showPreferencePage(id, page);
        this.fillWithWorkspaceJREs();
        this.fillWithWorkspaceProfiles();
        this.restoreCombo(this.fVMs, prevJRE, this.fCombo);
        this.restoreCombo(this.fEnvironments, prevEnv, this.fEnvironmentsCombo);
        this.setDefaultJREDescriptor(this.fDefaultDescriptor);
        if (this.isDefaultJRE()) {
            this.setUseDefaultJRE();
        }
        this.setPath(this.getPath());
        this.firePropertyChange();
    }

    private void restoreCombo(List elements, Object element, Combo combo) {
        int index = -1;
        if (element != null) {
            index = elements.indexOf(element);
        }
        if (index >= 0) {
            combo.select(index);
        } else {
            combo.select(0);
        }
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setJREs(List jres) {
        this.fVMs.clear();
        this.fVMs.addAll(jres);
        Collections.sort(this.fVMs, new Comparator(){

            public int compare(Object o1, Object o2) {
                IVMInstall left = (IVMInstall)o1;
                IVMInstall right = (IVMInstall)o2;
                return left.getName().compareToIgnoreCase(right.getName());
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        String[] names = new String[this.fVMs.size()];
        Iterator iter = this.fVMs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IVMInstall vm = (IVMInstall)iter.next();
            names[i] = vm.getName();
            ++i;
        }
        this.fCombo.setItems(names);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private void selectJRE(IVMInstall vm) {
        this.fSpecificButton.setSelection(true);
        this.fDefaultButton.setSelection(false);
        this.fEnvironmentsButton.setSelection(false);
        this.fCombo.setEnabled(true);
        this.fEnvironmentsCombo.setEnabled(false);
        int index = this.fVMs.indexOf(vm);
        if (index >= 0) {
            this.fCombo.select(index);
        }
        this.firePropertyChange();
    }

    private void selectEnvironment(IExecutionEnvironment env) {
        this.fSpecificButton.setSelection(false);
        this.fDefaultButton.setSelection(false);
        this.fCombo.setEnabled(false);
        this.fEnvironmentsButton.setSelection(true);
        this.fEnvironmentsCombo.setEnabled(true);
        int index = this.fEnvironments.indexOf(env);
        if (index >= 0) {
            this.fEnvironmentsCombo.select(index);
        }
        this.firePropertyChange();
    }

    public IVMInstall getJRE() {
        int index = this.fCombo.getSelectionIndex();
        if (index >= 0) {
            return (IVMInstall)this.fVMs.get(index);
        }
        return null;
    }

    private IExecutionEnvironment getEnvironment() {
        int index = this.fEnvironmentsCombo.getSelectionIndex();
        if (index >= 0) {
            return (IExecutionEnvironment)this.fEnvironments.get(index);
        }
        return null;
    }

    protected void fillWithWorkspaceJREs() {
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        this.setJREs(standins);
    }

    protected void fillWithWorkspaceProfiles() {
        this.fEnvironments.clear();
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int i = 0;
        while (i < environments.length) {
            this.fEnvironments.add(environments[i]);
            ++i;
        }
        Collections.sort(this.fEnvironments, new Comparator(){

            public int compare(Object o1, Object o2) {
                IExecutionEnvironment left = (IExecutionEnvironment)o1;
                IExecutionEnvironment right = (IExecutionEnvironment)o2;
                return left.getId().compareToIgnoreCase(right.getId());
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        String[] names = new String[this.fEnvironments.size()];
        Iterator iter = this.fEnvironments.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            IExecutionEnvironment env = (IExecutionEnvironment)iter.next();
            names[i2] = env.getId();
            ++i2;
        }
        this.fEnvironmentsCombo.setItems(names);
    }

    public void setDefaultJREDescriptor(JREDescriptor descriptor) {
        this.fDefaultDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fDefaultButton, descriptor);
    }

    private void setButtonTextFromDescriptor(Button button, JREDescriptor descriptor) {
        if (button != null) {
            String currentText = button.getText();
            String newText = descriptor.getDescription();
            if (!newText.equals(currentText)) {
                button.setText(newText);
                this.fControl.layout();
            }
        }
    }

    public void setSpecificJREDescriptor(JREDescriptor descriptor) {
        this.fSpecificDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fSpecificButton, descriptor);
    }

    public boolean isDefaultJRE() {
        if (this.fDefaultButton != null) {
            return this.fDefaultButton.getSelection();
        }
        return false;
    }

    public void setUseDefaultJRE() {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton.setSelection(true);
            this.fSpecificButton.setSelection(false);
            this.fEnvironmentsButton.setSelection(false);
            this.fCombo.setEnabled(false);
            this.fEnvironmentsCombo.setEnabled(false);
            this.firePropertyChange();
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void refresh() {
        this.setDefaultJREDescriptor(this.fDefaultDescriptor);
    }

    public IPath getPath() {
        if (this.fEnvironmentsButton.getSelection()) {
            int index = this.fEnvironmentsCombo.getSelectionIndex();
            if (index >= 0) {
                IExecutionEnvironment env = (IExecutionEnvironment)this.fEnvironments.get(index);
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
            }
            return null;
        }
        if (this.fSpecificButton.getSelection()) {
            int index = this.fCombo.getSelectionIndex();
            if (index >= 0) {
                IVMInstall vm = (IVMInstall)this.fVMs.get(index);
                return JavaRuntime.newJREContainerPath((IVMInstall)vm);
            }
            return null;
        }
        return JavaRuntime.newDefaultJREContainerPath();
    }

    public void setPath(IPath containerPath) {
        this.setStatus(OK_STATUS);
        if (JavaRuntime.newDefaultJREContainerPath().equals((Object)containerPath)) {
            this.setUseDefaultJRE();
        } else {
            String envId = JavaRuntime.getExecutionEnvironmentId((IPath)containerPath);
            if (envId != null) {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment environment = manager.getEnvironment(envId);
                if (environment == null) {
                    this.setError(MessageFormat.format(JREMessages.JREsComboBlock_6, envId));
                } else {
                    this.selectEnvironment(environment);
                    IVMInstall[] installs = environment.getCompatibleVMs();
                    if (installs.length == 0) {
                        this.setError(MessageFormat.format(JREMessages.JREsComboBlock_7, environment.getId()));
                    }
                }
            } else {
                IVMInstall install = JavaRuntime.getVMInstall((IPath)containerPath);
                if (install == null) {
                    String installTypeId = JavaRuntime.getVMInstallTypeId((IPath)containerPath);
                    if (installTypeId == null) {
                        this.setError(JREMessages.JREsComboBlock_8);
                    } else {
                        IVMInstallType installType = JavaRuntime.getVMInstallType((String)installTypeId);
                        if (installType == null) {
                            this.setError(MessageFormat.format(JREMessages.JREsComboBlock_9, installTypeId));
                        } else {
                            String installName = JavaRuntime.getVMInstallName((IPath)containerPath);
                            if (installName == null) {
                                this.setError(MessageFormat.format(JREMessages.JREsComboBlock_10, installType.getName()));
                            } else {
                                this.setError(MessageFormat.format(JREMessages.JREsComboBlock_11, installName, installType.getName()));
                            }
                        }
                    }
                } else {
                    this.selectJRE(install);
                    File location = install.getInstallLocation();
                    if (location == null) {
                        this.setError(JREMessages.JREsComboBlock_12);
                    } else if (!location.exists()) {
                        this.setError(JREMessages.JREsComboBlock_13);
                    }
                }
            }
        }
    }

    private void setError(String message) {
        this.setStatus((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    private void setStatus(IStatus status) {
        this.fStatus = status;
    }
}

