/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class LibraryContentProvider
implements ITreeContentProvider {
    private Viewer fViewer;
    private HashMap fChildren = new HashMap();
    private LibraryLocation[] fLibraries = new LibraryLocation[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.fLibraries;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LibraryLocation) {
            LibraryLocation libraryLocation = (LibraryLocation)parentElement;
            Object[] children = (Object[])this.fChildren.get(libraryLocation);
            if (children == null) {
                children = new Object[]{new SubElement(libraryLocation, 2), new SubElement(libraryLocation, 1)};
                this.fChildren.put(libraryLocation, children);
            }
            return children;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof SubElement) {
            return ((SubElement)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof LibraryLocation;
    }

    public void setLibraries(LibraryLocation[] libs) {
        this.fLibraries = libs;
        this.fViewer.refresh();
    }

    public LibraryLocation[] getLibraries() {
        return this.fLibraries;
    }

    private Set getSelectedLibraries(IStructuredSelection selection) {
        HashSet libraries = new HashSet();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof LibraryLocation) {
                libraries.add(element);
                continue;
            }
            if (!(element instanceof SubElement)) continue;
            libraries.add(((SubElement)element).getParent());
        }
        return libraries;
    }

    public void up(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        int i = 0;
        while (i < this.fLibraries.length - 1) {
            if (libraries.contains(this.fLibraries[i + 1])) {
                LibraryLocation temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i + 1];
                this.fLibraries[i + 1] = temp;
            }
            ++i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void down(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        int i = this.fLibraries.length - 1;
        while (i > 0) {
            if (libraries.contains(this.fLibraries[i - 1])) {
                LibraryLocation temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i - 1];
                this.fLibraries[i - 1] = temp;
            }
            --i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void remove(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length - libraries.size()];
        int k = 0;
        int i = 0;
        while (i < this.fLibraries.length) {
            if (!libraries.contains(this.fLibraries[i])) {
                newLibraries[k++] = this.fLibraries[i];
            }
            ++i;
        }
        this.fLibraries = newLibraries;
        this.fViewer.refresh();
    }

    public void add(LibraryLocation[] libs, IStructuredSelection selection) {
        LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length + libs.length];
        if (selection.isEmpty()) {
            System.arraycopy(this.fLibraries, 0, newLibraries, 0, this.fLibraries.length);
            System.arraycopy(libs, 0, newLibraries, this.fLibraries.length, libs.length);
        } else {
            Object element = selection.getFirstElement();
            LibraryLocation firstLib = element instanceof LibraryLocation ? (LibraryLocation)element : ((SubElement)element).getParent();
            int i = 0;
            while (i < this.fLibraries.length && this.fLibraries[i] != firstLib) {
                newLibraries[i] = this.fLibraries[i++];
            }
            System.arraycopy(libs, 0, newLibraries, i, libs.length);
            System.arraycopy(this.fLibraries, i, newLibraries, i + libs.length, this.fLibraries.length - i);
        }
        this.fLibraries = newLibraries;
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object[])libs), true);
    }

    public void setJavadoc(URL javadocLocation, IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length];
        Object[] newSelection = new Object[libraries.size()];
        int j = 0;
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation library = this.fLibraries[i];
            if (libraries.contains(library)) {
                LibraryLocation lib = new LibraryLocation(library.getSystemLibraryPath(), library.getSystemLibrarySourcePath(), library.getPackageRootPath(), javadocLocation);
                newSelection[j++] = this.getChildren(lib)[1];
                newLibraries[i] = lib;
            } else {
                newLibraries[i] = library;
            }
            ++i;
        }
        this.fLibraries = newLibraries;
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection(newSelection));
    }

    public void setSourcePath(IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length];
        Object[] newSelection = new Object[libraries.size()];
        int j = 0;
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation library = this.fLibraries[i];
            if (libraries.contains(library)) {
                if (sourceAttachmentPath == null) {
                    sourceAttachmentPath = Path.EMPTY;
                }
                if (sourceAttachmentRootPath == null) {
                    sourceAttachmentRootPath = Path.EMPTY;
                }
                LibraryLocation lib = new LibraryLocation(library.getSystemLibraryPath(), sourceAttachmentPath, sourceAttachmentRootPath, library.getJavadocLocation());
                newSelection[j++] = this.getChildren(lib)[1];
                newLibraries[i] = lib;
            } else {
                newLibraries[i] = library;
            }
            ++i;
        }
        this.fLibraries = newLibraries;
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection(newSelection));
    }

    public class SubElement {
        public static final int JAVADOC_URL = 1;
        public static final int SOURCE_PATH = 2;
        private LibraryLocation fParent;
        private int fType;

        public SubElement(LibraryLocation parent, int type) {
            this.fParent = parent;
            this.fType = type;
        }

        public LibraryLocation getParent() {
            return this.fParent;
        }

        public int getType() {
            return this.fType;
        }
    }
}

