/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.contentassist.TypeContext;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaLineBreakpointPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;

public class BreakpointConditionEditor {
    private JDISourceViewer fViewer;
    private IContentAssistProcessor fCompletionProcessor;
    private boolean fIsValid;
    private String fOldValue;
    private String fErrorMessage;
    private JavaLineBreakpointPage fPage;
    private IJavaLineBreakpoint fBreakpoint;
    private HandlerSubmission submission;
    private IDocumentListener fDocumentListener;

    public BreakpointConditionEditor(Composite parent, JavaLineBreakpointPage page) {
        String condition;
        this.fPage = page;
        this.fBreakpoint = (IJavaLineBreakpoint)this.fPage.getBreakpoint();
        try {
            condition = this.fBreakpoint.getCondition();
        }
        catch (CoreException exception) {
            JDIDebugUIPlugin.log(exception);
            return;
        }
        this.fErrorMessage = PropertyPageMessages.BreakpointConditionEditor_1;
        this.fOldValue = "";
        this.fViewer = new JDISourceViewer(parent, null, 2816);
        this.fViewer.setInput(parent);
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        TypeContext context = null;
        IType type = BreakpointUtils.getType((IJavaBreakpoint)this.fBreakpoint);
        if (type == null) {
            context = new TypeContext(null, -1);
        } else {
            try {
                String source = null;
                ICompilationUnit compilationUnit = type.getCompilationUnit();
                if (compilationUnit != null) {
                    source = compilationUnit.getSource();
                } else {
                    IClassFile classFile = type.getClassFile();
                    if (classFile != null) {
                        source = classFile.getSource();
                    }
                }
                int lineNumber = this.fBreakpoint.getMarker().getAttribute("lineNumber", -1);
                int position = -1;
                if (source != null && lineNumber != -1) {
                    try {
                        position = new Document(source).getLineOffset(lineNumber - 1);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                context = new TypeContext(type, position);
            }
            catch (CoreException coreException) {}
        }
        this.fCompletionProcessor = new JavaDebugContentAssistProcessor(context);
        this.fViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return BreakpointConditionEditor.this.fCompletionProcessor;
            }
        });
        this.fViewer.setEditable(true);
        this.fViewer.setDocument((IDocument)document);
        DefaultUndoManager undoManager = new DefaultUndoManager(10);
        this.fViewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.fViewer);
        this.fViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                BreakpointConditionEditor.this.valueChanged();
            }
        };
        this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
        gd = (GridData)this.fViewer.getControl().getLayoutData();
        gd.heightHint = this.fPage.convertHeightInCharsToPixels(10);
        gd.widthHint = this.fPage.convertWidthInCharsToPixels(40);
        document.set(condition);
        this.valueChanged();
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(Map parameter) throws ExecutionException {
                BreakpointConditionEditor.this.fViewer.doOperation(13);
                return null;
            }
        };
        this.submission = new HandlerSubmission(null, parent.getShell(), null, "org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler, Priority.MEDIUM);
    }

    public String getCondition() {
        return this.fViewer.getDocument().get();
    }

    protected void refreshValidState() {
        if (!this.fViewer.isEditable()) {
            this.fPage.removeErrorMessage(this.fErrorMessage);
            this.fIsValid = true;
        } else {
            String text = this.fViewer.getDocument().get();
            boolean bl = this.fIsValid = text != null && text.trim().length() > 0;
            if (!this.fIsValid) {
                this.fPage.addErrorMessage(this.fErrorMessage);
            } else {
                this.fPage.removeErrorMessage(this.fErrorMessage);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            this.fViewer.getTextWidget().setFocus();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            commandSupport.addHandlerSubmission(this.submission);
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            commandSupport.removeHandlerSubmission(this.submission);
        }
        this.valueChanged();
    }

    protected void valueChanged() {
        this.refreshValidState();
        String newValue = this.fViewer.getDocument().get();
        if (!newValue.equals(this.fOldValue)) {
            this.fOldValue = newValue;
        }
    }

    public void dispose() {
        if (this.fViewer.isEditable()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            commandSupport.removeHandlerSubmission(this.submission);
        }
        this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fViewer.dispose();
    }
}

