/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.threadgroups;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaThreadGroup;
import org.eclipse.jdt.internal.debug.ui.threadgroups.JavaDebugTargetContentAdapter;

public class JavaThreadEventHandler
extends ThreadEventHandler {
    public JavaThreadEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    protected ModelDelta addPathToThread(ModelDelta delta, IThread thread) {
        if (JavaDebugTargetContentAdapter.isShowThreadGroups()) {
            delta = delta.addNode((Object)thread.getLaunch(), 0);
            delta = delta.addNode((Object)thread.getDebugTarget(), 0);
            ArrayList<IJavaThreadGroup> groups = new ArrayList<IJavaThreadGroup>();
            IJavaThread javaThread = (IJavaThread)thread;
            try {
                IJavaThreadGroup threadGroup = javaThread.getThreadGroup();
                while (threadGroup != null) {
                    groups.add(0, threadGroup);
                    threadGroup = threadGroup.getThreadGroup();
                }
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            Iterator iterator = groups.iterator();
            while (iterator.hasNext()) {
                delta = delta.addNode(iterator.next(), 0);
            }
            return delta;
        }
        return super.addPathToThread(delta, thread);
    }
}

