/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.operations.IUninstallFeaturesOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.views.FeatureAction;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UninstallFeaturesAction
extends FeatureAction {
    private ConfiguredFeatureAdapter[] adapters;

    public UninstallFeaturesAction(Shell shell, String text) {
        super(shell, text);
        this.setWindowTitle(UpdateUIMessages.FeatureUninstallAction_dialogTitle);
    }

    public void run() {
        try {
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                throw new CoreException(status);
            }
            if (this.adapters == null || !this.confirm(UpdateUIMessages.FeatureUninstallAction_uninstallQuestion)) {
                return;
            }
            if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) {
                return;
            }
            IFeature[] features = new IFeature[this.adapters.length];
            IConfiguredSite[] configuredSites = new IConfiguredSite[this.adapters.length];
            int i = 0;
            while (i < this.adapters.length) {
                features[i] = this.adapters[i].getFeature(null);
                configuredSites[i] = this.adapters[i].getConfiguredSite();
                ++i;
            }
            IUninstallFeaturesOperation uninstallFeaturesOperation = ((OperationFactory)OperationsManager.getOperationFactory()).createUninstallFeaturesOperation(configuredSites, features);
            boolean restartNeeded = uninstallFeaturesOperation.execute(null, null);
            UpdateUI.requestRestart(restartNeeded);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUtils.logException((Throwable)e.getTargetException());
        }
    }

    public void setSelection(IStructuredSelection selection) {
        this.adapters = selection.toList().toArray(new ConfiguredFeatureAdapter[selection.size()]);
        this.setText(UpdateUIMessages.FeatureUninstallAction_uninstall);
    }

    public boolean canExecuteAction() {
        if (this.adapters == null || this.adapters.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.adapters.length) {
            if (this.adapters[i].isConfigured()) {
                return false;
            }
            try {
                IFeatureOperation pendingOperation = OperationsManager.findPendingOperation((IFeature)this.adapters[i].getFeature(null));
                if (pendingOperation != null) {
                    return false;
                }
                if (InstallRegistry.getInstance().get((Object)("feature_" + this.adapters[i].getFeature(null).getVersionedIdentifier())) == null) {
                    return false;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

