/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;

public abstract class StorageTypedElement
extends BufferedContent
implements ITypedElement,
IEditableContent,
IEncodedStreamContentAccessor {
    private IStorage bufferedContents;

    protected InputStream createStream() throws CoreException {
        if (this.bufferedContents == null) {
            this.cacheContents((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.bufferedContents != null) {
            return this.bufferedContents.getContents();
        }
        return null;
    }

    public void cacheContents(IProgressMonitor monitor) throws CoreException {
        this.bufferedContents = this.getElementStorage(monitor);
    }

    protected abstract IStorage getElementStorage(IProgressMonitor var1) throws CoreException;

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public String getType() {
        String name = this.getName();
        if (name != null) {
            int index = name.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            if (index == name.length() - 1) {
                return "";
            }
            return name.substring(index + 1);
        }
        return "FOLDER";
    }

    public String getCharset() throws CoreException {
        if (this.bufferedContents == null) {
            this.cacheContents((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.bufferedContents instanceof IEncodedStorage) {
            return ((IEncodedStorage)this.bufferedContents).getCharset();
        }
        return null;
    }

    public abstract String getName();

    public abstract boolean isEditable();

    public abstract ITypedElement replace(ITypedElement var1, ITypedElement var2);

    public abstract String getContentIdentifier();
}

