/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;

class LineComparator
implements IRangeComparator {
    private String[] fLines;

    public static LineComparator create(IStorage storage, String outputEncoding) throws CoreException, UnsupportedEncodingException {
        LineComparator lineComparator;
        BufferedInputStream is = new BufferedInputStream(storage.getContents());
        try {
            String encoding = LineComparator.getEncoding(storage, outputEncoding);
            lineComparator = new LineComparator(is, encoding);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {}
        return lineComparator;
    }

    private static String getEncoding(IStorage storage, String outputEncoding) throws CoreException {
        IEncodedStorage es;
        String charset;
        if (storage instanceof IEncodedStorage && (charset = (es = (IEncodedStorage)storage).getCharset()) != null) {
            return charset;
        }
        return outputEncoding;
    }

    public LineComparator(InputStream is, String encoding) throws UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        ArrayList<String> ar = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ar.add(line);
            }
        }
        catch (IOException iOException) {}
        try {
            is.close();
        }
        catch (IOException iOException) {}
        this.fLines = ar.toArray(new String[ar.size()]);
    }

    String getLine(int ix) {
        return this.fLines[ix];
    }

    public int getRangeCount() {
        return this.fLines.length;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        String s1 = this.fLines[thisIndex];
        String s2 = ((LineComparator)other).fLines[otherIndex];
        return s1.equals(s2);
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }
}

