/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.MergeAllOperation;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class MergeAllActionHandler
extends MergeActionHandler
implements IDiffChangeListener {
    private MergeAllOperation operation;

    public MergeAllActionHandler(ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.getContext().getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
    }

    protected synchronized SynchronizationOperation getOperation() {
        if (this.operation == null) {
            this.operation = this.createOperation();
        }
        return this.operation;
    }

    protected MergeAllOperation createOperation() {
        return new MergeAllOperation(this.getJobName(), this.getConfiguration(), this.getMappings(), this.getContext());
    }

    private IMergeContext getContext() {
        return (IMergeContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    private ResourceMapping[] getMappings() {
        return ((ISynchronizationScope)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationScope")).getMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        MergeAllActionHandler mergeAllActionHandler = this;
        synchronized (mergeAllActionHandler) {
            this.operation = null;
        }
        this.setEnabled(event.getTree().countFor(512, 768) > 0L || event.getTree().countFor(768, 768) > 0L);
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    public void dispose() {
        this.getContext().getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        super.dispose();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.promptToUpdate()) {
            return super.execute(event);
        }
        return null;
    }

    protected String getJobName() {
        String name = this.getConfiguration().getParticipant().getName();
        return NLS.bind((String)"Merging all changes in {0}", (Object)Utils.shortenText(30, name));
    }

    protected boolean promptToUpdate() {
        final IResourceDiffTree tree = this.getContext().getDiffTree();
        if (tree.isEmpty()) {
            return false;
        }
        final long count = tree.countFor(512, 768) + tree.countFor(768, 768);
        if (count == 0L) {
            return false;
        }
        final boolean[] result = new boolean[]{true};
        TeamUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                String sizeString = Long.toString(count);
                String message = tree.size() > 1 ? NLS.bind((String)"Are you sure you want to merge {0} resources?", (Object[])new String[]{sizeString}) : NLS.bind((String)"Are you sure you want to merge {0} resource?", (Object[])new String[]{sizeString});
                result[0] = MessageDialog.openQuestion((Shell)MergeAllActionHandler.this.getConfiguration().getSite().getShell(), (String)NLS.bind((String)"Confirm Merge", (Object[])new String[]{sizeString}), (String)message);
            }
        });
        return result[0];
    }
}

