/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.internal.ui.mapping.ResourceModelProviderOperation;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ResourceMergeHandler
extends MergeActionHandler {
    private final boolean overwrite;
    private ResourceModelProviderOperation operation;

    public ResourceMergeHandler(ISynchronizePageConfiguration configuration, boolean overwrite) {
        super(configuration);
        this.overwrite = overwrite;
    }

    protected synchronized SynchronizationOperation getOperation() {
        if (this.operation == null) {
            this.operation = new ResourceModelProviderOperation(this.getConfiguration(), this.getStructuredSelection().toArray()){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IMergeContext context = (IMergeContext)this.getContext();
                        IDiff[] diffs = this.getFileDeltas(this.getElements());
                        IStatus status = context.merge(diffs, ResourceMergeHandler.this.overwrite, monitor);
                        if (!status.isOK()) {
                            throw new CoreException(status);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }

                protected FastDiffFilter getDiffFilter() {
                    return new FastDiffFilter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean select(IDiff node) {
                            if (node instanceof IThreeWayDiff) {
                                IThreeWayDiff twd = (IThreeWayDiff)node;
                                return twd.getDirection() == 256 && ResourceMergeHandler.access$0(1.access$0(this.this$1)) || twd.getDirection() == 768 || twd.getDirection() == 512;
                            }
                            return ResourceMergeHandler.access$0(1.access$0(this.this$1));
                        }
                    };
                }

                static /* synthetic */ ResourceMergeHandler access$0(1 var0) {
                    return var0.ResourceMergeHandler.this;
                }
            };
        }
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnablement(IStructuredSelection selection) {
        ResourceMergeHandler resourceMergeHandler = this;
        synchronized (resourceMergeHandler) {
            this.operation = null;
        }
        super.updateEnablement(selection);
    }
}

