/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.OpenFileInSystemEditorAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenWithActionGroup
extends ActionGroup {
    private OpenFileInSystemEditorAction openFileAction;
    private OpenInCompareAction openInCompareAction;
    private ISynchronizePageSite site;
    private final ISynchronizeParticipant participant;
    private final boolean includeOpenInCompare;

    public OpenWithActionGroup(ISynchronizePageSite site, ISynchronizeParticipant participant, boolean includeOpenInCompare) {
        this.participant = participant;
        this.site = site;
        this.includeOpenInCompare = includeOpenInCompare;
        this.makeActions();
    }

    protected void makeActions() {
        IWorkbenchSite ws = this.site.getWorkbenchSite();
        if (ws != null) {
            this.openFileAction = new OpenFileInSystemEditorAction(ws.getPage());
            if (this.includeOpenInCompare) {
                this.openInCompareAction = new OpenInCompareAction(this.site, this.participant);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu, String groupId) {
        ISelection selection = this.site.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fillOpenWithMenu(menu, groupId, (IStructuredSelection)selection);
        }
    }

    private void fillOpenWithMenu(IMenuManager menu, String groupId, IStructuredSelection selection) {
        IWorkbenchSite ws;
        if (selection == null || selection.size() < 1) {
            return;
        }
        Object[] elements = selection.toArray();
        IResource[] resources = Utils.getResources(elements);
        if (resources.length == 0 && this.openInCompareAction != null) {
            ModelSynchronizeParticipant msp;
            if (elements.length == 1 && this.participant instanceof ModelSynchronizeParticipant && (msp = (ModelSynchronizeParticipant)this.participant).hasCompareInputFor(elements[0])) {
                menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
            }
            return;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() != 1) {
                return;
            }
            ++i;
        }
        if (resources.length == 1 && this.openInCompareAction != null) {
            menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
        }
        i = 0;
        while (i < resources.length) {
            if (!resources[i].exists()) {
                return;
            }
            ++i;
        }
        if (this.openFileAction != null) {
            this.openFileAction.selectionChanged(selection);
            menu.appendToGroup(groupId, (IAction)this.openFileAction);
        }
        if (resources.length == 1 && (ws = this.site.getWorkbenchSite()) != null) {
            MenuManager submenu = new MenuManager(TeamUIMessages.OpenWithActionGroup_0);
            submenu.add((IContributionItem)new OpenWithMenu(ws.getPage(), (IAdaptable)resources[0]));
            menu.appendToGroup(groupId, (IContributionItem)submenu);
        }
    }

    public void openInCompareEditor() {
        if (this.openInCompareAction != null) {
            this.openInCompareAction.run();
        }
    }
}

