/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class MessageArea
extends Composite {
    private int BORDER_MARGIN = 2;
    private DecoratedField messageField;
    private Composite container;

    public MessageArea(Composite parent, int style) {
        super(parent, style);
        this.container = new Composite((Composite)this, style);
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 2;
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        this.container.setLayout((Layout)glayout);
        this.messageField = new DecoratedField(this.container, 8, new TextControlCreator());
        this.messageField.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MessageArea.this.onPaint(e);
            }
        });
        this.setLayout(new Layout(){

            public void layout(Composite parent, boolean changed) {
                Rectangle carea = MessageArea.this.getClientArea();
                MessageArea.this.container.setBounds(carea.x + MessageArea.this.BORDER_MARGIN, carea.y + MessageArea.this.BORDER_MARGIN, carea.width - 2 * MessageArea.this.BORDER_MARGIN, carea.height - 2 * MessageArea.this.BORDER_MARGIN);
            }

            public Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
                Point size = MessageArea.this.container.computeSize(wHint, hHint, changed);
                size.x += 4;
                size.y += 4;
                return size;
            }
        });
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.messageField.getLayoutControl().setBackground(bg);
        this.messageField.getControl().setBackground(bg);
        this.container.setBackground(bg);
    }

    public void setText(String text) {
        ((Text)this.messageField.getControl()).setText(text);
    }

    public void setImage(Image image) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        registry.registerFieldDecoration("errorImage", "Error", image);
        this.messageField.addFieldDecoration(registry.getFieldDecoration("errorImage"), 17408, false);
    }

    private void onPaint(PaintEvent e) {
        Rectangle carea = this.getClientArea();
        e.gc.setForeground(this.getForeground());
        e.gc.drawPolyline(new int[]{carea.x, carea.y + carea.height - 1, carea.x, carea.y + 2, carea.x + 2, carea.y, carea.x + carea.width - 3, carea.y, carea.x + carea.width - 1, carea.y + 2, carea.x + carea.width - 1, carea.y + carea.height - 1});
    }
}

