/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;

public class FieldAssistColors {
    public static RGB computeErrorFieldBackgroundRGB(Control control) {
        Color background = control.getBackground();
        Color error = JFaceColors.getErrorText(control.getDisplay());
        int average = (error.getRed() + error.getBlue() + error.getGreen()) / 3;
        int rMore = (int)(0.08 * (double)error.getRed()) + (int)(0.05 * (double)(error.getRed() - average));
        int gMore = (int)(0.08 * (double)error.getGreen()) + (int)(0.05 * (double)(error.getGreen() - average));
        int bMore = (int)(0.08 * (double)error.getBlue()) + (int)(0.05 * (double)(error.getBlue() - average));
        int r = background.getRed();
        int g = background.getGreen();
        int b = background.getBlue();
        if (r <= 255 - rMore) {
            r += rMore;
        } else {
            g -= rMore;
            b -= rMore;
        }
        if (g <= 255 - gMore) {
            g += gMore;
        } else {
            r -= gMore;
            b -= gMore;
        }
        if (b <= 255 - bMore) {
            b += bMore;
        } else {
            r -= bMore;
            g -= bMore;
        }
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return new RGB(r, g, b);
    }

    public static Color getRequiredFieldBackgroundColor(Control control) {
        return control.getDisplay().getSystemColor(29);
    }
}

