/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedFix;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.text.edits.TextEditGroup;

public final class ConvertIterableLoopOperation
extends LinkedFix.AbstractLinkedFixRewriteOperation {
    private boolean fAssigned = false;
    private IBinding fElement = null;
    private Expression fExpression = null;
    private IBinding fIterable = null;
    private IVariableBinding fIterator = null;
    private List fOccurrences = new ArrayList(2);
    private final CompilationUnit fRoot;
    private final ForStatement fStatement;
    private final ICompilationUnit fCompilationUnit;
    private final String fIdentifierName;
    static /* synthetic */ Class class$0;

    private static ITypeBinding getSuperType(ITypeBinding binding, String name) {
        ITypeBinding result;
        if (binding.isArray() || binding.isPrimitive()) {
            return null;
        }
        if (binding.getQualifiedName().startsWith(name)) {
            return binding;
        }
        ITypeBinding type = binding.getSuperclass();
        if (type != null && (result = ConvertIterableLoopOperation.getSuperType(type, name)) != null) {
            return result;
        }
        ITypeBinding[] types = binding.getInterfaces();
        int index = 0;
        while (index < types.length) {
            ITypeBinding result2 = ConvertIterableLoopOperation.getSuperType(types[index], name);
            if (result2 != null) {
                return result2;
            }
            ++index;
        }
        return null;
    }

    public ConvertIterableLoopOperation(CompilationUnit unit, ForStatement statement, String identifierName) {
        this.fIdentifierName = identifierName;
        this.fCompilationUnit = (ICompilationUnit)unit.getJavaElement();
        this.fStatement = statement;
        this.fRoot = (CompilationUnit)statement.getRoot();
    }

    private List computeElementNames() {
        ArrayList<String> names = new ArrayList<String>();
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        String name = this.fIdentifierName;
        ITypeBinding binding = this.fIterator.getType();
        if (binding != null && binding.isParameterizedType()) {
            name = binding.getTypeArguments()[0].getName();
        }
        List excluded = this.getExcludedNames();
        String[] suggestions = StubUtility.getLocalNameSuggestions(project, name, 0, excluded.toArray(new String[excluded.size()]));
        int index = 0;
        while (index < suggestions.length) {
            names.add(suggestions[index]);
            ++index;
        }
        return names;
    }

    private List getExcludedNames() {
        CompilationUnit unit = (CompilationUnit)this.fStatement.getRoot();
        IBinding[] before = new ScopeAnalyzer(unit).getDeclarationsInScope(this.fStatement.getStartPosition(), 2);
        IBinding[] after = new ScopeAnalyzer(unit).getDeclarationsAfter(this.fStatement.getStartPosition() + this.fStatement.getLength(), 2);
        ArrayList<String> names = new ArrayList<String>();
        int index = 0;
        while (index < before.length) {
            names.add(before[index].getName());
            ++index;
        }
        index = 0;
        while (index < after.length) {
            names.add(after[index].getName());
            ++index;
        }
        return names;
    }

    private Expression getExpression(ASTRewrite rewrite) {
        if (this.fExpression instanceof MethodInvocation) {
            return (MethodInvocation)rewrite.createMoveTarget((ASTNode)this.fExpression);
        }
        return (Expression)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)this.fExpression);
    }

    private ITypeBinding getIterableType(ITypeBinding iterator) {
        ITypeBinding[] bindings;
        if (iterator != null && (bindings = iterator.getTypeArguments()).length > 0) {
            ITypeBinding arg = bindings[0];
            if (arg.isWildcardType()) {
                arg = ASTResolving.normalizeWildcardType(arg, true, this.fRoot.getAST());
            }
            return arg;
        }
        return this.fRoot.getAST().resolveWellKnownType("java.lang.Object");
    }

    private ITrackedNodePosition rewriteAST(final AST ast, final ASTRewrite astRewrite, ImportRewrite importRewrite, final TextEditGroup group) throws CoreException {
        final ImportRemover remover = new ImportRemover(this.fCompilationUnit.getJavaProject(), (CompilationUnit)this.fStatement.getRoot());
        EnhancedForStatement statement = ast.newEnhancedForStatement();
        List names = this.computeElementNames();
        String name = this.fIdentifierName;
        if (this.fElement != null) {
            name = this.fElement.getName();
            if (!names.contains(name)) {
                names.add(0, name);
            }
        } else if (!names.isEmpty()) {
            name = (String)names.get(0);
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            this.getPositionGroup(this.fIdentifierName).addProposal((String)iterator.next(), null);
        }
        Statement body = this.fStatement.getBody();
        if (body != null) {
            if (body instanceof Block) {
                final ListRewrite list = astRewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                Iterator iterator2 = this.fOccurrences.iterator();
                while (iterator2.hasNext()) {
                    Statement parent;
                    ASTNode aSTNode = (ASTNode)iterator2.next();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.jdt.core.dom.Statement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((parent = (Statement)ASTNodes.getParent(aSTNode, clazz)) == null || !list.getRewrittenList().contains(parent)) continue;
                    list.remove((ASTNode)parent, null);
                    remover.registerRemovedNode((ASTNode)parent);
                }
                final String text = name;
                body.accept(new ASTVisitor(){

                    private boolean replace(Expression expression) {
                        SimpleName node = ast.newSimpleName(text);
                        astRewrite.replace((ASTNode)expression, (ASTNode)node, group);
                        remover.registerRemovedNode((ASTNode)expression);
                        ConvertIterableLoopOperation.this.getPositionGroup(ConvertIterableLoopOperation.this.fIdentifierName).addPosition(astRewrite.track((ASTNode)node));
                        return false;
                    }

                    public final boolean visit(MethodInvocation node) {
                        IBinding result;
                        Expression expression;
                        IMethodBinding binding = node.resolveMethodBinding();
                        if (binding != null && (binding.getName().equals("next") || binding.getName().equals("nextElement")) && ((expression = node.getExpression()) instanceof Name ? (result = ((Name)expression).resolveBinding()) != null && result.equals((Object)ConvertIterableLoopOperation.this.fIterator) : expression instanceof FieldAccess && (result = ((FieldAccess)expression).resolveFieldBinding()) != null && result.equals((Object)ConvertIterableLoopOperation.this.fIterator))) {
                            return this.replace((Expression)node);
                        }
                        return super.visit(node);
                    }

                    public final boolean visit(SimpleName node) {
                        IBinding binding;
                        if (ConvertIterableLoopOperation.this.fElement != null && (binding = node.resolveBinding()) != null && binding.equals((Object)ConvertIterableLoopOperation.this.fElement)) {
                            Statement parent;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Statement");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((parent = (Statement)ASTNodes.getParent((ASTNode)node, clazz)) != null && list.getRewrittenList().contains(parent)) {
                                ConvertIterableLoopOperation.this.getPositionGroup(ConvertIterableLoopOperation.this.fIdentifierName).addPosition(astRewrite.track((ASTNode)node));
                            }
                        }
                        return false;
                    }
                });
            }
            statement.setBody((Statement)astRewrite.createMoveTarget((ASTNode)body));
        }
        SingleVariableDeclaration declaration = ast.newSingleVariableDeclaration();
        SimpleName simple = ast.newSimpleName(name);
        this.getPositionGroup(this.fIdentifierName).addFirstPosition(astRewrite.track((ASTNode)simple));
        declaration.setName(simple);
        ITypeBinding iterable = this.getIterableType(this.fIterator.getType());
        ImportRewrite imports = importRewrite;
        declaration.setType(this.importType(iterable, (ASTNode)this.fStatement, importRewrite, this.fRoot));
        remover.registerAddedImport(iterable.getQualifiedName());
        statement.setParameter(declaration);
        statement.setExpression(this.getExpression(astRewrite));
        astRewrite.replace((ASTNode)this.fStatement, (ASTNode)statement, group);
        remover.registerRemovedNode((ASTNode)this.fStatement);
        remover.applyRemoves(imports);
        return null;
    }

    public final boolean isApplicable() {
        if (JavaModelUtil.is50OrHigher(this.fCompilationUnit.getJavaProject())) {
            ASTNode root;
            Iterator outer = this.fStatement.initializers().iterator();
            while (outer.hasNext()) {
                Expression initializer = (Expression)outer.next();
                if (!(initializer instanceof VariableDeclarationExpression)) continue;
                VariableDeclarationExpression declaration = (VariableDeclarationExpression)initializer;
                Iterator inner = declaration.fragments().iterator();
                while (inner.hasNext()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)inner.next();
                    fragment.accept(new ASTVisitor(){

                        public final boolean visit(MethodInvocation node) {
                            ITypeBinding iterable;
                            ITypeBinding resolved;
                            Expression qualifier;
                            String qualified;
                            ITypeBinding type;
                            IMethodBinding binding = node.resolveMethodBinding();
                            if (binding != null && (type = binding.getReturnType()) != null && ((qualified = type.getQualifiedName()).startsWith("java.util.Enumeration<") || qualified.startsWith("java.util.Iterator<")) && (qualifier = node.getExpression()) != null && (resolved = qualifier.resolveTypeBinding()) != null && (iterable = ConvertIterableLoopOperation.getSuperType(resolved, "java.lang.Iterable")) != null) {
                                ConvertIterableLoopOperation.this.fExpression = qualifier;
                                if (qualifier instanceof Name) {
                                    Name name = (Name)qualifier;
                                    ConvertIterableLoopOperation.this.fIterable = name.resolveBinding();
                                } else if (qualifier instanceof MethodInvocation) {
                                    MethodInvocation invocation = (MethodInvocation)qualifier;
                                    ConvertIterableLoopOperation.this.fIterable = (IBinding)invocation.resolveMethodBinding();
                                } else if (qualifier instanceof FieldAccess) {
                                    FieldAccess access = (FieldAccess)qualifier;
                                    ConvertIterableLoopOperation.this.fIterable = (IBinding)access.resolveFieldBinding();
                                }
                            }
                            return true;
                        }

                        public final boolean visit(VariableDeclarationFragment node) {
                            ITypeBinding type;
                            IVariableBinding binding = node.resolveBinding();
                            if (binding != null && (type = binding.getType()) != null) {
                                ITypeBinding iterator = ConvertIterableLoopOperation.getSuperType(type, "java.util.Iterator");
                                if (iterator != null) {
                                    ConvertIterableLoopOperation.this.fIterator = binding;
                                } else {
                                    iterator = ConvertIterableLoopOperation.getSuperType(type, "java.util.Enumeration");
                                    if (iterator != null) {
                                        ConvertIterableLoopOperation.this.fIterator = binding;
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            Statement statement = this.fStatement.getBody();
            final boolean[] otherInvocationThenNext = new boolean[1];
            final int[] nextInvocationCount = new int[1];
            if (statement != null && this.fIterator != null) {
                final ITypeBinding iterable = this.getIterableType(this.fIterator.getType());
                statement.accept(new ASTVisitor(){

                    public final boolean visit(Assignment node) {
                        return this.visit(node.getLeftHandSide(), node.getRightHandSide());
                    }

                    private boolean visit(Expression node) {
                        ITypeBinding binding;
                        if (node != null && (binding = node.resolveTypeBinding()) != null && iterable.equals((Object)binding)) {
                            FieldAccess access;
                            IVariableBinding result;
                            if (node instanceof Name) {
                                Name name = (Name)node;
                                IBinding result2 = name.resolveBinding();
                                if (result2 != null) {
                                    ConvertIterableLoopOperation.this.fOccurrences.add(node);
                                    ConvertIterableLoopOperation.this.fElement = result2;
                                    return false;
                                }
                            } else if (node instanceof FieldAccess && (result = (access = (FieldAccess)node).resolveFieldBinding()) != null) {
                                ConvertIterableLoopOperation.this.fOccurrences.add(node);
                                ConvertIterableLoopOperation.this.fElement = (IBinding)result;
                                return false;
                            }
                        }
                        return true;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    private boolean visit(Expression left, Expression right) {
                        if (right instanceof MethodInvocation) {
                            FieldAccess qualifier;
                            IVariableBinding result;
                            MethodInvocation invocation = (MethodInvocation)right;
                            IMethodBinding binding = invocation.resolveMethodBinding();
                            if (binding == null || !binding.getName().equals("next") && !binding.getName().equals("nextElement")) return this.visit(invocation);
                            Expression expression = invocation.getExpression();
                            if (expression instanceof Name) {
                                Name qualifier2 = (Name)expression;
                                IBinding result2 = qualifier2.resolveBinding();
                                if (result2 == null || !result2.equals((Object)ConvertIterableLoopOperation.this.fIterator)) return true;
                                nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                return this.visit(left);
                            }
                            if (!(expression instanceof FieldAccess) || (result = (qualifier = (FieldAccess)expression).resolveFieldBinding()) == null || !result.equals((Object)ConvertIterableLoopOperation.this.fIterator)) return true;
                            nextInvocationCount[0] = nextInvocationCount[0] + 1;
                            return this.visit(left);
                        }
                        if (!(right instanceof NullLiteral)) return true;
                        return this.visit(left);
                    }

                    public boolean visit(MethodInvocation invocation) {
                        IMethodBinding binding = invocation.resolveMethodBinding();
                        if (binding != null) {
                            FieldAccess qualifier;
                            IVariableBinding result;
                            Expression expression = invocation.getExpression();
                            if (expression instanceof Name) {
                                Name qualifier2 = (Name)expression;
                                IBinding result2 = qualifier2.resolveBinding();
                                if (result2 != null && result2.equals((Object)ConvertIterableLoopOperation.this.fIterator)) {
                                    if (!binding.getName().equals("next") && !binding.getName().equals("nextElement")) {
                                        otherInvocationThenNext[0] = true;
                                    } else {
                                        nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                    }
                                }
                            } else if (expression instanceof FieldAccess && (result = (qualifier = (FieldAccess)expression).resolveFieldBinding()) != null && result.equals((Object)ConvertIterableLoopOperation.this.fIterator)) {
                                if (!binding.getName().equals("next") && !binding.getName().equals("nextElement")) {
                                    otherInvocationThenNext[0] = true;
                                } else {
                                    nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                }
                            }
                        }
                        return false;
                    }

                    public final boolean visit(VariableDeclarationFragment node) {
                        return this.visit((Expression)node.getName(), node.getInitializer());
                    }
                });
                if (otherInvocationThenNext[0]) {
                    return false;
                }
                if (nextInvocationCount[0] > 1) {
                    return false;
                }
            }
            if ((root = this.fStatement.getRoot()) != null) {
                root.accept(new ASTVisitor(){

                    public final boolean visit(ForStatement node) {
                        return false;
                    }

                    public final boolean visit(SimpleName node) {
                        IBinding binding = node.resolveBinding();
                        if (binding != null && binding.equals((Object)ConvertIterableLoopOperation.this.fElement)) {
                            ConvertIterableLoopOperation.this.fAssigned = true;
                        }
                        return false;
                    }
                });
            }
        }
        return this.fExpression != null && this.fIterable != null && this.fIterator != null && !this.fAssigned;
    }

    public ITrackedNodePosition rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups, List positionGroups) throws CoreException {
        TextEditGroup group = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description);
        textEditGroups.add(group);
        this.clearPositionGroups();
        ITrackedNodePosition endPosition = this.rewriteAST(cuRewrite.getRoot().getAST(), cuRewrite.getASTRewrite(), cuRewrite.getImportRewrite(), group);
        positionGroups.addAll(this.getAllPositionGroups());
        return endPosition;
    }
}

