/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.ltk.core.refactoring.Change;

public abstract class AbstractJavaElementRenameChange
extends JDTChange {
    private final String fNewName;
    private final String fOldName;
    private final IPath fResourcePath;
    private final long fStampToRestore;
    private final String fComment;

    protected AbstractJavaElementRenameChange(IPath resourcePath, String oldName, String newName, String comment) {
        this(resourcePath, oldName, newName, comment, -1L);
    }

    protected AbstractJavaElementRenameChange(IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        Assert.isNotNull(newName, "new name");
        Assert.isNotNull(oldName, "old name");
        this.fResourcePath = resourcePath;
        this.fOldName = oldName;
        this.fNewName = newName;
        this.fComment = comment;
        this.fStampToRestore = stampToRestore;
    }

    protected final IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public Object getModifiedElement() {
        return JavaCore.create((IResource)this.getResource());
    }

    protected abstract Change createUndoChange(long var1) throws CoreException;

    protected abstract void doRename(IProgressMonitor var1) throws CoreException;

    protected abstract IPath createNewPath();

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        try {
            pm.beginTask(RefactoringCoreMessages.AbstractRenameChange_Renaming, 1);
            IResource resource = this.getResource();
            IPath newPath = this.createNewPath();
            Change result = this.createUndoChange(resource.getModificationStamp());
            this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            change = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getComment() {
        return this.fComment;
    }

    protected IPath getResourcePath() {
        return this.fResourcePath;
    }

    public String getOldName() {
        return this.fOldName;
    }
}

