/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.IInitializableRefactoringComponent;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringContribution;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

public final class JavaRefactoringDescriptor
extends RefactoringDescriptor {
    public static final String ATTRIBUTE_ELEMENT = "element";
    public static final String ATTRIBUTE_INPUT = "input";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_SELECTION = "selection";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String DEFAULT_PACKAGE = "(default)";
    public static final int DEPRECATION_RESOLVING = 131072;
    private static final String IDENTIFIER_FIELD = "field";
    private static final String IDENTIFIER_INITIALIZER = "initializer";
    private static final String IDENTIFIER_METHOD = "method";
    private static final String IDENTIFIER_PACKAGE = "package";
    private static final String IDENTIFIER_PROJECT = "project";
    private static final String IDENTIFIER_RESOURCE = "resource";
    private static final String IDENTIFIER_ROOT = "root";
    private static final String IDENTIFIER_TYPE = "type";
    private static final String IDENTIFIER_UNIT = "unit";
    public static final int JAR_DEPRECATION_RESOLVING = 262144;
    public static final int JAR_IMPORTABLE = 65536;
    private static final char SEPARATOR_DOT = '.';
    private static final char SEPARATOR_MEMBER = '#';
    private static final char SEPARATOR_PACKAGE = '$';
    private static final char SEPARATOR_PATH = '/';
    private static final String VALUE_VERSION_1_0 = "1.0";
    private final Map fArguments;
    private JavaRefactoringContribution fContribution;

    public static String elementToHandle(String project, IJavaElement element) {
        int elementType = element.getElementType();
        switch (elementType) {
            case 2: {
                return String.valueOf(JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_PROJECT)) + element.getElementName();
            }
            case 3: {
                return JavaRefactoringDescriptor.resourceToHandle(project, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_ROOT), element.getResource());
            }
            case 5: {
                return JavaRefactoringDescriptor.resourceToHandle(project, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_UNIT), element.getResource());
            }
            case 4: {
                return JavaRefactoringDescriptor.resourceToHandle(project, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_PACKAGE), element.getResource());
            }
        }
        return element.getHandleIdentifier();
    }

    private static String getHandlePrefix(String identifier) {
        Assert.isNotNull((Object)identifier);
        return String.valueOf(identifier) + "://";
    }

    public static IJavaElement handleToElement(String project, String handle) {
        return JavaRefactoringDescriptor.handleToElement(project, handle, true);
    }

    public static IJavaElement handleToElement(String project, String handle, boolean check) {
        Object element = null;
        element = handle.startsWith(JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_PROJECT)) ? JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(handle.substring(JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_PROJECT).length()))) : (handle.startsWith(JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_ROOT)) ? JavaCore.create((IResource)JavaRefactoringDescriptor.handleToResource(project, handle, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_ROOT))) : (handle.startsWith(JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_UNIT)) ? JavaCore.create((IResource)JavaRefactoringDescriptor.handleToResource(project, handle, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_UNIT))) : (handle.startsWith(JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_PACKAGE)) ? JavaCore.create((IResource)JavaRefactoringDescriptor.handleToResource(project, handle, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_PACKAGE))) : JavaCore.create((String)handle))));
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    private static IResource handleToResource(String project, String handle, String prefix) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String string = handle;
        if (!handle.startsWith(prefix)) {
            return null;
        }
        string = string.substring(prefix.length());
        if ("".equals(string)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)string);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    private static String resourceToHandle(String project, String prefix, IResource resource) {
        if (project != null && !"".equals(project)) {
            return String.valueOf(prefix) + resource.getProjectRelativePath().toPortableString();
        }
        return String.valueOf(prefix) + resource.getFullPath().toPortableString();
    }

    public JavaRefactoringDescriptor(JavaRefactoringContribution contribution, String id, String project, String description, String comment, Map arguments, int flags) {
        super(id, project, description, comment, flags);
        Assert.isNotNull((Object)arguments);
        this.fContribution = contribution;
        this.fArguments = arguments;
    }

    public JavaRefactoringDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        this(null, id, project, description, comment, arguments, flags);
    }

    public RefactoringArguments createArguments() {
        JavaRefactoringArguments arguments = new JavaRefactoringArguments(this.getProject());
        Iterator iterator = this.fArguments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name == null || "".equals(name) || value == null) continue;
            arguments.setAttribute(name, value);
        }
        return arguments;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        Refactoring refactoring = null;
        if (this.fContribution != null) {
            refactoring = this.fContribution.createRefactoring(this);
        } else {
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)this.getID());
            if (contribution instanceof JavaRefactoringContribution) {
                this.fContribution = (JavaRefactoringContribution)contribution;
                refactoring = this.fContribution.createRefactoring(this);
            }
        }
        if (refactoring != null) {
            if (refactoring instanceof IInitializableRefactoringComponent) {
                status.merge(((IInitializableRefactoringComponent)refactoring).initialize(this.createArguments()));
            } else {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_initialization_error, this.getID())));
            }
        }
        return refactoring;
    }

    public String elementToHandle(IJavaElement element) {
        Assert.isNotNull((Object)element);
        return JavaRefactoringDescriptor.elementToHandle(this.getProject(), element);
    }

    public Map getArguments() {
        HashMap<String, String> map = new HashMap<String, String>(this.fArguments);
        map.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
        return map;
    }

    public JavaRefactoringContribution getContribution() {
        return this.fContribution;
    }

    public IJavaElement handleToElement(String handle) {
        Assert.isNotNull((Object)handle);
        Assert.isLegal((!"".equals(handle) ? 1 : 0) != 0);
        String project = this.getProject();
        return JavaRefactoringDescriptor.handleToElement(project, handle);
    }

    public IResource handleToResource(String handle) {
        Assert.isNotNull((Object)handle);
        Assert.isLegal((!"".equals(handle) ? 1 : 0) != 0);
        return JavaRefactoringDescriptor.handleToResource(this.getProject(), handle, JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_RESOURCE));
    }

    public String resourceToHandle(IResource resource) {
        Assert.isNotNull((Object)resource);
        return JavaRefactoringDescriptor.resourceToHandle(this.getProject(), JavaRefactoringDescriptor.getHandlePrefix(IDENTIFIER_RESOURCE), resource);
    }
}

