/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringElementFilter;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPluginContribution;

public class RefactoringElementFilterDescriptor
implements IPluginContribution {
    private static final String EXTENSION_POINT_NAME = "internal_refactoringElementFilter";
    private static final String FILTER_TAG = "filter";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static RefactoringElementFilterDescriptor[] fgFilterDescriptors;
    private IConfigurationElement fElement;
    private RefactoringElementFilter fRefactoringElementFilter;
    private boolean fFilterOKToUse;

    public static boolean isFiltered(final ICompilationUnit cu) {
        if (cu == null) {
            return false;
        }
        RefactoringElementFilterDescriptor[] filterDescriptors = RefactoringElementFilterDescriptor.getFilterDescriptors();
        int i = 0;
        while (i < filterDescriptors.length) {
            final RefactoringElementFilter filter = filterDescriptors[i].getRefactoringElementFilter();
            if (filter != null) {
                final boolean[] filtered = new boolean[1];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        filtered[0] = filter.filter(cu);
                    }
                });
                if (filtered[0]) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static RefactoringElementFilterDescriptor[] getFilterDescriptors() {
        if (fgFilterDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.jdt.ui", EXTENSION_POINT_NAME);
            fgFilterDescriptors = RefactoringElementFilterDescriptor.createFilterDescriptors(elements);
        }
        return fgFilterDescriptors;
    }

    private static RefactoringElementFilterDescriptor[] createFilterDescriptors(IConfigurationElement[] elements) {
        ArrayList<RefactoringElementFilterDescriptor> result = new ArrayList<RefactoringElementFilterDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement element = elements[i];
            if (FILTER_TAG.equals(element.getName())) {
                final RefactoringElementFilterDescriptor[] desc = new RefactoringElementFilterDescriptor[1];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(RefactoringCoreMessages.RefactoringElementFilterDescriptor_filterDescriptionCreationError_message){

                    public void run() throws Exception {
                        desc[0] = new RefactoringElementFilterDescriptor(element, null);
                    }
                });
                if (desc[0] != null && !descIds.contains(desc[0].getId())) {
                    result.add(desc[0]);
                    descIds.add(desc[0].getId());
                }
            }
            ++i;
        }
        return result.toArray(new RefactoringElementFilterDescriptor[result.size()]);
    }

    private RefactoringElementFilterDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getFilterClass(), (String)"An extension for extension-point org.eclipse.jdt.ui.internal_refactoringElementFilter does not specify a valid class");
        Assert.isNotNull((Object)this.getId(), (String)"An extension for extension-point org.eclipse.jdt.ui.internal_refactoringElementFilter does not provide a valid ID");
        this.fFilterOKToUse = true;
    }

    private RefactoringElementFilter getRefactoringElementFilter() {
        if (!this.fFilterOKToUse) {
            return null;
        }
        if (this.fRefactoringElementFilter != null) {
            return this.fRefactoringElementFilter;
        }
        String message = Messages.format(RefactoringCoreMessages.RefactoringElementFilterDescriptor_filterCreationError_message, this.getId());
        SafeRunnable code = new SafeRunnable(message){

            public void run() throws Exception {
                RefactoringElementFilterDescriptor.this.fRefactoringElementFilter = (RefactoringElementFilter)RefactoringElementFilterDescriptor.this.fElement.createExecutableExtension(RefactoringElementFilterDescriptor.CLASS_ATTRIBUTE);
            }

            public void handleException(Throwable e) {
                RefactoringElementFilterDescriptor.this.fFilterOKToUse = false;
                super.handleException(e);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return this.fRefactoringElementFilter;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getFilterClass() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getLocalId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getPluginId() {
        return this.fElement.getNamespace();
    }

    /* synthetic */ RefactoringElementFilterDescriptor(IConfigurationElement iConfigurationElement, RefactoringElementFilterDescriptor refactoringElementFilterDescriptor) {
        this(iConfigurationElement);
    }
}

