/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceFactoryRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceIndirectionRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameResourceProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.JavaMoveRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInnerToTopRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSuperTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSuperTypeRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.ChangeSignatureWizard;
import org.eclipse.jdt.internal.ui.refactoring.ChangeTypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.ConvertAnonymousToNestedWizard;
import org.eclipse.jdt.internal.ui.refactoring.ExtractInterfaceWizard;
import org.eclipse.jdt.internal.ui.refactoring.InferTypeArgumentsWizard;
import org.eclipse.jdt.internal.ui.refactoring.InlineConstantWizard;
import org.eclipse.jdt.internal.ui.refactoring.InlineTempWizard;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceFactoryWizard;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceIndirectionWizard;
import org.eclipse.jdt.internal.ui.refactoring.MoveInnerToTopWizard;
import org.eclipse.jdt.internal.ui.refactoring.MoveInstanceMethodWizard;
import org.eclipse.jdt.internal.ui.refactoring.MoveMembersWizard;
import org.eclipse.jdt.internal.ui.refactoring.PullUpWizard;
import org.eclipse.jdt.internal.ui.refactoring.PushDownWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UseSupertypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.code.InlineMethodWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.refactoring.sef.SelfEncapsulateFieldWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringExecutionStarter {
    static /* synthetic */ Class class$0;

    private static RenameSupport createRenameSupport(IJavaElement element, String newName, int flags) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RenameSupport.create((IJavaProject)element, newName, flags);
            }
            case 3: {
                return RenameSupport.create((IPackageFragmentRoot)element, newName);
            }
            case 4: {
                return RenameSupport.create((IPackageFragment)element, newName, flags);
            }
            case 5: {
                return RenameSupport.create((ICompilationUnit)element, newName, flags);
            }
            case 7: {
                return RenameSupport.create((IType)element, newName, flags);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringExecutionStarter.createRenameSupport((IJavaElement)method.getDeclaringType(), newName, flags);
                }
                return RenameSupport.create((IMethod)element, newName, flags);
            }
            case 8: {
                return RenameSupport.create((IField)element, newName, flags);
            }
            case 15: {
                return RenameSupport.create((ITypeParameter)element, newName, flags);
            }
            case 14: {
                return RenameSupport.create((ILocalVariable)element, newName, flags);
            }
        }
        return null;
    }

    public static void startChangeSignatureRefactoring(IMethod method, final SelectionDispatchAction action, final Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isChangeSignatureAvailable(method)) {
            return;
        }
        ChangeSignatureRefactoring refactoring = new ChangeSignatureRefactoring(method);
        if (!ActionUtil.isProcessable(shell, refactoring.getMethod())) {
            return;
        }
        UserInterfaceStarter starter = new UserInterfaceStarter(){

            public final void activate(Refactoring ref, Shell parent, boolean save) throws CoreException {
                RefactoringStatusEntry entry;
                RefactoringStatus status = ref.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (status.hasFatalError() && ((entry = status.getEntryMatchingSeverity(4)).getCode() == 1 || entry.getCode() == 2)) {
                    String message = entry.getMessage();
                    Object element = entry.getData();
                    message = String.valueOf(message) + RefactoringMessages.RefactoringErrorDialogUtil_okToPerformQuestion;
                    if (element != null && MessageDialog.openQuestion((Shell)shell, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)message)) {
                        StructuredSelection selection = new StructuredSelection(element);
                        boolean wasEnabled = action.isEnabled();
                        action.selectionChanged((IStructuredSelection)selection);
                        if (action.isEnabled()) {
                            action.run((IStructuredSelection)selection);
                        } else {
                            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ModifyParameterAction_problem_title, (String)ActionMessages.ModifyParameterAction_problem_message);
                        }
                        action.setEnabled(wasEnabled);
                    }
                    return;
                }
                super.activate(ref, parent, save);
            }
        };
        starter.initialize(new ChangeSignatureWizard(refactoring));
        try {
            starter.activate(refactoring, shell, true);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.RefactoringStarter_unexpected_exception);
        }
    }

    public static void startChangeTypeRefactoring(ICompilationUnit unit, Shell shell, int offset, int length) throws JavaModelException {
        ChangeTypeRefactoring refactoring = new ChangeTypeRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new ChangeTypeWizard(refactoring), shell, RefactoringMessages.ChangeTypeAction_dialog_title, false);
    }

    public static void startConvertAnonymousRefactoring(ICompilationUnit unit, int offset, int length, Shell shell) throws JavaModelException {
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new ConvertAnonymousToNestedWizard(refactoring), shell, RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, false);
    }

    public static void startCutRefactoring(Object[] elements, Shell shell) throws CoreException, InterruptedException, InvocationTargetException {
        JavaDeleteProcessor processor = new JavaDeleteProcessor(elements);
        processor.setSuggestGetterSetterDeletion(false);
        processor.setQueries(new ReorgQueries(shell));
        new RefactoringExecutionHelper((Refactoring)new DeleteRefactoring((DeleteProcessor)processor), RefactoringCore.getConditionCheckingFailedSeverity(), false, shell, (IRunnableContext)new ProgressMonitorDialog(shell)).perform();
    }

    public static void startDeleteRefactoring(Object[] elements, Shell shell) throws CoreException {
        DeleteRefactoring refactoring = new DeleteRefactoring((DeleteProcessor)new JavaDeleteProcessor(elements));
        DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, false);
    }

    public static void startExtractInterfaceRefactoring(IType type, Shell shell) throws JavaModelException {
        ExtractInterfaceRefactoring refactoring = new ExtractInterfaceRefactoring(new ExtractInterfaceProcessor(type, JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject())));
        if (!ActionUtil.isProcessable(shell, refactoring.getExtractInterfaceProcessor().getType())) {
            return;
        }
        new RefactoringStarter().activate((Refactoring)refactoring, new ExtractInterfaceWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
    }

    public static void startInferTypeArgumentsRefactoring(IJavaElement[] elements, Shell shell) {
        if (!ActionUtil.areProcessable(shell, elements)) {
            return;
        }
        try {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements)) {
                return;
            }
            InferTypeArgumentsRefactoring refactoring = new InferTypeArgumentsRefactoring(elements);
            new RefactoringStarter().activate(refactoring, new InferTypeArgumentsWizard(refactoring), shell, RefactoringMessages.InferTypeArgumentsAction_dialog_title, true);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.InferTypeArgumentsAction_dialog_title, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public static boolean startInlineConstantRefactoring(ICompilationUnit unit, CompilationUnit node, int offset, int length, Shell shell, boolean activate) throws JavaModelException {
        InlineConstantRefactoring refactoring = new InlineConstantRefactoring(unit, node, offset, length);
        if (refactoring.checkStaticFinalConstantNameSelected().hasFatalError()) {
            if (activate) {
                MessageDialog.openInformation((Shell)shell, (String)RefactoringMessages.InlineConstantAction_dialog_title, (String)RefactoringMessages.InlineConstantAction_no_constant_reference_or_declaration);
            }
            return false;
        }
        if (activate) {
            new RefactoringStarter().activate(refactoring, new InlineConstantWizard(refactoring), shell, RefactoringMessages.InlineConstantAction_dialog_title, true);
        }
        return true;
    }

    public static boolean startInlineMethodRefactoring(IJavaElement unit, CompilationUnit node, int offset, int length, Shell shell, boolean activate) throws JavaModelException {
        InlineMethodRefactoring refactoring = InlineMethodRefactoring.create(unit, node, offset, length);
        if (refactoring == null) {
            if (activate) {
                MessageDialog.openInformation((Shell)shell, (String)RefactoringMessages.InlineMethodAction_dialog_title, (String)RefactoringMessages.InlineMethodAction_no_method_invocation_or_declaration_selected);
            }
            return false;
        }
        if (activate) {
            new RefactoringStarter().activate(refactoring, new InlineMethodWizard(refactoring), shell, RefactoringMessages.InlineMethodAction_dialog_title, true);
        }
        return true;
    }

    public static boolean startInlineTempRefactoring(ICompilationUnit unit, CompilationUnit node, ITextSelection selection, Shell shell, boolean activate) throws JavaModelException {
        InlineTempRefactoring refactoring = new InlineTempRefactoring(unit, selection.getOffset(), selection.getLength());
        if (!refactoring.checkIfTempSelected(node).hasFatalError()) {
            if (activate) {
                new RefactoringStarter().activate(refactoring, new InlineTempWizard(refactoring), shell, RefactoringMessages.InlineTempAction_inline_temp, false);
            }
            return true;
        }
        return false;
    }

    public static void startIntroduceFactoryRefactoring(ICompilationUnit unit, ITextSelection selection, Shell shell) throws JavaModelException {
        IntroduceFactoryRefactoring refactoring = new IntroduceFactoryRefactoring(unit, selection.getOffset(), selection.getLength());
        new RefactoringStarter().activate(refactoring, new IntroduceFactoryWizard(refactoring, RefactoringMessages.IntroduceFactoryAction_use_factory), shell, RefactoringMessages.IntroduceFactoryAction_dialog_title, false);
    }

    public static void startIntroduceIndirectionRefactoring(ICompilationUnit unit, int offset, int length, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring refactoring = new IntroduceIndirectionRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new IntroduceIndirectionWizard(refactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, true);
    }

    public static void startIntroduceIndirectionRefactoring(IClassFile file, int offset, int length, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring refactoring = new IntroduceIndirectionRefactoring(file, offset, length);
        new RefactoringStarter().activate(refactoring, new IntroduceIndirectionWizard(refactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, true);
    }

    public static void startIntroduceIndirectionRefactoring(IMethod method, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring refactoring = new IntroduceIndirectionRefactoring(method);
        new RefactoringStarter().activate(refactoring, new IntroduceIndirectionWizard(refactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, true);
    }

    public static void startMoveInnerRefactoring(IType type, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveInnerAvailable(type)) {
            return;
        }
        MoveInnerToTopRefactoring refactoring = new MoveInnerToTopRefactoring(type, JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject()));
        if (!ActionUtil.isProcessable(shell, refactoring.getInputType())) {
            return;
        }
        new RefactoringStarter().activate(refactoring, new MoveInnerToTopWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
    }

    public static void startMoveMethodRefactoring(IMethod method, Shell shell) throws JavaModelException {
        MoveInstanceMethodRefactoring refactoring = new MoveInstanceMethodRefactoring(new MoveInstanceMethodProcessor(method, JavaPreferencesSettings.getCodeGenerationSettings(method.getJavaProject())));
        new RefactoringStarter().activate((Refactoring)refactoring, new MoveInstanceMethodWizard(refactoring), shell, RefactoringMessages.MoveInstanceMethodAction_dialog_title, true);
    }

    public static void startMoveStaticMembersRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members)) {
            return;
        }
        HashSet<IMember> set = new HashSet<IMember>();
        set.addAll(Arrays.asList(members));
        IMember[] elements = set.toArray(new IMember[set.size()]);
        IJavaProject project = null;
        if (elements.length > 0) {
            project = elements[0].getJavaProject();
        }
        JavaMoveRefactoring refactoring = new JavaMoveRefactoring(new MoveStaticMembersProcessor(elements, JavaPreferencesSettings.getCodeGenerationSettings(project)));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ActionUtil.isProcessable(shell, ((MoveStaticMembersProcessor)refactoring.getAdapter(clazz)).getMembersToMove()[0].getCompilationUnit())) {
            new RefactoringStarter().activate((Refactoring)refactoring, new MoveMembersWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
        }
    }

    public static void startPullUpRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        PullUpRefactoring refactoring;
        if (!RefactoringAvailabilityTester.isPullUpAvailable(members)) {
            return;
        }
        IJavaProject project = null;
        if (members != null && members.length > 0) {
            project = members[0].getJavaProject();
        }
        if (!ActionUtil.isProcessable(shell, (refactoring = new PullUpRefactoring(new PullUpRefactoringProcessor(members, JavaPreferencesSettings.getCodeGenerationSettings(project)))).getPullUpProcessor().getDeclaringType())) {
            return;
        }
        new RefactoringStarter().activate((Refactoring)refactoring, new PullUpWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
    }

    public static void startPushDownRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isPushDownAvailable(members)) {
            return;
        }
        PushDownRefactoring refactoring = new PushDownRefactoring(new PushDownRefactoringProcessor(members));
        if (!ActionUtil.isProcessable(shell, refactoring.getPushDownProcessor().getDeclaringType())) {
            return;
        }
        new RefactoringStarter().activate((Refactoring)refactoring, new PushDownWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
    }

    public static void startRefactoring(IResource[] resources, IJavaElement[] elements, Shell shell) throws JavaModelException {
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, elements);
        if (policy.canEnable()) {
            JavaMoveProcessor processor = new JavaMoveProcessor(policy);
            JavaMoveRefactoring refactoring = new JavaMoveRefactoring(processor);
            ReorgMoveWizard wizard = new ReorgMoveWizard(refactoring);
            processor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
            processor.setReorgQueries(new ReorgQueries((Wizard)wizard));
            new RefactoringStarter().activate((Refactoring)refactoring, wizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
        }
    }

    public static void startRenameRefactoring(IJavaElement element, Shell shell) throws CoreException {
        RenameSupport support = RefactoringExecutionStarter.createRenameSupport(element, null, 1);
        if (support != null && support.preCheck().isOK()) {
            support.openDialog(shell);
        }
    }

    public static void startRenameResourceRefactoring(IResource resource, Shell shell) throws CoreException {
        JavaRenameRefactoring refactoring = new JavaRenameRefactoring(new RenameResourceProcessor(resource));
        RenameUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, true);
    }

    public static void startSelfEncapsulateRefactoring(IField field, Shell shell) {
        if (!ActionUtil.isProcessable(shell, field)) {
            return;
        }
        try {
            if (!RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                return;
            }
            SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(field);
            new RefactoringStarter().activate(refactoring, new SelfEncapsulateFieldWizard(refactoring), shell, ActionMessages.SelfEncapsulateFieldAction_dialog_title, true);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ActionMessages.SelfEncapsulateFieldAction_dialog_title, ActionMessages.SelfEncapsulateFieldAction_dialog_cannot_perform);
        }
    }

    public static void startUseSupertypeRefactoring(IType type, Shell shell) throws JavaModelException {
        UseSuperTypeRefactoring refactoring = new UseSuperTypeRefactoring(new UseSuperTypeProcessor(type));
        if (!ActionUtil.isProcessable(shell, refactoring.getUseSuperTypeProcessor().getSubType())) {
            return;
        }
        new RefactoringStarter().activate((Refactoring)refactoring, new UseSupertypeWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
    }

    private RefactoringExecutionStarter() {
    }
}

