/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.binary;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;

public class StubCreationOperation
implements IWorkspaceRunnable {
    private final StringBuffer fBuffer = new StringBuffer(2048);
    private final URI fOutputURI;
    private final List fPackages;
    private final boolean fStubInvisible;

    public StubCreationOperation(URI uri, List packages) {
        this(uri, packages, false);
    }

    public StubCreationOperation(URI uri, List packages, boolean stub) {
        Assert.isNotNull(uri);
        Assert.isNotNull(packages);
        this.fOutputURI = uri;
        this.fPackages = packages;
        this.fStubInvisible = stub;
    }

    private void appendEnumConstants(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        ArrayList<IField> list = new ArrayList<IField>(fields.length);
        int index = 0;
        while (index < fields.length) {
            IField field = fields[index];
            if (Flags.isEnum((int)field.getFlags())) {
                list.add(field);
            }
            ++index;
        }
        index = 0;
        while (index < list.size()) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(((IField)list.get(index)).getElementName());
            ++index;
        }
        this.fBuffer.append(";");
    }

    private void appendExpression(String signature) {
        switch (signature.charAt(0)) {
            case 'Z': {
                this.fBuffer.append("false");
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                this.fBuffer.append("0");
                break;
            }
            default: {
                this.fBuffer.append("(");
                this.fBuffer.append(Signature.toString((String)signature));
                this.fBuffer.append(")");
                this.fBuffer.append("null");
            }
        }
    }

    private void appendFieldDeclaration(IField field) throws JavaModelException {
        this.appendFlags((IMember)field);
        this.fBuffer.append(" ");
        String signature = field.getTypeSignature();
        this.fBuffer.append(Signature.toString((String)signature));
        this.fBuffer.append(" ");
        this.fBuffer.append(field.getElementName());
        if (Flags.isFinal((int)field.getFlags())) {
            this.fBuffer.append("=");
            this.appendExpression(signature);
        }
        this.fBuffer.append(";");
    }

    private void appendFlags(IMember member) throws JavaModelException {
        int flags = member.getFlags();
        int kind = member.getElementType();
        if (kind == 7) {
            flags &= 0xFFFFFFDF;
            IType type = (IType)member;
            if (!type.isMember()) {
                flags &= 0xFFFFFFFD;
            }
        }
        if (Flags.isEnum((int)flags)) {
            flags &= 0xFFFFFFEF;
        }
        if (kind == 9) {
            flags &= 0xFFFFFF7F;
            flags &= 0xFFFFFFBF;
        }
        if (flags != 0) {
            this.fBuffer.append(Flags.toString((int)flags));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void appendMembers(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            IJavaElement[] children = type.getChildren();
            int index = 0;
            while (index < children.length) {
                boolean stub;
                IMember child = (IMember)children[index];
                int flags = child.getFlags();
                boolean isPrivate = Flags.isPrivate((int)flags);
                boolean isDefault = !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !isPrivate;
                boolean bl = stub = this.fStubInvisible || !isPrivate && !isDefault;
                if (child instanceof IType) {
                    if (stub) {
                        this.appendTypeDeclaration((IType)child, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                } else if (child instanceof IField) {
                    if (stub && !Flags.isEnum((int)flags) && !Flags.isSynthetic((int)flags)) {
                        this.appendFieldDeclaration((IField)child);
                    }
                } else if (child instanceof IMethod) {
                    int count;
                    IMethod method = (IMethod)child;
                    String name = method.getElementName();
                    if (!(method.getDeclaringType().isEnum() && ((count = method.getNumberOfParameters()) == 0 && "values".equals(name) || count == 1 && "valueOf".equals(name) && "Ljava.lang.String;".equals(method.getParameterTypes()[0]) || method.isConstructor()))) {
                        boolean skip;
                        boolean bl2 = skip = !stub || name.equals("<clinit>");
                        if (method.isConstructor()) {
                            skip = false;
                        }
                        boolean bl3 = skip = skip || Flags.isSynthetic((int)flags) || Flags.isBridge((int)flags);
                        if (!skip) {
                            this.appendMethodDeclaration(method);
                        }
                    }
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        monitor.done();
    }

    private void appendMethodDeclaration(IMethod method) throws JavaModelException {
        this.appendFlags((IMember)method);
        this.fBuffer.append(" ");
        String returnType = method.getReturnType();
        if (!method.isConstructor()) {
            this.fBuffer.append(Signature.toString((String)returnType));
            this.fBuffer.append(" ");
            ITypeParameter[] parameters = method.getTypeParameters();
            if (parameters.length > 0) {
                this.appendTypeParameters(parameters);
                this.fBuffer.append(" ");
            }
        }
        this.fBuffer.append(method.getElementName());
        this.fBuffer.append("(");
        String[] parameterTypes = method.getParameterTypes();
        int flags = method.getFlags();
        boolean varargs = Flags.isVarargs((int)flags);
        int parameterLength = parameterTypes.length;
        int index = 0;
        while (index < parameterLength) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)parameterTypes[index]));
            if (varargs && index == parameterLength - 1) {
                int length = this.fBuffer.length();
                if (length >= 2 && this.fBuffer.indexOf("[]", length - 2) >= 0) {
                    this.fBuffer.setLength(length - 2);
                }
                this.fBuffer.append("...");
            }
            this.fBuffer.append(" a");
            this.fBuffer.append(index);
            ++index;
        }
        this.fBuffer.append(")");
        String[] exceptionTypes = method.getExceptionTypes();
        int exceptionLength = exceptionTypes.length;
        if (exceptionLength > 0) {
            this.fBuffer.append(" throws ");
        }
        int index2 = 0;
        while (index2 < exceptionLength) {
            if (index2 > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)exceptionTypes[index2]));
            ++index2;
        }
        if (Flags.isAbstract((int)flags) || Flags.isNative((int)flags)) {
            this.fBuffer.append(";");
        } else {
            IType declaringType;
            String superSignature;
            this.fBuffer.append("{");
            if (method.isConstructor() && (superSignature = (declaringType = method.getDeclaringType()).getSuperclassTypeSignature()) != null) {
                superSignature = Signature.getTypeErasure((String)superSignature);
                IType superclass = declaringType.getJavaProject().findType(Signature.getSignatureQualifier((String)superSignature), Signature.getSignatureSimpleName((String)superSignature));
                if (superclass != null) {
                    String[] superParameters;
                    int paramLength;
                    IMethod[] superMethods = superclass.getMethods();
                    IMethod superConstructor = null;
                    int length = superMethods.length;
                    int index3 = 0;
                    while (index3 < length) {
                        IMethod superMethod = superMethods[index3];
                        if (superMethod.isConstructor() && !Flags.isPrivate((int)superMethod.getFlags()) && (superConstructor = superMethod).getExceptionTypes().length == 0) break;
                        ++index3;
                    }
                    if (superConstructor != null && (paramLength = (superParameters = superConstructor.getParameterTypes()).length) != 0) {
                        this.fBuffer.append("super(");
                        int index4 = 0;
                        while (index4 < paramLength) {
                            if (index4 > 0) {
                                this.fBuffer.append(",");
                            }
                            this.appendExpression(superParameters[index4]);
                            ++index4;
                        }
                        this.fBuffer.append(");");
                    }
                }
            }
            if (!"V".equals(returnType)) {
                this.fBuffer.append("return ");
                this.appendExpression(returnType);
                this.fBuffer.append(";");
            }
            this.fBuffer.append("}");
        }
    }

    private void appendSuperInterfaceTypes(IType type) throws JavaModelException {
        String[] signatures = type.getSuperInterfaceTypeSignatures();
        if (signatures.length > 0) {
            if (type.isInterface()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" implements ");
            }
        }
        int index = 0;
        while (index < signatures.length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)signatures[index]));
            ++index;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void appendTypeDeclaration(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            if (type.isInterface()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" interface ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isClass()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" class ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                String signature = type.getSuperclassTypeSignature();
                if (signature != null) {
                    this.fBuffer.append(" extends ");
                    this.fBuffer.append(Signature.toString((String)signature));
                }
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isAnnotation()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" @interface ");
                this.fBuffer.append(type.getElementName());
                this.fBuffer.append("{");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isEnum()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" enum ");
                this.fBuffer.append(type.getElementName());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{");
                this.appendEnumConstants(type);
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void appendTypeParameters(ITypeParameter[] parameters) throws JavaModelException {
        int length = parameters.length;
        if (length > 0) {
            this.fBuffer.append("<");
        }
        int index = 0;
        while (index < length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            ITypeParameter parameter = parameters[index];
            this.fBuffer.append(parameter.getElementName());
            String[] bounds = parameter.getBounds();
            int size = bounds.length;
            if (size > 0) {
                this.fBuffer.append(" extends ");
            }
            int offset = 0;
            while (offset < size) {
                if (offset > 0) {
                    this.fBuffer.append(" & ");
                }
                this.fBuffer.append(bounds[offset]);
                ++offset;
            }
            ++index;
        }
        if (length > 0) {
            this.fBuffer.append(">");
        }
    }

    /*
     * Exception decompiling
     */
    protected void createCompilationUnit(IFileStore store, String name, String content, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 105->109)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void createPackageFragment(IFileStore store, String name, IProgressMonitor monitor) throws CoreException {
        store.mkdir(0, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(IClassFile file, IFileStore parent, IProgressMonitor monitor) throws CoreException {
        block7: {
            block6: {
                block5: {
                    try {
                        monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 2);
                        IType type = file.getType();
                        String name = type.getElementName();
                        if (name.length() == 0) {
                            Object var6_6 = null;
                            break block5;
                        }
                        if (type.isMember()) {
                            break block6;
                        }
                        this.fBuffer.append("package ");
                        this.fBuffer.append(file.getParent().getElementName());
                        this.fBuffer.append(";");
                        this.appendTypeDeclaration(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.createCompilationUnit(parent, String.valueOf(name) + ".java", this.fBuffer.toString(), monitor);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return;
            }
            Object var6_7 = null;
            monitor.done();
            return;
        }
        Object var6_9 = null;
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 100 * this.fPackages.size());
        try {
            StringBuffer buffer = new StringBuffer(128);
            Iterator iterator = this.fPackages.iterator();
            while (iterator.hasNext()) {
                Object var13_14;
                int index;
                IFileStore store;
                int size;
                IClassFile[] files;
                SubProgressMonitor subMonitor;
                block14: {
                    IPackageFragment fragment = (IPackageFragment)iterator.next();
                    subMonitor = new SubProgressMonitor(monitor, 100);
                    files = fragment.getClassFiles();
                    size = files.length;
                    subMonitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, size * 50);
                    String name = fragment.getElementName();
                    store = EFS.getStore((URI)this.fOutputURI);
                    String pack = "";
                    if (!"".equals(name)) {
                        pack = name;
                        buffer.setLength(0);
                        buffer.append(name);
                        int length = buffer.length();
                        index = 0;
                        while (true) {
                            if (index >= length) {
                                if ((store = store.getChild((IPath)new Path(buffer.toString()))).fetchInfo(0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10)).exists()) break;
                                this.createPackageFragment(store, pack, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
                                break block14;
                            }
                            if (buffer.charAt(index) == '.') {
                                buffer.setCharAt(index, '/');
                            }
                            ++index;
                        }
                        subMonitor.worked(10);
                    }
                }
                SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 30);
                try {
                    subsubMonitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, size * 100);
                    index = 0;
                    while (index < size) {
                        if (subMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        this.fBuffer.setLength(0);
                        this.run(files[index], store, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsubMonitor, 100));
                        ++index;
                    }
                }
                catch (Throwable throwable) {
                    var13_14 = null;
                    subsubMonitor.done();
                    throw throwable;
                }
                {
                    var13_14 = null;
                }
                subsubMonitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        monitor.done();
    }
}

