/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameJavaProjectChange
extends AbstractJavaElementRenameChange {
    public static final String ID_RENAME_JAVA_PROJECT = "org.eclipse.jdt.ui.rename.java.project";
    private static final String ATTRIBUTE_REFERENCES = "references";
    private boolean fUpdateReferences;

    public RenameJavaProjectChange(IJavaProject project, String newName, String comment, boolean updateReferences) {
        this(project.getPath(), project.getElementName(), newName, comment, -1L, updateReferences);
        Assert.isTrue(!project.isReadOnly(), "should not be read only");
    }

    private RenameJavaProjectChange(IPath resourcePath, String oldName, String newName, String comment, long stampToRestore, boolean updateReferences) {
        super(resourcePath, oldName, newName, comment);
        this.fUpdateReferences = updateReferences;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_rename, new String[]{this.getOldName(), this.getNewName()});
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRename(IProgressMonitor pm) throws CoreException {
        try {
            IProject project;
            pm.beginTask(this.getName(), 2);
            if (this.fUpdateReferences) {
                this.modifyClassPaths((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            if ((project = this.getProject()) != null) {
                IProjectDescription description = project.getDescription();
                description.setName(this.getNewName());
                project.move(description, 33, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        pm.done();
    }

    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long stampToRestore) throws JavaModelException {
        return new RenameJavaProjectChange(this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore, this.fUpdateReferences);
    }

    private IProject getProject() {
        IJavaProject jp = this.getJavaProject();
        if (jp == null) {
            return null;
        }
        return jp.getProject();
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)this.getModifiedElement();
    }

    private void modifyClassPaths(IProgressMonitor pm) throws JavaModelException {
        IProject[] referencing = this.getReferencingProjects();
        pm.beginTask(RefactoringCoreMessages.RenameJavaProjectChange_update, referencing.length);
        int i = 0;
        while (i < referencing.length) {
            IJavaProject jp = JavaCore.create((IProject)referencing[i]);
            if (jp != null && jp.exists()) {
                this.modifyClassPath(jp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else {
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
    }

    private void modifyClassPath(IJavaProject referencingProject, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        IClasspathEntry[] oldEntries = referencingProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length];
        int i = 0;
        while (i < newEntries.length) {
            newEntries[i] = this.isOurEntry(oldEntries[i]) ? this.createModifiedEntry(oldEntries[i]) : oldEntries[i];
            ++i;
        }
        referencingProject.setRawClasspath(newEntries, pm);
        pm.done();
    }

    private boolean isOurEntry(IClasspathEntry cpe) {
        if (cpe.getEntryKind() != 2) {
            return false;
        }
        return cpe.getPath().equals((Object)this.getResourcePath());
    }

    private IClasspathEntry createModifiedEntry(IClasspathEntry oldEntry) {
        return JavaCore.newProjectEntry((IPath)this.createNewPath(), (IAccessRule[])oldEntry.getAccessRules(), (boolean)oldEntry.combineAccessRules(), (IClasspathAttribute[])oldEntry.getExtraAttributes(), (boolean)oldEntry.isExported());
    }

    private IProject[] getReferencingProjects() {
        return this.getProject().getReferencingProjects();
    }

    public final ChangeDescriptor getDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        IJavaProject project = this.getJavaProject();
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_RENAME_JAVA_PROJECT, project.getElementName(), Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_descriptor_description, new String[]{this.getOldName(), this.getNewName()}), this.getComment(), arguments, 7);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)project));
        arguments.put("name", this.getNewName());
        arguments.put(ATTRIBUTE_REFERENCES, Boolean.valueOf(this.fUpdateReferences).toString());
        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
    }
}

