/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.composite;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.composite.CompositeRefactoring;
import org.eclipse.ltk.core.refactoring.Refactoring;

public final class ComposableRefactoringExtension {
    private final Refactoring fComposableRefactoring;
    private CompositeRefactoring fCompositeRefactoring;

    public ComposableRefactoringExtension(Refactoring refactoring) {
        Assert.isNotNull(refactoring);
        this.fComposableRefactoring = refactoring;
    }

    public final WorkingCopyOwner getGlobalWorkingCopyOwner() {
        if (this.fCompositeRefactoring != null) {
            return this.fCompositeRefactoring.getGlobalWorkingCopyOwner();
        }
        return null;
    }

    public final WorkingCopyOwner getLocalWorkingCopyOwner() {
        if (this.fCompositeRefactoring != null) {
            return this.fCompositeRefactoring.getLocalWorkingCopyOwner(this.fComposableRefactoring);
        }
        return null;
    }

    public final ICompilationUnit getWorkingCopy(ICompilationUnit original) throws JavaModelException {
        if (this.fCompositeRefactoring != null) {
            return this.fCompositeRefactoring.getWorkingCopy(original);
        }
        return original;
    }

    public final void setCompositeRefactoring(CompositeRefactoring refactoring) {
        Assert.isTrue(this.fCompositeRefactoring == null, "The refactoring can only be set once");
        Assert.isNotNull(refactoring);
        this.fCompositeRefactoring = refactoring;
    }
}

