/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.delegates;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateCreator;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;

public class DelegateFieldCreator
extends DelegateCreator {
    private VariableDeclarationFragment fOldFieldFragment;

    protected void initialize() {
        Assert.isTrue(this.getDeclaration() instanceof FieldDeclaration);
        Assert.isTrue(((FieldDeclaration)this.getDeclaration()).fragments().size() == 1);
        this.fOldFieldFragment = (VariableDeclarationFragment)((FieldDeclaration)this.getDeclaration()).fragments().get(0);
        if (this.getNewElementName() == null) {
            this.setNewElementName(this.fOldFieldFragment.getName().getIdentifier());
        }
        this.setInsertBefore(false);
    }

    protected ASTNode createBody(BodyDeclaration fd) throws JavaModelException {
        FieldDeclaration result = (FieldDeclaration)fd;
        Expression initializer = this.createDelegateFieldInitializer(result);
        return initializer;
    }

    protected ASTNode createDocReference(BodyDeclaration declaration) {
        MemberRef ref = this.getAst().newMemberRef();
        ref.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            ref.setQualifier(this.createDestinationTypeName());
        }
        return ref;
    }

    protected ASTNode getBodyHead(BodyDeclaration result) {
        return this.fOldFieldFragment;
    }

    protected ChildPropertyDescriptor getJavaDocProperty() {
        return FieldDeclaration.JAVADOC_PROPERTY;
    }

    protected ChildPropertyDescriptor getBodyProperty() {
        return VariableDeclarationFragment.INITIALIZER_PROPERTY;
    }

    protected IBinding getDeclarationBinding() {
        return this.fOldFieldFragment.resolveBinding();
    }

    protected RefactoringSessionDescriptor createRefactoringScript() {
        IField field;
        InlineConstantRefactoring resolving;
        IJavaElement element;
        IVariableBinding binding = this.fOldFieldFragment.resolveBinding();
        if (binding != null && (element = binding.getJavaElement()) instanceof IField && (resolving = new InlineConstantRefactoring(field = (IField)element)).canEnableDeprecationResolving()) {
            return resolving.createDeprecationResolution();
        }
        return null;
    }

    protected String getRefactoringScriptName() {
        IVariableBinding binding = this.fOldFieldFragment.resolveBinding();
        if (binding != null) {
            return DelegateFieldCreator.getRefactoringScriptName(binding);
        }
        return null;
    }

    public static String getRefactoringScriptName(IVariableBinding binding) {
        IJavaElement element = binding.getDeclaringClass().getJavaElement();
        if (element instanceof IType) {
            IType type = (IType)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(type.getFullyQualifiedName());
            buffer.append('.');
            buffer.append(binding.getName());
            buffer.append(".xml");
            return buffer.toString();
        }
        return null;
    }

    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateFieldCreator_text_edit_group_label;
    }

    private Expression createDelegateFieldInitializer(FieldDeclaration declaration) throws JavaModelException {
        Assert.isNotNull(declaration);
        Expression qualification = this.getAccess();
        if (qualification != null) {
            FieldAccess access = this.getAst().newFieldAccess();
            access.setExpression(qualification);
            access.setName(this.getAst().newSimpleName(this.getNewElementName()));
            return access;
        }
        SimpleName access = this.getAst().newSimpleName(this.getNewElementName());
        return access;
    }
}

