/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.delegates;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateCreator;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;

public class DelegateMethodCreator
extends DelegateCreator {
    private ASTNode fDelegateInvocation;
    private MethodRef fDocMethodReference;

    protected void initialize() {
        Assert.isTrue(this.getDeclaration() instanceof MethodDeclaration);
        if (this.getNewElementName() == null) {
            this.setNewElementName(((MethodDeclaration)this.getDeclaration()).getName().getIdentifier());
        }
        this.setInsertBefore(true);
    }

    protected ASTNode createBody(BodyDeclaration bd) throws JavaModelException {
        MethodDeclaration methodDeclaration = (MethodDeclaration)bd;
        if (methodDeclaration.getBody() == null) {
            return null;
        }
        return this.createDelegateMethodBody(methodDeclaration);
    }

    protected ASTNode createDocReference(BodyDeclaration declaration) throws JavaModelException {
        this.fDocMethodReference = this.getAst().newMethodRef();
        this.fDocMethodReference.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            this.fDocMethodReference.setQualifier(this.createDestinationTypeName());
        }
        this.createArguments((MethodDeclaration)declaration, this.fDocMethodReference.parameters(), false);
        return this.fDocMethodReference;
    }

    protected ASTNode getBodyHead(BodyDeclaration result) {
        return result;
    }

    protected ChildPropertyDescriptor getJavaDocProperty() {
        return MethodDeclaration.JAVADOC_PROPERTY;
    }

    protected ChildPropertyDescriptor getBodyProperty() {
        return MethodDeclaration.BODY_PROPERTY;
    }

    public ASTNode getDelegateInvocation() {
        return this.fDelegateInvocation;
    }

    public MethodRef getJavadocReference() {
        return this.fDocMethodReference;
    }

    protected Statement createMethodInvocation(MethodDeclaration declaration, MethodInvocation invocation) {
        PrimitiveType primitive;
        Assert.isNotNull(declaration);
        Assert.isNotNull(invocation);
        Object statement = null;
        Type type = declaration.getReturnType2();
        statement = type == null ? this.createExpressionStatement(invocation) : (type instanceof PrimitiveType ? ((primitive = (PrimitiveType)type).getPrimitiveTypeCode().equals(PrimitiveType.VOID) ? this.createExpressionStatement(invocation) : this.createReturnStatement(invocation)) : this.createReturnStatement(invocation));
        return statement;
    }

    protected RefactoringSessionDescriptor createRefactoringScript() {
        IMethod method;
        InlineMethodRefactoring resolving;
        IJavaElement element;
        MethodDeclaration declaration = (MethodDeclaration)this.getDeclaration();
        IMethodBinding binding = declaration.resolveBinding();
        if (binding != null && (element = binding.getJavaElement()) instanceof IMethod && (resolving = new InlineMethodRefactoring(method = (IMethod)element)).canEnableDeprecationResolving()) {
            return resolving.createDeprecationResolution();
        }
        return null;
    }

    protected IBinding getDeclarationBinding() {
        MethodDeclaration declaration = (MethodDeclaration)this.getDeclaration();
        return declaration.resolveBinding();
    }

    protected String getRefactoringScriptName() {
        MethodDeclaration declaration = (MethodDeclaration)this.getDeclaration();
        IMethodBinding binding = declaration.resolveBinding();
        if (binding != null) {
            return DelegateMethodCreator.getRefactoringScriptName(binding);
        }
        return null;
    }

    public static String getRefactoringScriptName(IMethodBinding binding) {
        Assert.isNotNull(binding);
        IJavaElement element = binding.getDeclaringClass().getJavaElement();
        if (element instanceof IType) {
            IType type = (IType)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(type.getFullyQualifiedName());
            buffer.append('.');
            buffer.append(binding.getName());
            buffer.append('(');
            ITypeBinding[] parameters = binding.getParameterTypes();
            int index = 0;
            while (index < parameters.length) {
                IJavaElement javaElem;
                if (index != 0) {
                    buffer.append(',');
                }
                if ((javaElem = parameters[index].getJavaElement()) instanceof IType) {
                    buffer.append(((IType)javaElem).getFullyQualifiedName());
                } else if (javaElem instanceof ITypeParameter) {
                    buffer.append(((ITypeParameter)javaElem).getElementName());
                } else {
                    buffer.append(parameters[index].getQualifiedName());
                }
                ++index;
            }
            buffer.append(')');
            buffer.append(".xml");
            return buffer.toString();
        }
        return null;
    }

    private void createArguments(MethodDeclaration declaration, List arguments, boolean methodInvocation) throws JavaModelException {
        Assert.isNotNull(declaration);
        Assert.isNotNull(arguments);
        SingleVariableDeclaration variable = null;
        int size = declaration.parameters().size();
        int index = 0;
        while (index < size) {
            variable = (SingleVariableDeclaration)declaration.parameters().get(index);
            if (methodInvocation) {
                SimpleName expression = this.getAst().newSimpleName(variable.getName().getIdentifier());
                arguments.add(expression);
            } else {
                MethodRefParameter parameter = this.getAst().newMethodRefParameter();
                parameter.setType(ASTNodeFactory.newType(this.getAst(), (VariableDeclaration)variable));
                if (index == size - 1 && declaration.isVarargs()) {
                    parameter.setVarargs(true);
                }
                arguments.add(parameter);
            }
            ++index;
        }
    }

    private Block createDelegateMethodBody(MethodDeclaration declaration) throws JavaModelException {
        ConstructorInvocation call;
        List arguments;
        ConstructorInvocation invocation;
        Assert.isNotNull(declaration);
        MethodDeclaration old = (MethodDeclaration)this.getDeclaration();
        if (old.isConstructor()) {
            invocation = this.getAst().newConstructorInvocation();
            arguments = invocation.arguments();
            call = invocation;
            this.fDelegateInvocation = invocation;
        } else {
            invocation = this.getAst().newMethodInvocation();
            invocation.setName(this.getAst().newSimpleName(this.getNewElementName()));
            invocation.setExpression(this.getAccess());
            arguments = invocation.arguments();
            call = this.createMethodInvocation(declaration, (MethodInvocation)invocation);
            this.fDelegateInvocation = invocation;
        }
        this.createArguments(declaration, arguments, true);
        Block body = this.getAst().newBlock();
        body.statements().add(call);
        return body;
    }

    private ExpressionStatement createExpressionStatement(MethodInvocation invocation) {
        Assert.isNotNull(invocation);
        return invocation.getAST().newExpressionStatement((Expression)invocation);
    }

    private ReturnStatement createReturnStatement(MethodInvocation invocation) {
        Assert.isNotNull(invocation);
        ReturnStatement statement = invocation.getAST().newReturnStatement();
        statement.setExpression((Expression)invocation);
        return statement;
    }

    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateMethodCreator_text_edit_group_field;
    }
}

