/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class NLSHintHelper {
    private NLSHintHelper() {
    }

    public static AccessorClassReference getAccessorClassReference(CompilationUnit astRoot, NLSElement nlsElement) {
        Region region = nlsElement.getPosition();
        return NLSHintHelper.getAccessorClassReference(astRoot, (IRegion)region);
    }

    public static AccessorClassReference getAccessorClassReference(CompilationUnit astRoot, IRegion region) {
        String resourceBundleName;
        ASTNode nlsStringLiteral = NodeFinder.perform((ASTNode)astRoot, region.getOffset(), region.getLength());
        if (nlsStringLiteral == null) {
            return null;
        }
        ASTNode parent = nlsStringLiteral.getParent();
        ITypeBinding accessorBinding = null;
        if (parent instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            List args = methodInvocation.arguments();
            if (args.indexOf(nlsStringLiteral) != 0) {
                return null;
            }
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding == null || !Modifier.isStatic((int)methodBinding.getModifiers())) {
                return null;
            }
            accessorBinding = methodBinding.getDeclaringClass();
        } else if (parent instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)parent;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return null;
            }
            IVariableBinding variableBinding = (IVariableBinding)binding;
            if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                return null;
            }
            accessorBinding = variableBinding.getDeclaringClass();
        } else if (parent instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment decl = (VariableDeclarationFragment)parent;
            if (decl.getInitializer() != null) {
                return null;
            }
            IVariableBinding binding = decl.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return null;
            }
            IVariableBinding variableBinding = binding;
            if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                return null;
            }
            if (!Modifier.isPublic((int)variableBinding.getModifiers())) {
                return null;
            }
            accessorBinding = variableBinding.getDeclaringClass();
        }
        if (accessorBinding == null) {
            return null;
        }
        try {
            resourceBundleName = NLSHintHelper.getResourceBundleName(accessorBinding);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (resourceBundleName != null) {
            return new AccessorClassReference(accessorBinding, resourceBundleName, new Region(parent.getStartPosition(), parent.getLength()));
        }
        return null;
    }

    public static IPackageFragment getPackageOfAccessorClass(IJavaProject javaProject, ITypeBinding accessorBinding) throws JavaModelException {
        ICompilationUnit unit;
        if (accessorBinding != null && (unit = Bindings.findCompilationUnit(accessorBinding, javaProject)) != null) {
            return (IPackageFragment)unit.getParent();
        }
        return null;
    }

    public static String getResourceBundleName(ITypeBinding accessorClassBinding) throws JavaModelException {
        IJavaElement je = accessorClassBinding.getJavaElement();
        if (je == null) {
            return null;
        }
        IOpenable openable = je.getOpenable();
        ICompilationUnit container = null;
        if (openable instanceof ICompilationUnit) {
            container = (ICompilationUnit)openable;
        } else if (openable instanceof IClassFile) {
            container = (IClassFile)openable;
        } else {
            Assert.isLegal((boolean)false);
        }
        CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)container, ASTProvider.WAIT_YES, null);
        return NLSHintHelper.getResourceBundleName(accessorClassBinding, astRoot);
    }

    public static String getResourceBundleName(ITypeBinding accessorClassBinding, CompilationUnit astRoot) throws JavaModelException {
        class STOP_VISITING
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            STOP_VISITING() {
            }
        }
        if (astRoot == null) {
            return null;
        }
        final HashMap resultCollector = new HashMap(5);
        final Object RESULT_KEY = new Object();
        final Object FIELD_KEY = new Object();
        try {
            astRoot.accept(new ASTVisitor(){

                public boolean visit(MethodInvocation node) {
                    IBinding fieldNameBinding;
                    IMethodBinding method = node.resolveMethodBinding();
                    if (method == null) {
                        return true;
                    }
                    String name = method.getDeclaringClass().getQualifiedName();
                    if (!"java.util.ResourceBundle".equals(name) || !"getBundle".equals(method.getName()) || node.arguments().size() <= 0) {
                        return true;
                    }
                    Expression argument = (Expression)node.arguments().get(0);
                    String bundleName = this.getBundleName(argument);
                    if (bundleName != null) {
                        resultCollector.put(RESULT_KEY, bundleName);
                        throw new STOP_VISITING();
                    }
                    if (argument instanceof Name && (fieldNameBinding = ((Name)argument).resolveBinding()) != null) {
                        resultCollector.put(FIELD_KEY, fieldNameBinding);
                        if (resultCollector.get(fieldNameBinding) != null) {
                            throw new STOP_VISITING();
                        }
                    }
                    return false;
                }

                public boolean visit(VariableDeclarationFragment node) {
                    Expression initializer = node.getInitializer();
                    String bundleName = this.getBundleName(initializer);
                    if (bundleName != null) {
                        IBinding fieldNameBinding = node.getName().resolveBinding();
                        if (fieldNameBinding != null) {
                            resultCollector.put(fieldNameBinding, bundleName);
                            if (fieldNameBinding.equals(resultCollector.get(FIELD_KEY))) {
                                throw new STOP_VISITING();
                            }
                        }
                        return false;
                    }
                    return true;
                }

                public boolean visit(Assignment node) {
                    IBinding fieldNameBinding;
                    String bundleName;
                    if (node.getLeftHandSide() instanceof Name && (bundleName = this.getBundleName(node.getRightHandSide())) != null && (fieldNameBinding = ((Name)node.getLeftHandSide()).resolveBinding()) != null) {
                        resultCollector.put(fieldNameBinding, bundleName);
                        if (fieldNameBinding.equals(resultCollector.get(FIELD_KEY))) {
                            throw new STOP_VISITING();
                        }
                        return false;
                    }
                    return true;
                }

                private String getBundleName(Expression initializer) {
                    SimpleType simple;
                    ITypeBinding typeBinding;
                    MethodInvocation methInvocation;
                    Expression exp;
                    if (initializer instanceof StringLiteral) {
                        return ((StringLiteral)initializer).getLiteralValue();
                    }
                    if (initializer instanceof MethodInvocation && (exp = (methInvocation = (MethodInvocation)initializer).getExpression()) != null && exp instanceof TypeLiteral && (typeBinding = (simple = (SimpleType)((TypeLiteral)exp).getType()).resolveBinding()) != null) {
                        return typeBinding.getQualifiedName();
                    }
                    return null;
                }
            });
        }
        catch (STOP_VISITING sTOP_VISITING) {}
        String result = (String)resultCollector.get(RESULT_KEY);
        if (result != null) {
            return result;
        }
        Object fieldName = resultCollector.get(FIELD_KEY);
        if (fieldName != null) {
            return (String)resultCollector.get(fieldName);
        }
        Iterator iter = resultCollector.keySet().iterator();
        while (iter.hasNext()) {
            IBinding binding = (IBinding)iter.next();
            if (binding == null || !(fieldName = binding.getName()).equals("BUNDLE_NAME") && !fieldName.equals("RESOURCE_BUNDLE") && !fieldName.equals("bundleName") || (result = (String)resultCollector.get(binding)) == null) continue;
            return result;
        }
        return null;
    }

    public static IPackageFragment getResourceBundlePackage(IJavaProject javaProject, String packageName, String resourceName) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() == 1 && (packageFragment = root.getPackageFragment(packageName)).exists()) {
                Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaResources() : packageFragment.getNonJavaResources();
                int j = 0;
                while (j < resources.length) {
                    IFile file;
                    Object object = resources[j];
                    if (object instanceof IFile && (file = (IFile)object).getName().equals(resourceName)) {
                        return packageFragment;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static IStorage getResourceBundle(IJavaProject javaProject, String packageName, String resourceName) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < allRoots.length) {
            IStorage storage;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() == 1 && (storage = NLSHintHelper.getResourceBundle(root, packageName, resourceName)) != null) {
                return storage;
            }
            ++i;
        }
        return null;
    }

    public static IStorage getResourceBundle(IPackageFragmentRoot root, String packageName, String resourceName) throws JavaModelException {
        IPackageFragment packageFragment = root.getPackageFragment(packageName);
        if (packageFragment.exists()) {
            Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaResources() : packageFragment.getNonJavaResources();
            int j = 0;
            while (j < resources.length) {
                IStorage storage;
                Object object = resources[j];
                if (object instanceof IStorage && (storage = (IStorage)object).getName().equals(resourceName)) {
                    return storage;
                }
                ++j;
            }
        }
        return null;
    }

    public static IStorage getResourceBundle(IJavaProject javaProject, AccessorClassReference accessorClassReference) throws JavaModelException {
        String resourceBundle = accessorClassReference.getResourceBundleName();
        if (resourceBundle == null) {
            return null;
        }
        String resourceName = String.valueOf(Signature.getSimpleName((String)resourceBundle)) + ".properties";
        String packName = Signature.getQualifier((String)resourceBundle);
        ITypeBinding accessorClass = accessorClassReference.getBinding();
        if (accessorClass.isFromSource()) {
            return NLSHintHelper.getResourceBundle(javaProject, packName, resourceName);
        }
        if (accessorClass.getJavaElement() != null) {
            return NLSHintHelper.getResourceBundle((IPackageFragmentRoot)accessorClass.getJavaElement().getAncestor(3), packName, resourceName);
        }
        return null;
    }

    public static Properties getProperties(IJavaProject javaProject, AccessorClassReference accessorClassReference) {
        try {
            IStorage storage = NLSHintHelper.getResourceBundle(javaProject, accessorClassReference);
            return NLSHintHelper.getProperties(storage);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static Properties getProperties(IStorage storage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 139->142)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

