/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScanner;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

class TextMatchUpdater {
    private static final String TEXT_EDIT_LABEL = RefactoringCoreMessages.TextMatchUpdater_update;
    private static final GroupCategorySet TEXTUAL_MATCHES = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.textualMatches", RefactoringCoreMessages.TextMatchUpdater_textualMatches_name, RefactoringCoreMessages.TextMatchUpdater_textualMatches_description));
    private final IJavaSearchScope fScope;
    private final TextChangeManager fManager;
    private final SearchResultGroup[] fReferences;
    private final boolean fOnlyQualified;
    private final RefactoringScanner fScanner;
    private final String fNewName;
    private final int fCurrentNameLength;

    private TextMatchUpdater(TextChangeManager manager, IJavaSearchScope scope, String currentName, String currentQualifier, String newName, SearchResultGroup[] references, boolean onlyQualified) {
        Assert.isNotNull(manager);
        Assert.isNotNull(scope);
        Assert.isNotNull(references);
        this.fManager = manager;
        this.fScope = scope;
        this.fReferences = references;
        this.fOnlyQualified = onlyQualified;
        this.fNewName = newName;
        this.fCurrentNameLength = currentName.length();
        this.fScanner = new RefactoringScanner(currentName, currentQualifier);
    }

    static void perform(IProgressMonitor pm, IJavaSearchScope scope, String currentName, String currentQualifier, String newName, TextChangeManager manager, SearchResultGroup[] references, boolean onlyQualified) throws JavaModelException {
        new TextMatchUpdater(manager, scope, currentName, currentQualifier, newName, references, onlyQualified).updateTextMatches(pm);
    }

    static void perform(IProgressMonitor pm, IJavaSearchScope scope, ITextUpdating processor, TextChangeManager manager, SearchResultGroup[] references) throws JavaModelException {
        new TextMatchUpdater(manager, scope, processor.getCurrentElementName(), processor.getCurrentElementQualifier(), processor.getNewElementName(), references, false).updateTextMatches(pm);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTextMatches(IProgressMonitor pm) throws JavaModelException {
        try {
            IProject[] projectsInScope = this.getProjectsInScope();
            pm.beginTask("", projectsInScope.length);
            int i = 0;
            while (i < projectsInScope.length) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.addTextMatches((IResource)projectsInScope[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        pm.done();
    }

    private IProject[] getProjectsInScope() {
        IPath[] enclosingProjects = this.fScope.enclosingProjectsAndJars();
        HashSet<IPath> enclosingProjectSet = new HashSet<IPath>();
        enclosingProjectSet.addAll(Arrays.asList(enclosingProjects));
        ArrayList<IProject> projectsInScope = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (enclosingProjectSet.contains(projects[i].getFullPath())) {
                projectsInScope.add(projects[i]);
            }
            ++i;
        }
        return projectsInScope.toArray(new IProject[projectsInScope.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTextMatches(IResource resource, IProgressMonitor pm) throws JavaModelException {
        block16: {
            block15: {
                block14: {
                    block13: {
                        try {
                            try {
                                String task = String.valueOf(RefactoringCoreMessages.TextMatchUpdater_searching) + resource.getFullPath();
                                if (resource instanceof IFile) {
                                    IJavaElement element = JavaCore.create((IResource)resource);
                                    if (!(element instanceof ICompilationUnit)) {
                                        Object var6_8 = null;
                                        break block13;
                                    }
                                    if (!element.exists()) {
                                        break block14;
                                    }
                                    if (!this.fScope.encloses(element)) {
                                        break block15;
                                    }
                                    this.addCuTextMatches((ICompilationUnit)element);
                                    break block16;
                                }
                                if (resource instanceof IContainer) {
                                    IResource[] members = ((IContainer)resource).members();
                                    pm.beginTask(task, members.length);
                                    pm.subTask(task);
                                    int i = 0;
                                    while (i < members.length) {
                                        if (pm.isCanceled()) {
                                            throw new OperationCanceledException();
                                        }
                                        this.addTextMatches(members[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                        ++i;
                                    }
                                }
                                break block16;
                            }
                            catch (JavaModelException e) {
                                throw e;
                            }
                            catch (CoreException e) {
                                throw new JavaModelException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_11 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return;
                }
                Object var6_9 = null;
                pm.done();
                return;
            }
            Object var6_10 = null;
            pm.done();
            return;
        }
        Object var6_12 = null;
        pm.done();
    }

    private void addCuTextMatches(ICompilationUnit cu) throws JavaModelException {
        this.fScanner.scan(cu);
        Set matches = this.fScanner.getMatches();
        if (matches.size() == 0) {
            return;
        }
        this.removeReferences(cu, matches);
        if (matches.size() != 0) {
            this.addTextUpdates(cu, matches);
        }
    }

    private void removeReferences(ICompilationUnit cu, Set matches) {
        int i = 0;
        while (i < this.fReferences.length) {
            SearchResultGroup group = this.fReferences[i];
            if (cu.equals(group.getCompilationUnit())) {
                this.removeReferences(matches, group);
            }
            ++i;
        }
    }

    private void removeReferences(Set matches, SearchResultGroup group) {
        SearchMatch[] searchResults = group.getSearchResults();
        int r = 0;
        while (r < searchResults.length) {
            int unqualifiedStart = searchResults[r].getOffset() + searchResults[r].getLength() - this.fCurrentNameLength;
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                RefactoringScanner.TextMatch element = (RefactoringScanner.TextMatch)iter.next();
                if (element.getStartPosition() != unqualifiedStart) continue;
                iter.remove();
            }
            ++r;
        }
    }

    private void addTextUpdates(ICompilationUnit cu, Set matches) {
        Iterator resultIter = matches.iterator();
        while (resultIter.hasNext()) {
            RefactoringScanner.TextMatch match = (RefactoringScanner.TextMatch)resultIter.next();
            if (!match.isQualified() && this.fOnlyQualified) continue;
            int matchStart = match.getStartPosition();
            ReplaceEdit edit = new ReplaceEdit(matchStart, this.fCurrentNameLength, this.fNewName);
            TextChangeCompatibility.addTextEdit(this.fManager.get(cu), TEXT_EDIT_LABEL, (TextEdit)edit, TEXTUAL_MATCHES);
        }
    }
}

