/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

class AccessAnalyzer
extends ASTVisitor {
    private ICompilationUnit fCUnit;
    private IVariableBinding fFieldBinding;
    private ITypeBinding fDeclaringClassBinding;
    private String fGetter;
    private String fSetter;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewriter;
    private List fGroupDescriptions;
    private RefactoringStatus fStatus;
    private boolean fSetterMustReturnValue;
    private boolean fEncapsulateDeclaringClass;
    private boolean fIsFieldFinal;
    private boolean fRemoveStaticImport;
    private boolean fReferencingGetter;
    private boolean fReferencingSetter;
    private static final String READ_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_read_access;
    private static final String WRITE_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_write_access;
    private static final String PREFIX_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_prefix_access;
    private static final String POSTFIX_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_postfix_access;
    static /* synthetic */ Class class$0;

    public AccessAnalyzer(SelfEncapsulateFieldRefactoring refactoring, ICompilationUnit unit, IVariableBinding field, ITypeBinding declaringClass, ASTRewrite rewriter, ImportRewrite importRewrite) {
        Assert.isNotNull(refactoring);
        Assert.isNotNull(unit);
        Assert.isNotNull(field);
        Assert.isNotNull(declaringClass);
        Assert.isNotNull(rewriter);
        Assert.isNotNull(importRewrite);
        this.fCUnit = unit;
        this.fFieldBinding = field.getVariableDeclaration();
        this.fDeclaringClassBinding = declaringClass;
        this.fRewriter = rewriter;
        this.fImportRewriter = importRewrite;
        this.fGroupDescriptions = new ArrayList();
        this.fGetter = refactoring.getGetterName();
        this.fSetter = refactoring.getSetterName();
        this.fEncapsulateDeclaringClass = refactoring.getEncapsulateDeclaringClass();
        try {
            this.fIsFieldFinal = Flags.isFinal((int)refactoring.getField().getFlags());
        }
        catch (JavaModelException javaModelException) {}
        this.fStatus = new RefactoringStatus();
    }

    public boolean getSetterMustReturnValue() {
        return this.fSetterMustReturnValue;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public List getGroupDescriptions() {
        return this.fGroupDescriptions;
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        if (!this.considerBinding(this.resolveBinding(lhs), (ASTNode)lhs)) {
            return true;
        }
        this.checkParent((ASTNode)node);
        if (!this.fIsFieldFinal) {
            AST ast = node.getAST();
            MethodInvocation invocation = ast.newMethodInvocation();
            invocation.setName(ast.newSimpleName(this.fSetter));
            this.fReferencingSetter = true;
            Expression receiver = this.getReceiver(lhs);
            if (receiver != null) {
                invocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
            }
            List arguments = invocation.arguments();
            if (node.getOperator() == Assignment.Operator.ASSIGN) {
                arguments.add(this.fRewriter.createCopyTarget((ASTNode)node.getRightHandSide()));
            } else {
                boolean needsParentheses = ASTNodes.needsParentheses(node.getRightHandSide());
                InfixExpression exp = ast.newInfixExpression();
                exp.setOperator(ASTNodes.convertToInfixOperator(node.getOperator()));
                MethodInvocation getter = ast.newMethodInvocation();
                getter.setName(ast.newSimpleName(this.fGetter));
                this.fReferencingGetter = true;
                if (receiver != null) {
                    getter.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                }
                exp.setLeftOperand((Expression)getter);
                Expression rhs = (Expression)this.fRewriter.createCopyTarget((ASTNode)node.getRightHandSide());
                if (needsParentheses) {
                    ParenthesizedExpression p = ast.newParenthesizedExpression();
                    p.setExpression(rhs);
                    rhs = p;
                }
                exp.setRightOperand(rhs);
                arguments.add(exp);
            }
            this.fRewriter.replace((ASTNode)node, (ASTNode)invocation, this.createGroupDescription(WRITE_ACCESS));
        }
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SimpleName node) {
        if (!node.isDeclaration() && this.considerBinding(node.resolveBinding(), (ASTNode)node)) {
            this.fReferencingGetter = true;
            this.fRewriter.replace((ASTNode)node, this.fRewriter.createStringPlaceholder(String.valueOf(this.fGetter) + "()", 32), this.createGroupDescription(READ_ACCESS));
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        if (this.considerBinding(node.resolveBinding(), (ASTNode)node)) {
            this.fRemoveStaticImport = true;
        }
        return false;
    }

    public boolean visit(PrefixExpression node) {
        Expression operand = node.getOperand();
        if (!this.considerBinding(this.resolveBinding(operand), (ASTNode)operand)) {
            return true;
        }
        PrefixExpression.Operator operator = node.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return true;
        }
        this.checkParent((ASTNode)node);
        this.fRewriter.replace((ASTNode)node, (ASTNode)this.createInvocation(node.getAST(), node.getOperand(), node.getOperator().toString()), this.createGroupDescription(PREFIX_ACCESS));
        return false;
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        if (!this.considerBinding(this.resolveBinding(operand), (ASTNode)operand)) {
            return true;
        }
        ASTNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement)) {
            this.fStatus.addError(RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_cannot_convert_postfix_expression, JavaStatusContext.create(this.fCUnit, (ISourceRange)new SourceRange((ASTNode)node)));
            return false;
        }
        this.fRewriter.replace((ASTNode)node, (ASTNode)this.createInvocation(node.getAST(), node.getOperand(), node.getOperator().toString()), this.createGroupDescription(POSTFIX_ACCESS));
        return false;
    }

    public void endVisit(CompilationUnit node) {
        if (!this.fRemoveStaticImport) {
            return;
        }
        ITypeBinding type = this.fFieldBinding.getDeclaringClass();
        String fieldName = this.fFieldBinding.getName();
        String typeName = type.getQualifiedName();
        if (this.fRemoveStaticImport) {
            this.fImportRewriter.removeStaticImport(String.valueOf(typeName) + "." + fieldName);
        }
        if (this.fReferencingGetter) {
            this.fImportRewriter.addStaticImport(typeName, this.fGetter, false);
        }
        if (this.fReferencingSetter) {
            this.fImportRewriter.addStaticImport(typeName, this.fSetter, false);
        }
    }

    private boolean considerBinding(IBinding binding, ASTNode node) {
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        boolean result = Bindings.equals((IBinding)this.fFieldBinding, (IBinding)((IVariableBinding)binding).getVariableDeclaration());
        if (!result || this.fEncapsulateDeclaringClass) {
            return result;
        }
        if (binding instanceof IVariableBinding) {
            AbstractTypeDeclaration type;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((type = (AbstractTypeDeclaration)ASTNodes.getParent(node, clazz)) != null) {
                ITypeBinding declaringType = type.resolveBinding();
                return !Bindings.equals((IBinding)this.fDeclaringClassBinding, (IBinding)declaringType);
            }
        }
        return true;
    }

    private void checkParent(ASTNode node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement)) {
            this.fSetterMustReturnValue = true;
        }
    }

    private IBinding resolveBinding(Expression expression) {
        if (expression instanceof SimpleName) {
            return ((SimpleName)expression).resolveBinding();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).resolveBinding();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName().resolveBinding();
        }
        return null;
    }

    private Expression getReceiver(Expression expression) {
        int type = expression.getNodeType();
        switch (type) {
            case 42: {
                return null;
            }
            case 40: {
                return ((QualifiedName)expression).getQualifier();
            }
            case 22: {
                return ((FieldAccess)expression).getExpression();
            }
        }
        return null;
    }

    private MethodInvocation createInvocation(AST ast, Expression operand, String operator) {
        Expression receiver = this.getReceiver(operand);
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(this.fSetter));
        if (receiver != null) {
            invocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
        }
        InfixExpression argument = ast.newInfixExpression();
        invocation.arguments().add(argument);
        if ("++".equals(operator)) {
            argument.setOperator(InfixExpression.Operator.PLUS);
        } else if ("--".equals(operator)) {
            argument.setOperator(InfixExpression.Operator.MINUS);
        } else {
            Assert.isTrue(false, "Should not happen");
        }
        MethodInvocation getter = ast.newMethodInvocation();
        getter.setName(ast.newSimpleName(this.fGetter));
        if (receiver != null) {
            getter.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
        }
        argument.setLeftOperand((Expression)getter);
        argument.setRightOperand((Expression)ast.newNumberLiteral("1"));
        this.fReferencingGetter = true;
        this.fReferencingSetter = true;
        return invocation;
    }

    private TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fGroupDescriptions.add(result);
        return result;
    }
}

