/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.IInitializableRefactoringComponent;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsCreator;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.text.edits.TextEditGroup;

public abstract class SuperTypeRefactoringProcessor
extends RefactoringProcessor
implements IInitializableRefactoringComponent,
ICommentProvider {
    protected static final String ATTRIBUTE_INSTANCEOF = "instanceof";
    private static final int SIZE_BATCH = 500;
    protected boolean fInstanceOf = false;
    protected Map fObsoleteCasts = null;
    protected String fComment;
    protected final WorkingCopyOwner fOwner = new WorkingCopyOwner(){};
    protected Map fTypeOccurrences = null;
    static /* synthetic */ Class class$0;

    protected static ASTNode createCorrespondingNode(CompilationUnitRewrite rewrite, TType type) {
        return rewrite.getImportRewrite().addImportFromSignature(new BindingKey(type.getBindingKey()).toSignature(), rewrite.getAST());
    }

    protected abstract SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel var1);

    protected final IField getCorrespondingField(VariableDeclarationFragment fragment) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element;
        IVariableBinding variable;
        IBinding binding = fragment.getName().resolveBinding();
        if (binding instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField() && (element = (unit = RefactoringASTParser.getCompilationUnit((ASTNode)fragment)).getElementAt(fragment.getStartPosition())) instanceof IField) {
            return (IField)element;
        }
        return null;
    }

    protected final void getFieldReferencingCompilationUnits(Map units, ASTNode[] nodes) throws JavaModelException {
        ASTNode node = null;
        IField field = null;
        IJavaProject project = null;
        int index = 0;
        while (index < nodes.length) {
            node = nodes[index];
            project = RefactoringASTParser.getCompilationUnit(node).getJavaProject();
            if (project != null) {
                List fields = this.getReferencingFields(node, project);
                int offset = 0;
                while (offset < fields.size()) {
                    ICompilationUnit unit;
                    field = (IField)fields.get(offset);
                    HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)units.get(project);
                    if (set == null) {
                        set = new HashSet<ICompilationUnit>();
                        units.put(project, set);
                    }
                    if ((unit = field.getCompilationUnit()) != null) {
                        set.add(unit);
                    }
                    ++offset;
                }
            }
            ++index;
        }
    }

    protected final void getMethodReferencingCompilationUnits(Map units, ASTNode[] nodes) throws JavaModelException {
        ASTNode node = null;
        IMethod method = null;
        IJavaProject project = null;
        int index = 0;
        while (index < nodes.length) {
            node = nodes[index];
            project = RefactoringASTParser.getCompilationUnit(node).getJavaProject();
            if (project != null && (method = this.getReferencingMethod(node)) != null) {
                ICompilationUnit unit;
                HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)units.get(project);
                if (set == null) {
                    set = new HashSet<ICompilationUnit>();
                    units.put(project, set);
                }
                if ((unit = method.getCompilationUnit()) != null) {
                    set.add(unit);
                }
            }
            ++index;
        }
    }

    protected final Map getReferencingCompilationUnits(IType type, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Map map;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2();
            engine.setOwner(this.fOwner);
            engine.setFiltering(true, true);
            engine.setStatus(status);
            engine.setScope(RefactoringScopeFactory.create((IJavaElement)type));
            engine.setPattern(SearchPattern.createPattern((IJavaElement)type, (int)2, (int)24));
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            map = engine.getAffectedProjects();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return map;
    }

    protected final List getReferencingFields(ASTNode node, IJavaProject project) throws JavaModelException {
        ArrayList<IField> result = Collections.EMPTY_LIST;
        if (node instanceof Type) {
            BodyDeclaration parent;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((parent = (BodyDeclaration)ASTNodes.getParent(node, clazz)) instanceof FieldDeclaration) {
                List fragments = ((FieldDeclaration)parent).fragments();
                result = new ArrayList<IField>(fragments.size());
                VariableDeclarationFragment fragment = null;
                Iterator iterator = fragments.iterator();
                while (iterator.hasNext()) {
                    fragment = (VariableDeclarationFragment)iterator.next();
                    IField field = this.getCorrespondingField(fragment);
                    if (field == null) continue;
                    result.add(field);
                }
            }
        }
        return result;
    }

    protected final IMethod getReferencingMethod(ASTNode node) throws JavaModelException {
        if (node instanceof Type) {
            ICompilationUnit unit;
            IJavaElement element;
            IMethodBinding binding;
            BodyDeclaration parent;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((parent = (BodyDeclaration)ASTNodes.getParent(node, clazz)) instanceof MethodDeclaration && (binding = ((MethodDeclaration)parent).resolveBinding()) != null && (element = (unit = RefactoringASTParser.getCompilationUnit(node)).getElementAt(node.getStartPosition())) instanceof IMethod) {
                return (IMethod)element;
            }
        }
        return null;
    }

    public final boolean isInstanceOf() {
        return this.fInstanceOf;
    }

    protected final void performFirstPass(SuperTypeConstraintsCreator creator, Map units, Map groups, ICompilationUnit unit, CompilationUnit node) {
        node.setProperty("org.eclipse.jdt.ui.refactoring.ast_source", (Object)unit);
        node.accept((ASTVisitor)creator);
        SearchResultGroup group = (SearchResultGroup)groups.get(unit);
        if (group != null) {
            ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), node);
            try {
                this.getMethodReferencingCompilationUnits(units, nodes);
                this.getFieldReferencingCompilationUnits(units, nodes);
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
    }

    protected final void performSecondPass(SuperTypeConstraintsCreator creator, ICompilationUnit unit, CompilationUnit node) {
        node.setProperty("org.eclipse.jdt.ui.refactoring.ast_source", (Object)unit);
        node.accept((ASTVisitor)creator);
    }

    protected final void rewriteTypeOccurrence(CompilationUnitRange range, TType estimate, ASTRequestor requestor, CompilationUnitRewrite rewrite, CompilationUnit copy, Set replacements, TextEditGroup group) {
        ASTNode node = null;
        IVariableBinding binding = null;
        CompilationUnit target = rewrite.getRoot();
        node = NodeFinder.perform((ASTNode)copy, range.getSourceRange());
        if (node != null) {
            if ((node = ASTNodes.getNormalizedNode(node).getParent()) instanceof VariableDeclaration) {
                binding = ((VariableDeclaration)node).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof SingleVariableDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((SingleVariableDeclaration)node).getType(), group);
                    if (node.getParent() instanceof MethodDeclaration && (binding = ((VariableDeclaration)node).resolveBinding()) != null) {
                        replacements.add(binding.getKey());
                    }
                }
            } else if (node instanceof VariableDeclarationStatement) {
                binding = ((VariableDeclaration)((VariableDeclarationStatement)node).fragments().get(0)).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof VariableDeclarationFragment) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((VariableDeclarationStatement)((VariableDeclarationFragment)node).getParent()).getType(), group);
                }
            } else if (node instanceof MethodDeclaration) {
                binding = ((MethodDeclaration)node).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof MethodDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((MethodDeclaration)node).getReturnType2(), group);
                }
            } else if (node instanceof FieldDeclaration) {
                binding = ((VariableDeclaration)((FieldDeclaration)node).fragments().get(0)).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof VariableDeclarationFragment && (node = node.getParent()) instanceof FieldDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((FieldDeclaration)node).getType(), group);
                }
            } else if (node instanceof ArrayType) {
                ASTNode type = node;
                while (node != null && !(node instanceof MethodDeclaration) && !(node instanceof VariableDeclarationFragment)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - type.getStartPosition();
                    if (node instanceof MethodDeclaration) {
                        binding = ((MethodDeclaration)node).resolveBinding();
                    } else if (node instanceof VariableDeclarationFragment) {
                        binding = ((VariableDeclarationFragment)node).resolveBinding();
                    }
                    if (binding != null && ((node = target.findDeclaringNode(binding.getKey())) instanceof MethodDeclaration || node instanceof VariableDeclarationFragment) && (node = NodeFinder.perform((ASTNode)target, node.getStartPosition() + node.getLength() - delta, 0)) instanceof SimpleName) {
                        this.rewriteTypeOccurrence(estimate, rewrite, node, group);
                    }
                }
            } else if (node instanceof QualifiedName) {
                ASTNode name = node;
                while (node != null && !(node instanceof MethodDeclaration) && !(node instanceof VariableDeclarationFragment)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - name.getStartPosition();
                    if (node instanceof MethodDeclaration) {
                        binding = ((MethodDeclaration)node).resolveBinding();
                    } else if (node instanceof VariableDeclarationFragment) {
                        binding = ((VariableDeclarationFragment)node).resolveBinding();
                    }
                    if (binding != null && ((node = target.findDeclaringNode(binding.getKey())) instanceof SimpleName || node instanceof MethodDeclaration || node instanceof VariableDeclarationFragment) && (node = NodeFinder.perform((ASTNode)target, node.getStartPosition() + node.getLength() - delta, 0)) instanceof SimpleName) {
                        this.rewriteTypeOccurrence(estimate, rewrite, node, group);
                    }
                }
            } else if (node instanceof CastExpression) {
                ASTNode expression = node;
                while (node != null && !(node instanceof MethodDeclaration)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - expression.getStartPosition();
                    binding = ((MethodDeclaration)node).resolveBinding();
                    if ((node = target.findDeclaringNode(binding.getKey())) instanceof MethodDeclaration && (node = NodeFinder.perform((ASTNode)target, node.getStartPosition() + node.getLength() - delta, 0)) instanceof CastExpression) {
                        this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((CastExpression)node).getType(), group);
                    }
                }
            }
        }
    }

    protected final void rewriteTypeOccurrence(TType estimate, CompilationUnitRewrite rewrite, ASTNode node, TextEditGroup group) {
        rewrite.getImportRemover().registerRemovedNode(node);
        rewrite.getASTRewrite().replace(node, SuperTypeRefactoringProcessor.createCorrespondingNode(rewrite, estimate), group);
    }

    protected abstract void rewriteTypeOccurrences(TextChangeManager var1, ASTRequestor var2, CompilationUnitRewrite var3, ICompilationUnit var4, CompilationUnit var5, Set var6) throws CoreException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void rewriteTypeOccurrences(TextChangeManager manager, ASTRequestor sourceRequestor, CompilationUnitRewrite sourceRewrite, ICompilationUnit subUnit, CompilationUnit subNode, Set replacements, RefactoringStatus status, IProgressMonitor monitor) {
        if (this.fTypeOccurrences == null) return;
        HashSet units = new HashSet(this.fTypeOccurrences.keySet());
        if (subUnit != null) {
            units.remove(subUnit);
        }
        HashMap<IJavaProject, ArrayList<ICompilationUnit>> projects = new HashMap<IJavaProject, ArrayList<ICompilationUnit>>();
        Collection collection = null;
        IJavaProject project = null;
        ICompilationUnit current = null;
        Iterator iterator = units.iterator();
        while (iterator.hasNext()) {
            current = (ICompilationUnit)iterator.next();
            project = current.getJavaProject();
            collection = (ArrayList<ICompilationUnit>)projects.get(project);
            if (collection == null) {
                collection = new ArrayList<ICompilationUnit>();
                projects.put(project, (ArrayList<ICompilationUnit>)collection);
            }
            collection.add(current);
        }
        ASTParser parser = ASTParser.newParser((int)3);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        try {
            Set keySet = projects.keySet();
            subMonitor.beginTask("", keySet.size());
            subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            Iterator iterator2 = keySet.iterator();
            while (iterator2.hasNext()) {
                Object var19_19;
                project = (IJavaProject)iterator2.next();
                collection = (Collection)projects.get(project);
                parser.setWorkingCopyOwner(this.fOwner);
                parser.setResolveBindings(true);
                parser.setProject(project);
                parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
                SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                try {
                    subsubMonitor.beginTask("", collection.size());
                    subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, sourceRewrite, manager, replacements, status){
                        private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                        private final /* synthetic */ CompilationUnitRewrite val$sourceRewrite;
                        private final /* synthetic */ TextChangeManager val$manager;
                        private final /* synthetic */ Set val$replacements;
                        private final /* synthetic */ RefactoringStatus val$status;
                        {
                            this.val$subsubMonitor = iProgressMonitor;
                            this.val$sourceRewrite = compilationUnitRewrite;
                            this.val$manager = textChangeManager;
                            this.val$replacements = set;
                            this.val$status = refactoringStatus;
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                            try {
                                try {
                                    if (this.val$sourceRewrite != null) {
                                        SuperTypeRefactoringProcessor.this.rewriteTypeOccurrences(this.val$manager, this, this.val$sourceRewrite, unit, node, this.val$replacements);
                                    }
                                }
                                catch (CoreException exception) {
                                    this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                this.val$subsubMonitor.worked(1);
                                throw throwable;
                            }
                            {
                                Object var4_6 = null;
                            }
                            this.val$subsubMonitor.worked(1);
                        }

                        public final void acceptBinding(String key, IBinding binding) {
                        }
                    }, (IProgressMonitor)subsubMonitor);
                    var19_19 = null;
                }
                catch (Throwable throwable) {
                    var19_19 = null;
                    subsubMonitor.done();
                    throw throwable;
                }
                subsubMonitor.done();
            }
            Object var21_23 = null;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            subMonitor.done();
            throw throwable;
        }
        subMonitor.done();
        {
            if (subUnit == null) return;
            if (subNode == null) return;
            if (sourceRewrite == null) return;
            if (sourceRequestor == null) return;
            this.rewriteTypeOccurrences(manager, sourceRequestor, sourceRewrite, subUnit, subNode, replacements);
            return;
        }
    }

    public final void setInstanceOf(boolean rewrite) {
        this.fInstanceOf = rewrite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void solveSuperTypeConstraints(ICompilationUnit subUnit, CompilationUnit subNode, IType subType, ITypeBinding subBinding, ITypeBinding superBinding, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(subType);
        Assert.isNotNull(subBinding);
        Assert.isNotNull(superBinding);
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        int level = 3;
        TypeEnvironment environment = new TypeEnvironment();
        SuperTypeConstraintsModel model = new SuperTypeConstraintsModel(environment, environment.create(subBinding), environment.create(superBinding));
        SuperTypeConstraintsCreator creator = new SuperTypeConstraintsCreator(model, this.fInstanceOf);
        try {
            monitor.beginTask("", 3);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            Map firstPass = this.getReferencingCompilationUnits(subType, (IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            HashMap secondPass = new HashMap();
            IJavaProject project = null;
            Collection collection = null;
            try {
                Object var30_35;
                Set keySet;
                ASTParser parser = ASTParser.newParser((int)3);
                Object element = null;
                ICompilationUnit current = null;
                SearchResultGroup group = null;
                SearchMatch[] matches = null;
                HashMap<ICompilationUnit, SearchResultGroup> groups = new HashMap<ICompilationUnit, SearchResultGroup>();
                Iterator outer = firstPass.keySet().iterator();
                while (outer.hasNext()) {
                    project = (IJavaProject)outer.next();
                    if (level == 3 && !JavaModelUtil.is50OrHigher(project)) {
                        level = 2;
                    }
                    if ((collection = (Collection)firstPass.get(project)) == null) continue;
                    Iterator inner = collection.iterator();
                    while (inner.hasNext()) {
                        group = (SearchResultGroup)inner.next();
                        matches = group.getSearchResults();
                        int index = 0;
                        while (index < matches.length) {
                            element = matches[index].getElement();
                            if (element instanceof IMember && (current = ((IMember)element).getCompilationUnit()) != null) {
                                groups.put(current, group);
                            }
                            ++index;
                        }
                    }
                }
                HashSet<ICompilationUnit> units = null;
                HashSet<ICompilationUnit> processed = new HashSet<ICompilationUnit>();
                if (subUnit != null) {
                    processed.add(subUnit);
                }
                model.beginCreation();
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    keySet = firstPass.keySet();
                    subMonitor.beginTask("", keySet.size());
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    Iterator outer2 = keySet.iterator();
                    while (outer2.hasNext()) {
                        project = (IJavaProject)outer2.next();
                        collection = (Collection)firstPass.get(project);
                        if (collection == null) continue;
                        units = new HashSet<ICompilationUnit>(collection.size());
                        Iterator inner = collection.iterator();
                        while (inner.hasNext()) {
                            group = (SearchResultGroup)inner.next();
                            matches = group.getSearchResults();
                            int index = 0;
                            while (index < matches.length) {
                                element = matches[index].getElement();
                                if (element instanceof IMember && (current = ((IMember)element).getCompilationUnit()) != null) {
                                    units.add(current);
                                }
                                ++index;
                            }
                        }
                        ArrayList batches = new ArrayList(units);
                        int size = batches.size();
                        int iterations = (size - 1) / 500 + 1;
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                        subsubMonitor.beginTask("", iterations);
                        subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                        Map options = RefactoringASTParser.getCompilerOptions((IJavaElement)project);
                        int index = 0;
                        while (index < iterations) {
                            Object var36_42;
                            List iteration = batches.subList(index * 500, Math.min(size, (index + 1) * 500));
                            parser.setWorkingCopyOwner(this.fOwner);
                            parser.setResolveBindings(true);
                            parser.setProject(project);
                            parser.setCompilerOptions(options);
                            SubProgressMonitor subsubsubMonitor = new SubProgressMonitor((IProgressMonitor)subsubMonitor, 1);
                            try {
                                int count = iteration.size();
                                subsubsubMonitor.beginTask("", count);
                                subsubsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                                parser.createASTs(iteration.toArray(new ICompilationUnit[count]), new String[0], new ASTRequestor((IProgressMonitor)subsubsubMonitor, processed, creator, secondPass, groups){
                                    private final /* synthetic */ IProgressMonitor val$subsubsubMonitor;
                                    private final /* synthetic */ Set val$processed;
                                    private final /* synthetic */ SuperTypeConstraintsCreator val$creator;
                                    private final /* synthetic */ Map val$secondPass;
                                    private final /* synthetic */ Map val$groups;
                                    {
                                        this.val$subsubsubMonitor = iProgressMonitor;
                                        this.val$processed = set;
                                        this.val$creator = superTypeConstraintsCreator;
                                        this.val$secondPass = map;
                                        this.val$groups = map2;
                                    }

                                    /*
                                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                        try {
                                            this.val$subsubsubMonitor.subTask(unit.getElementName());
                                            if (!this.val$processed.contains(unit)) {
                                                SuperTypeRefactoringProcessor.this.performFirstPass(this.val$creator, this.val$secondPass, this.val$groups, unit, node);
                                                this.val$processed.add(unit);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_4 = null;
                                            this.val$subsubsubMonitor.worked(1);
                                            throw throwable;
                                        }
                                        {
                                            Object var3_5 = null;
                                        }
                                        this.val$subsubsubMonitor.worked(1);
                                    }

                                    public final void acceptBinding(String key, IBinding binding) {
                                    }
                                }, (IProgressMonitor)subsubsubMonitor);
                                var36_42 = null;
                            }
                            catch (Throwable throwable) {
                                var36_42 = null;
                                subsubsubMonitor.done();
                                throw throwable;
                            }
                            subsubsubMonitor.done();
                            ++index;
                        }
                    }
                    Object var38_46 = null;
                    firstPass.clear();
                }
                catch (Throwable throwable) {
                    Object var38_45 = null;
                    firstPass.clear();
                    subMonitor.done();
                    throw throwable;
                }
                subMonitor.done();
                if (subUnit != null && subNode != null) {
                    this.performFirstPass(creator, secondPass, groups, subUnit, subNode);
                }
                subMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    keySet = secondPass.keySet();
                    subMonitor.beginTask("", keySet.size());
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    Iterator iterator = keySet.iterator();
                    while (iterator.hasNext()) {
                        project = (IJavaProject)iterator.next();
                        if (level == 3 && !JavaModelUtil.is50OrHigher(project)) {
                            level = 2;
                        }
                        if ((collection = (Collection)secondPass.get(project)) == null) continue;
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                        try {
                            subsubMonitor.beginTask("", collection.size());
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, processed, creator){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ Set val$processed;
                                private final /* synthetic */ SuperTypeConstraintsCreator val$creator;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$processed = set;
                                    this.val$creator = superTypeConstraintsCreator;
                                }

                                /*
                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                    try {
                                        this.val$subsubMonitor.subTask(unit.getElementName());
                                        if (!this.val$processed.contains(unit)) {
                                            SuperTypeRefactoringProcessor.this.performSecondPass(this.val$creator, unit, node);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_4 = null;
                                        this.val$subsubMonitor.worked(1);
                                        throw throwable;
                                    }
                                    {
                                        Object var3_5 = null;
                                    }
                                    this.val$subsubMonitor.worked(1);
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)subsubMonitor);
                            Object var28_32 = null;
                        }
                        catch (Throwable throwable) {
                            Object var28_31 = null;
                            subsubMonitor.done();
                            throw throwable;
                        }
                        subsubMonitor.done();
                    }
                    var30_35 = null;
                    secondPass.clear();
                }
                catch (Throwable throwable) {
                    var30_35 = null;
                    secondPass.clear();
                    subMonitor.done();
                    throw throwable;
                }
                subMonitor.done();
                Object var40_49 = null;
                model.endCreation();
                model.setCompliance(level);
                SuperTypeConstraintsSolver solver = this.createContraintSolver(model);
                solver.solveConstraints();
                this.fTypeOccurrences = solver.getTypeOccurrences();
                this.fObsoleteCasts = solver.getObsoleteCasts();
            }
            catch (Throwable throwable) {
                Object var40_48 = null;
                model.endCreation();
                model.setCompliance(level);
                throw throwable;
            }
            Object var42_52 = null;
        }
        catch (Throwable throwable) {
            Object var42_51 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public boolean canEnableComment() {
        return true;
    }

    public final String getComment() {
        return this.fComment;
    }

    public final void setComment(String comment) {
        this.fComment = comment;
    }
}

