/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackagesProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class PackagesViewHierarchicalContentProvider
extends LogicalPackagesProvider
implements ITreeContentProvider {
    public PackagesViewHierarchicalContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public Object[] getChildren(Object parentElement) {
        block23: {
            try {
                if (parentElement instanceof IJavaElement) {
                    IJavaElement iJavaElement = (IJavaElement)parentElement;
                    int type = iJavaElement.getElementType();
                    switch (type) {
                        case 2: {
                            IPackageFragmentRoot root;
                            this.fMapToLogicalPackage.clear();
                            this.fMapToPackageFragments.clear();
                            IJavaProject project = (IJavaProject)parentElement;
                            IPackageFragment[] topLevelChildren = this.getTopLevelChildrenByElementName((IJavaElement[])project.getPackageFragments());
                            ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
                            int i = 0;
                            while (i < topLevelChildren.length) {
                                IPackageFragment fragment = topLevelChildren[i];
                                IJavaElement el = fragment.getParent();
                                if (!(!(el instanceof IPackageFragmentRoot) || (root = (IPackageFragmentRoot)el).isArchive() && root.isExternal())) {
                                    list.add(fragment);
                                }
                                ++i;
                            }
                            IPackageFragmentRoot[] packageFragmentRoots = project.getPackageFragmentRoots();
                            ArrayList<Object> folders = new ArrayList<Object>();
                            int i2 = 0;
                            while (i2 < packageFragmentRoots.length) {
                                root = packageFragmentRoots[i2];
                                IResource resource = root.getUnderlyingResource();
                                if (resource != null && resource instanceof IFolder) {
                                    folders.addAll(this.getFolders(((IFolder)resource).members()));
                                }
                                ++i2;
                            }
                            Object[] logicalPackages = this.combineSamePackagesIntoLogialPackages(list.toArray(new IPackageFragment[list.size()]));
                            if (folders.size() > 0) {
                                if (logicalPackages.length > 0) {
                                    folders.addAll(Arrays.asList(logicalPackages));
                                }
                                return folders.toArray();
                            }
                            return logicalPackages;
                        }
                        case 3: {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)parentElement;
                            this.fMapToLogicalPackage.clear();
                            this.fMapToPackageFragments.clear();
                            IResource resource = root.getUnderlyingResource();
                            if (root.isArchive()) {
                                Object[] fragments = new IPackageFragment[]{};
                                IJavaElement[] els = root.getChildren();
                                fragments = this.getTopLevelChildrenByElementName(els);
                                this.addFragmentsToMap((IPackageFragment[])fragments);
                                return fragments;
                            }
                            if (resource != null && resource instanceof IFolder) {
                                List children = this.getFoldersAndElements(((IFolder)resource).members());
                                IPackageFragment defaultPackage = root.getPackageFragment("");
                                if (defaultPackage.exists()) {
                                    children.add(defaultPackage);
                                }
                                this.addFragmentsToMap(children);
                                return children.toArray();
                            }
                            return NO_CHILDREN;
                        }
                        case 4: {
                            IPackageFragment packageFragment = (IPackageFragment)parentElement;
                            if (packageFragment.isDefaultPackage()) {
                                return NO_CHILDREN;
                            }
                            IResource resource = packageFragment.getUnderlyingResource();
                            if (resource != null && resource instanceof IFolder) {
                                List folders = this.getFoldersAndElements(((IFolder)resource).members());
                                this.addFragmentsToMap(folders);
                                return folders.toArray();
                            }
                            break block23;
                        }
                    }
                    break block23;
                }
                if (parentElement instanceof LogicalPackage) {
                    ArrayList<IPackageFragment> children = new ArrayList<IPackageFragment>();
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)parentElement);
                    IPackageFragment[] elements = logicalPackage.getFragments();
                    int i = 0;
                    while (i < elements.length) {
                        IPackageFragment fragment = elements[i];
                        IPackageFragment[] objects = this.findNextLevelChildrenByElementName((IPackageFragmentRoot)fragment.getParent(), fragment);
                        children.addAll(Arrays.asList(objects));
                        ++i;
                    }
                    return this.combineSamePackagesIntoLogialPackages(children.toArray(new IPackageFragment[children.size()]));
                }
                if (parentElement instanceof IFolder) {
                    IFolder folder = (IFolder)parentElement;
                    IResource[] resources = folder.members();
                    List children = this.getFoldersAndElements(resources);
                    this.addFragmentsToMap(children);
                    return children.toArray();
                }
            }
            catch (JavaModelException javaModelException) {
                return NO_CHILDREN;
            }
            catch (CoreException coreException) {
                return NO_CHILDREN;
            }
        }
        return NO_CHILDREN;
    }

    private void addFragmentsToMap(List elements) {
        ArrayList packageFragments = new ArrayList();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (!(elem instanceof IPackageFragment)) continue;
            packageFragments.add(elem);
        }
        this.addFragmentsToMap(packageFragments.toArray(new IPackageFragment[packageFragments.size()]));
    }

    private List getFoldersAndElements(IResource[] resources) throws CoreException {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IJavaElement element = JavaCore.create((IFolder)folder);
                if (element instanceof IPackageFragment) {
                    list.add(element);
                } else {
                    list.add(folder);
                }
            }
            ++i;
        }
        return list;
    }

    private List getFolders(IResource[] resources) throws CoreException {
        ArrayList<IFolder> list = new ArrayList<IFolder>();
        int i = 0;
        while (i < resources.length) {
            IFolder folder;
            IJavaElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = JavaCore.create((IFolder)(folder = (IFolder)resource))) == null) {
                list.add(folder);
            }
            ++i;
        }
        return list;
    }

    private IPackageFragment[] findNextLevelChildrenByElementName(IPackageFragmentRoot parent, IPackageFragment fragment) {
        ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
        try {
            IJavaElement[] children = parent.getChildren();
            String fragmentname = fragment.getElementName();
            int i = 0;
            while (i < children.length) {
                IJavaElement element = children[i];
                if (element instanceof IPackageFragment) {
                    String tail;
                    IPackageFragment frag = (IPackageFragment)element;
                    String name = element.getElementName();
                    if (name.length() > fragmentname.length() && name.charAt(fragmentname.length()) == '.' && frag.exists() && !"".equals(fragmentname) && name.startsWith(fragmentname) && !name.equals(fragmentname) && !"".equals(tail = name.substring(fragmentname.length() + 1)) && tail.indexOf(46) == -1) {
                        list.add(frag);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return list.toArray(new IPackageFragment[list.size()]);
    }

    private IPackageFragment[] getTopLevelChildrenByElementName(IJavaElement[] elements) {
        ArrayList<IJavaElement> topLevelElements = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < elements.length) {
            IJavaElement iJavaElement = elements[i];
            if (iJavaElement instanceof IPackageFragment && iJavaElement.getElementName().indexOf(46) == -1) {
                topLevelElements.add(iJavaElement);
            }
            ++i;
        }
        return topLevelElements.toArray(new IPackageFragment[topLevelElements.size()]);
    }

    public Object getParent(Object element) {
        try {
            if (element instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)element;
                if (!fragment.exists()) {
                    return null;
                }
                Object parent = this.getHierarchicalParent(fragment);
                if (parent instanceof IPackageFragment) {
                    IPackageFragment pkgFragment = (IPackageFragment)parent;
                    LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                    if (logicalPkg != null) {
                        return logicalPkg;
                    }
                    LogicalPackage lp = this.createLogicalPackage(pkgFragment);
                    if (lp == null) {
                        return pkgFragment;
                    }
                    return lp;
                }
                return parent;
            }
            if (element instanceof LogicalPackage) {
                LogicalPackage el = (LogicalPackage)((Object)element);
                IPackageFragment fragment = el.getFragments()[0];
                Object parent = this.getHierarchicalParent(fragment);
                if (parent instanceof IPackageFragment) {
                    IPackageFragment pkgFragment = (IPackageFragment)parent;
                    LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                    if (logicalPkg != null) {
                        return logicalPkg;
                    }
                    LogicalPackage lp = this.createLogicalPackage(pkgFragment);
                    if (lp == null) {
                        return pkgFragment;
                    }
                    return lp;
                }
                return fragment.getJavaProject();
            }
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                IContainer res = folder.getParent();
                IJavaElement el = JavaCore.create((IResource)res);
                if (el != null) {
                    return el;
                }
                return res;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private LogicalPackage createLogicalPackage(IPackageFragment pkgFragment) {
        if (!this.fInputIsProject) {
            return null;
        }
        ArrayList<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
        try {
            IPackageFragmentRoot[] roots = pkgFragment.getJavaProject().getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                IPackageFragment fragment = root.getPackageFragment(pkgFragment.getElementName());
                if (fragment.exists() && !fragment.equals(pkgFragment)) {
                    fragments.add(fragment);
                }
                ++i;
            }
            if (!fragments.isEmpty()) {
                LogicalPackage logicalPackage = new LogicalPackage(pkgFragment);
                this.fMapToLogicalPackage.put(this.getKey(pkgFragment), logicalPackage);
                Iterator iter = fragments.iterator();
                while (iter.hasNext()) {
                    IPackageFragment f = (IPackageFragment)iter.next();
                    if (!logicalPackage.belongs(f)) continue;
                    logicalPackage.add(f);
                    this.fMapToLogicalPackage.put(this.getKey(f), logicalPackage);
                }
                return logicalPackage;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private Object getHierarchicalParent(IPackageFragment fragment) throws JavaModelException {
        IJavaElement parent = fragment.getParent();
        if (parent instanceof IPackageFragmentRoot && parent.exists()) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
            if (root.isArchive() || !fragment.exists()) {
                return this.findNextLevelParentByElementName(fragment);
            }
            IResource resource = fragment.getUnderlyingResource();
            if (resource != null && resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IContainer res = folder.getParent();
                IJavaElement el = JavaCore.create((IResource)res);
                if (el != null) {
                    return el;
                }
                return res;
            }
        }
        return parent;
    }

    private Object findNextLevelParentByElementName(IPackageFragment child) {
        String name = child.getElementName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IPackageFragment element = ((IPackageFragmentRoot)child.getParent()).getPackageFragment(realParentName);
            if (element.exists()) {
                return element;
            }
        }
        return child.getParent();
    }

    public boolean hasChildren(Object element) {
        IPackageFragment fragment;
        if (element instanceof IPackageFragment && ((fragment = (IPackageFragment)element).isDefaultPackage() || !fragment.exists())) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected void processDelta(IJavaElementDelta delta) throws JavaModelException {
        Object input;
        int kind = delta.getKind();
        IJavaElement element = delta.getElement();
        if (this.isClassPathChange(delta) && (input = this.fViewer.getInput()) != null) {
            if (this.fInputIsProject && input.equals(element.getJavaProject())) {
                this.postRefresh(input);
                return;
            }
            if (!this.fInputIsProject && input.equals(element)) {
                if (element.exists()) {
                    this.postRefresh(input);
                } else {
                    this.postRemove(input);
                }
                return;
            }
        }
        if (kind == 2 && (input = this.fViewer.getInput()) != null && input.equals(element)) {
            this.postRemove(input);
            return;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment frag = (IPackageFragment)element;
            if (kind == 2) {
                this.removeElement(frag);
                return;
            }
            if (kind == 1) {
                Object parent = this.getParent(frag);
                this.addElement(frag, parent);
                return;
            }
            if (kind == 4) {
                LogicalPackage logicalPkg = this.findLogicalPackage(frag);
                if (logicalPkg != null) {
                    this.postRefresh(this.findElementToRefresh((Object)logicalPkg));
                } else {
                    this.postRefresh(this.findElementToRefresh(frag));
                }
                return;
            }
        }
        this.processAffectedChildren(delta);
    }

    private Object findElementToRefresh(Object object) {
        Object toBeRefreshed = object;
        if (this.fViewer.testFindItem(object) == null) {
            Object parent = this.getParent(object);
            if (parent instanceof IPackageFragmentRoot && this.fInputIsProject) {
                parent = ((IPackageFragmentRoot)parent).getJavaProject();
            }
            if (parent != null) {
                toBeRefreshed = parent;
            }
        }
        return toBeRefreshed;
    }

    private void processAffectedChildren(IJavaElementDelta delta) throws JavaModelException {
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            if (!(affectedChildren[i] instanceof ICompilationUnit)) {
                this.processDelta(affectedChildren[i]);
            }
            ++i;
        }
    }

    private void postAdd(final Object child, final Object parent) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).add(parent, child);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).remove(object);
                }
            }
        });
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).refresh(object);
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    private void addElement(IPackageFragment frag, Object parent) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null && lp.belongs(frag)) {
            lp.add(frag);
            return;
        }
        IPackageFragment iPackageFragment = (IPackageFragment)this.fMapToPackageFragments.get(key);
        if (iPackageFragment != null && !iPackageFragment.equals(frag)) {
            lp = new LogicalPackage(iPackageFragment);
            lp.add(frag);
            this.fMapToLogicalPackage.put(key, lp);
            if (parent instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                if (this.fInputIsProject) {
                    this.postRefresh(root.getJavaProject());
                } else {
                    this.postRefresh(root);
                }
            } else {
                this.postAdd((Object)lp, parent);
                this.postRemove(iPackageFragment);
            }
        } else {
            this.fMapToPackageFragments.put(key, frag);
            if (parent instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                if (this.fInputIsProject) {
                    this.postAdd(frag, root.getJavaProject());
                } else {
                    this.postAdd(frag, root);
                }
            } else {
                this.postAdd(frag, parent);
            }
        }
    }

    private void removeElement(IPackageFragment frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null) {
            lp.remove(frag);
            if (lp.getFragments().length == 1) {
                IPackageFragment fragment = lp.getFragments()[0];
                this.fMapToPackageFragments.put(key, fragment);
                this.fMapToLogicalPackage.remove(key);
                this.postRemove((Object)lp);
                Object parent = this.getParent(fragment);
                if (parent instanceof IPackageFragmentRoot) {
                    parent = ((IPackageFragmentRoot)parent).getJavaProject();
                }
                this.postAdd(fragment, parent);
            }
        } else {
            IPackageFragment fragment = (IPackageFragment)this.fMapToPackageFragments.get(key);
            if (fragment != null && fragment.equals(frag)) {
                this.fMapToPackageFragments.remove(key);
                this.postRemove(frag);
            }
        }
    }
}

