/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

abstract class JavaHistoryActionImpl {
    private boolean fModifiesFile;
    private ISelection fSelection;
    private JavaEditor fEditor;
    private String fTitle;
    private String fMessage;

    JavaHistoryActionImpl(boolean modifiesFile) {
        this.fModifiesFile = modifiesFile;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    final IFile getFile(Object input) {
        ICompilationUnit cu = null;
        if (input instanceof ICompilationUnit) {
            cu = (ICompilationUnit)input;
        } else if (input instanceof IMember) {
            cu = ((IMember)input).getCompilationUnit();
        }
        if (cu == null || !cu.exists()) {
            return null;
        }
        IFile file = (IFile)(cu = JavaModelUtil.toOriginal(cu)).getResource();
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    final ITypedElement[] buildEditions(ITypedElement target, IFile file) {
        IFileState[] states = null;
        try {
            states = file.getHistory(null);
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex);
        }
        int count = 1;
        if (states != null) {
            count += states.length;
        }
        ITypedElement[] editions = new ITypedElement[count];
        editions[0] = new ResourceNode((IResource)file);
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem(target, states[i]);
                ++i;
            }
        }
        return editions;
    }

    final Shell getShell() {
        if (this.fEditor != null) {
            return this.fEditor.getEditorSite().getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    final IJavaElement getWorkingCopy(IJavaElement input) {
        return input;
    }

    final ASTNode getBodyContainer(CompilationUnit root, IMember parent) throws JavaModelException {
        ISourceRange sourceRange = parent.getNameRange();
        ASTNode parentNode = NodeFinder.perform((ASTNode)root, sourceRange);
        do {
            if (!(parentNode instanceof TypeDeclaration) && !(parentNode instanceof EnumDeclaration) && !(parentNode instanceof AnnotationTypeDeclaration)) continue;
            return parentNode;
        } while ((parentNode = parentNode.getParent()) != null);
        return null;
    }

    final boolean beingEdited(IFile file) {
        FileEditorInput input;
        ICompilationUnitDocumentProvider dp = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        return dp.getDocument(input = new FileEditorInput(file)) != null;
    }

    final IMember getEditionElement(ISelection selection) {
        IMember m;
        Object o;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof IMember && (m = (IMember)o).exists() && !m.isBinary() && JavaStructureCreator.hasEdition((IJavaElement)m)) {
            return m;
        }
        return null;
    }

    final boolean isEnabled(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (this.fModifiesFile) {
            return true;
        }
        return true;
    }

    boolean isEnabled(ISelection selection) {
        IMember m = this.getEditionElement(selection);
        if (m == null) {
            return false;
        }
        IFile file = this.getFile(m);
        return this.isEnabled(file);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void applyChanges(ASTRewrite rewriter, IDocument document, final ITextFileBuffer textFileBuffer, Shell shell, boolean inEditor, Map options) throws CoreException, InvocationTargetException, InterruptedException {
        block9: {
            MultiTextEdit edit = new MultiTextEdit();
            try {
                TextEdit res = rewriter.rewriteAST(document, options);
                edit.addChildren(res.removeChildren());
            }
            catch (IllegalArgumentException e) {
                JavaPlugin.log(e);
            }
            DocumentRewriteSession session = null;
            try {
                try {
                    if (document instanceof IDocumentExtension4) {
                        session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                    }
                    edit.apply(document, 2);
                }
                catch (BadLocationException e) {
                    JavaPlugin.log(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (session == null) throw throwable;
                ((IDocumentExtension4)document).stopRewriteSession(session);
                throw throwable;
            }
            {
                Object var10_14 = null;
                if (session == null) break block9;
            }
            ((IDocumentExtension4)document).stopRewriteSession(session);
        }
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    textFileBuffer.commit(pm, false);
                }
                catch (CoreException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        if (inEditor) {
            r.run((IProgressMonitor)new NullProgressMonitor());
            return;
        }
        PlatformUI.getWorkbench().getProgressService().run(true, false, r);
    }

    static String trimTextBlock(String content, String delimiter, IJavaProject currentProject) {
        String[] lines;
        if (content != null && (lines = Strings.convertIntoLines(content)) != null) {
            Strings.trimIndentation(lines, currentProject);
            return Strings.concatenate(lines, delimiter);
        }
        return null;
    }

    final JavaEditor getEditor(IFile file) {
        FileEditorInput fei = new FileEditorInput(file);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    JavaEditor je;
                    IEditorPart ep = editors[z];
                    if (ep instanceof JavaEditor && fei.equals((Object)(je = (JavaEditor)ep).getEditorInput())) {
                        return (JavaEditor)ep;
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return null;
    }

    public abstract void run(ISelection var1);

    void init(JavaEditor editor, String title, String message) {
        this.fEditor = editor;
        this.fTitle = title;
        this.fMessage = message;
    }

    final JavaEditor getEditor() {
        return this.fEditor;
    }

    public final void runFromEditor(IAction uiProxy) {
        IJavaElement element = null;
        try {
            element = SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {}
        this.fSelection = element != null ? new StructuredSelection((Object)element) : StructuredSelection.EMPTY;
        boolean isEnabled = this.isEnabled(this.fSelection);
        uiProxy.setEnabled(isEnabled);
        if (!isEnabled) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.fTitle, (String)this.fMessage);
            return;
        }
        this.run(this.fSelection);
    }

    boolean checkEnabled() {
        ICompilationUnit unit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IFile file = this.getFile(unit);
        return this.isEnabled(file);
    }

    public final void update(IAction uiProxy) {
        uiProxy.setEnabled(this.checkEnabled());
    }

    public final void selectionChanged(IAction uiProxy, ISelection selection) {
        this.fSelection = selection;
        uiProxy.setEnabled(this.isEnabled(selection));
    }

    public final void run(IAction action) {
        this.run(this.fSelection);
    }

    static CompilationUnit parsePartialCompilationUnit(ICompilationUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        try {
            ASTParser c = ASTParser.newParser((int)3);
            c.setSource(unit);
            c.setFocalPosition(0);
            c.setResolveBindings(false);
            c.setWorkingCopyOwner(null);
            ASTNode result = c.createAST(null);
            return (CompilationUnit)result;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException();
        }
    }
}

