/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.infoviews.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.infoviews.GotoInputAction;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener {
    private static final long TITLE_LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED;
    private static final long TOOLTIP_LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected IJavaElement fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    static /* synthetic */ Class class$0;

    AbstractInfoView() {
    }

    protected abstract void setInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.setInfoColor();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
        menu.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected IJavaElement getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fGotoInputAction);
    }

    private void setInfoColor() {
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        this.setBackground(display.getSystemColor(29));
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        this.computeAndSetInput(part);
    }

    protected boolean isIgnoringEqualInput() {
        return true;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        Object element;
        try {
            if (part instanceof JavaEditor && selection instanceof ITextSelection) {
                IJavaElement[] elements = TextSelectionConverter.codeResolve((JavaEditor)part, (ITextSelection)selection);
                if (elements != null && elements.length > 0) {
                    return elements[0];
                }
                return null;
            }
            if (!(selection instanceof IStructuredSelection)) {
                return null;
            }
            element = SelectionUtil.getSingleElement(selection);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return this.findJavaElement(element);
    }

    private IJavaElement findJavaElement(Object element) {
        if (element == null) {
            return null;
        }
        IJavaElement je = null;
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            je = (IJavaElement)iAdaptable.getAdapter((Class)clazz);
        }
        return je;
    }

    protected IType getTypeForCU(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        this.internalDispose();
    }

    protected void internalDispose() {
    }

    private void computeAndSetInput(final IWorkbenchPart part) {
        final int currentCount = ++this.fComputeCount;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider == null) {
            return;
        }
        final ISelection selection = provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Thread thread = new Thread("Info view input computer"){

            public void run() {
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                IJavaElement je = AbstractInfoView.this.findSelectedJavaElement(part, selection);
                if (AbstractInfoView.this.isIgnoringEqualInput() && AbstractInfoView.this.fCurrentViewInput != null && AbstractInfoView.this.fCurrentViewInput.equals(je)) {
                    return;
                }
                Object input = AbstractInfoView.this.computeInput(je);
                if (input == null) {
                    return;
                }
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(this, currentCount, je, input){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ int val$currentCount;
                    private final /* synthetic */ IJavaElement val$je;
                    private final /* synthetic */ Object val$input;
                    {
                        this.this$1 = var1_1;
                        this.val$currentCount = n;
                        this.val$je = iJavaElement;
                        this.val$input = object;
                    }

                    public void run() {
                        if (AbstractInfoView.access$1(2.access$0(this.this$1)) != this.val$currentCount || 2.access$0(this.this$1).getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        2.access$0(this.this$1).fCurrentViewInput = this.val$je;
                        AbstractInfoView.access$2(2.access$0(this.this$1), this.val$input);
                    }
                });
            }

            static /* synthetic */ AbstractInfoView access$0(2 var0) {
                return var0.AbstractInfoView.this;
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private void doSetInput(Object input) {
        this.setInput(input);
        this.fGotoInputAction.setEnabled(true);
        this.setContentDescription(JavaElementLabels.getElementLabel(this.fCurrentViewInput, TITLE_LABEL_FLAGS));
        this.setTitleToolTip(JavaElementLabels.getElementLabel(this.fCurrentViewInput, TOOLTIP_LABEL_FLAGS));
    }

    static /* synthetic */ void access$2(AbstractInfoView abstractInfoView, Object object) {
        abstractInfoView.doSetInput(object);
    }
}

