/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocReader;
import org.eclipse.jdt.internal.ui.javadocexport.RecentSettingsStore;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavadocOptionsManager {
    private IFile fXmlfile;
    private StatusInfo fWizardStatus;
    private String[] fJavadocCommandHistory;
    private IJavaElement[] fSelectedElements;
    private IJavaElement[] fInitialElements;
    private String fAccess;
    private String fDocletpath;
    private String fDocletname;
    private boolean fFromStandard;
    private String fStylesheet;
    private String fAdditionalParams;
    private String fVMParams;
    private String fOverview;
    private String fTitle;
    private String[] fHRefs;
    private IPath[] fSourcepath;
    private IPath[] fClasspath;
    private boolean fNotree;
    private boolean fNoindex;
    private boolean fSplitindex;
    private boolean fNonavbar;
    private boolean fNodeprecated;
    private boolean fNoDeprecatedlist;
    private boolean fAuthor;
    private boolean fVersion;
    private boolean fUse;
    private String fSource;
    private boolean fOpenInBrowser;
    private RecentSettingsStore fRecentSettings;
    private String fDestination;
    private String fAntpath;
    public final String PRIVATE = "private";
    public final String PROTECTED = "protected";
    public final String PACKAGE = "package";
    public final String PUBLIC = "public";
    public final String USE = "use";
    public final String NOTREE = "notree";
    public final String NOINDEX = "noindex";
    public final String NONAVBAR = "nonavbar";
    public final String NODEPRECATED = "nodeprecated";
    public final String NODEPRECATEDLIST = "nodeprecatedlist";
    public final String VERSION = "version";
    public final String AUTHOR = "author";
    public final String SPLITINDEX = "splitindex";
    public final String STYLESHEETFILE = "stylesheetfile";
    public final String OVERVIEW = "overview";
    public final String DOCLETNAME = "docletname";
    public final String DOCLETPATH = "docletpath";
    public final String SOURCEPATH = "sourcepath";
    public final String CLASSPATH = "classpath";
    public final String DESTINATION = "destdir";
    public final String OPENINBROWSER = "openinbrowser";
    public final String VISIBILITY = "access";
    public final String PACKAGENAMES = "packagenames";
    public final String SOURCEFILES = "sourcefiles";
    public final String EXTRAOPTIONS = "additionalparam";
    public final String VMOPTIONS = "vmparam";
    public final String TITLE = "doctitle";
    public final String HREF = "href";
    public final String NAME = "name";
    public final String PATH = "path";
    public final String FROMSTANDARD = "fromStandard";
    public final String ANTPATH = "antpath";
    public final String SOURCE = "source";
    private final String SECTION_JAVADOC = "javadoc";
    private static final String JAVADOC_COMMAND_HISTORY = "javadoc_command_history";
    static /* synthetic */ Class class$0;

    public JavadocOptionsManager(IFile xmlJavadocFile, IDialogSettings dialogSettings, List currSelection) {
        this.fXmlfile = xmlJavadocFile;
        this.fWizardStatus = new StatusInfo();
        IDialogSettings javadocSection = dialogSettings.getSection("javadoc");
        String commandHistory = null;
        if (javadocSection != null) {
            commandHistory = javadocSection.get(JAVADOC_COMMAND_HISTORY);
        }
        if (commandHistory == null || commandHistory.length() == 0) {
            commandHistory = JavadocOptionsManager.initJavadocCommandDefault();
        }
        this.fJavadocCommandHistory = this.arrayFromFlatString(commandHistory);
        this.fRecentSettings = new RecentSettingsStore(javadocSection);
        if (xmlJavadocFile != null) {
            try {
                JavadocReader reader = new JavadocReader(xmlJavadocFile.getContents());
                Element element = reader.readXML();
                if (element != null) {
                    this.loadFromXML(element);
                    return;
                }
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectCE_warning);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectCE_warning);
            }
            catch (IOException e) {
                JavaPlugin.log(e);
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectIOE_warning);
            }
            catch (SAXException sAXException) {
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectSAXE_warning);
            }
        }
        if (javadocSection != null) {
            this.loadFromDialogStore(javadocSection, currSelection);
        } else {
            this.loadDefaults(currSelection);
        }
    }

    private IJavaProject getSingleProjectFromInitialSelection() {
        IJavaProject res = null;
        int i = 0;
        while (i < this.fInitialElements.length) {
            IJavaProject curr = this.fInitialElements[i].getJavaProject();
            if (res == null) {
                res = curr;
            } else if (!res.equals(curr)) {
                return null;
            }
            ++i;
        }
        if (res != null && res.isOpen()) {
            return res;
        }
        return null;
    }

    private void loadFromDialogStore(IDialogSettings settings, List sel) {
        this.fInitialElements = this.getInitialElementsFromSelection(sel);
        IJavaProject project = this.getSingleProjectFromInitialSelection();
        this.fAccess = settings.get("access");
        if (this.fAccess == null) {
            this.fAccess = "protected";
        }
        this.fFromStandard = settings.getBoolean("fromStandard");
        this.fDocletpath = settings.get("docletpath");
        this.fDocletname = settings.get("docletname");
        if (this.fDocletpath == null || this.fDocletname == null) {
            this.fFromStandard = true;
            this.fDocletpath = "";
            this.fDocletname = "";
        }
        if (project != null) {
            this.fAntpath = this.getRecentSettings().getAntpath(project);
        } else {
            this.fAntpath = settings.get("antpath");
            if (this.fAntpath == null) {
                this.fAntpath = "";
            }
        }
        if (project != null) {
            this.fDestination = this.getRecentSettings().getDestination(project);
        } else {
            this.fDestination = settings.get("destdir");
            if (this.fDestination == null) {
                this.fDestination = "";
            }
        }
        this.fTitle = settings.get("doctitle");
        if (this.fTitle == null) {
            this.fTitle = "";
        }
        this.fStylesheet = settings.get("stylesheetfile");
        if (this.fStylesheet == null) {
            this.fStylesheet = "";
        }
        this.fVMParams = settings.get("vmparam");
        if (this.fVMParams == null) {
            this.fVMParams = "";
        }
        this.fAdditionalParams = settings.get("additionalparam");
        if (this.fAdditionalParams == null) {
            this.fAdditionalParams = "";
        }
        this.fOverview = settings.get("overview");
        if (this.fOverview == null) {
            this.fOverview = "";
        }
        this.fUse = this.loadBoolean(settings.get("use"));
        this.fAuthor = this.loadBoolean(settings.get("author"));
        this.fVersion = this.loadBoolean(settings.get("version"));
        this.fNodeprecated = this.loadBoolean(settings.get("nodeprecated"));
        this.fNoDeprecatedlist = this.loadBoolean(settings.get("nodeprecatedlist"));
        this.fNonavbar = this.loadBoolean(settings.get("nonavbar"));
        this.fNoindex = this.loadBoolean(settings.get("noindex"));
        this.fNotree = this.loadBoolean(settings.get("notree"));
        this.fSplitindex = this.loadBoolean(settings.get("splitindex"));
        this.fOpenInBrowser = this.loadBoolean(settings.get("openinbrowser"));
        this.fSource = settings.get("source");
        if (project != null) {
            this.fSource = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        }
        this.fHRefs = project != null ? this.getRecentSettings().getHRefs(project) : new String[0];
    }

    private void loadDefaults(List sel) {
        this.fInitialElements = this.getInitialElementsFromSelection(sel);
        IJavaProject project = this.getSingleProjectFromInitialSelection();
        if (project != null) {
            this.fAntpath = this.getRecentSettings().getAntpath(project);
            this.fDestination = this.getRecentSettings().getDestination(project);
            this.fHRefs = this.getRecentSettings().getHRefs(project);
        } else {
            this.fAntpath = "";
            this.fDestination = "";
            this.fHRefs = new String[0];
        }
        this.fAccess = "public";
        this.fDocletname = "";
        this.fDocletpath = "";
        this.fTitle = "";
        this.fStylesheet = "";
        this.fVMParams = "";
        this.fAdditionalParams = "";
        this.fOverview = "";
        this.fUse = true;
        this.fAuthor = true;
        this.fVersion = true;
        this.fNodeprecated = false;
        this.fNoDeprecatedlist = false;
        this.fNonavbar = false;
        this.fNoindex = false;
        this.fNotree = false;
        this.fSplitindex = true;
        this.fOpenInBrowser = false;
        this.fSource = "1.3";
        if (project != null) {
            this.fSource = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        }
        this.fFromStandard = true;
    }

    private void loadFromXML(Element element) {
        Node child;
        int i;
        this.fAccess = element.getAttribute("access");
        if (this.fAccess.length() == 0) {
            this.fAccess = "protected";
        }
        String destination = element.getAttribute("destdir");
        this.fDestination = this.makeAbsolutePathFromRelative((IPath)new Path(destination)).toOSString();
        this.fFromStandard = true;
        this.fDocletname = "";
        this.fDocletpath = "";
        if (destination.length() == 0) {
            NodeList list = element.getChildNodes();
            i = 0;
            while (i < list.getLength()) {
                child = list.item(i);
                if (child.getNodeName().equals("doclet")) {
                    this.fDocletpath = ((Element)child).getAttribute("path");
                    this.fDocletname = ((Element)child).getAttribute("name");
                    if (this.fDocletpath.length() != 0 || this.fDocletname.length() != 0) {
                        this.fFromStandard = false;
                        break;
                    }
                    this.fDocletname = "";
                    this.fDocletpath = "";
                    break;
                }
                ++i;
            }
        }
        this.fInitialElements = this.getSelectedElementsFromAnt(element);
        NodeList children = element.getChildNodes();
        this.fHRefs = new String[children.getLength()];
        i = 0;
        while (i < this.fHRefs.length) {
            child = children.item(i);
            if (child.getNodeName().equals("link")) {
                this.fHRefs[i] = ((Element)child).getAttribute("href");
            }
            ++i;
        }
        IPath p = this.fXmlfile.getLocation();
        this.fAntpath = p != null ? p.toOSString() : "";
        this.fStylesheet = element.getAttribute("stylesheetfile");
        this.fTitle = element.getAttribute("doctitle");
        StringBuffer additionals = new StringBuffer();
        StringBuffer vmargs = new StringBuffer();
        String extraOptions = element.getAttribute("additionalparam");
        if (extraOptions.length() > 0) {
            ExecutionArguments tokens = new ExecutionArguments("", extraOptions);
            String[] args = tokens.getProgramArgumentsArray();
            boolean vmarg = false;
            int i2 = 0;
            while (i2 < args.length) {
                String curr = args[i2];
                if (curr.length() > 0 && curr.charAt(0) == '-') {
                    boolean bl = vmarg = curr.length() > 1 && curr.charAt(1) == 'J';
                }
                if (vmarg) {
                    vmargs.append(curr).append(' ');
                } else {
                    additionals.append(curr).append(' ');
                }
                ++i2;
            }
        }
        this.fAdditionalParams = additionals.toString();
        this.fVMParams = vmargs.toString();
        this.fOverview = element.getAttribute("overview");
        this.fUse = this.loadBoolean(element.getAttribute("use"));
        this.fAuthor = this.loadBoolean(element.getAttribute("author"));
        this.fVersion = this.loadBoolean(element.getAttribute("version"));
        this.fNodeprecated = this.loadBoolean(element.getAttribute("nodeprecated"));
        this.fNoDeprecatedlist = this.loadBoolean(element.getAttribute("nodeprecatedlist"));
        this.fNonavbar = this.loadBoolean(element.getAttribute("nonavbar"));
        this.fNoindex = this.loadBoolean(element.getAttribute("noindex"));
        this.fNotree = this.loadBoolean(element.getAttribute("notree"));
        this.fSplitindex = this.loadBoolean(element.getAttribute("splitindex"));
        this.fSource = element.getAttribute("source");
    }

    private IPath makeAbsolutePathFromRelative(IPath path) {
        if (!path.isAbsolute()) {
            if (this.fXmlfile == null) {
                return null;
            }
            IPath basePath = this.fXmlfile.getParent().getLocation();
            if (basePath == null) {
                return null;
            }
            return basePath.append(path);
        }
        return path;
    }

    private IContainer[] getSourceContainers(Element element) {
        String sourcePaths = element.getAttribute("sourcepath");
        StringTokenizer tokenizer = new StringTokenizer(sourcePaths, String.valueOf(File.pathSeparatorChar));
        ArrayList<IContainer> res = new ArrayList<IContainer>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (tokenizer.hasMoreTokens()) {
            IPath path = this.makeAbsolutePathFromRelative((IPath)new Path(tokenizer.nextToken().trim()));
            if (path == null) continue;
            IContainer[] containers = root.findContainersForLocation(path);
            int i = 0;
            while (i < containers.length) {
                res.add(containers[i]);
                ++i;
            }
        }
        return res.toArray(new IContainer[res.size()]);
    }

    private IJavaElement[] getSelectedElementsFromAnt(Element element) {
        String sourcefiles;
        ArrayList<Object> res = new ArrayList<Object>();
        String packagenames = element.getAttribute("packagenames");
        if (packagenames != null) {
            IContainer[] containers = this.getSourceContainers(element);
            StringTokenizer tokenizer = new StringTokenizer(packagenames, ",");
            while (tokenizer.hasMoreTokens()) {
                Path relPackagePath = new Path(tokenizer.nextToken().trim().replace('.', '/'));
                int i = 0;
                while (i < containers.length) {
                    IJavaElement javaElem;
                    IContainer curr = containers[i];
                    IResource resource = curr.findMember((IPath)relPackagePath);
                    if (resource != null && (javaElem = JavaCore.create((IResource)resource)) instanceof IPackageFragment) {
                        res.add(javaElem);
                    }
                    ++i;
                }
            }
        }
        if ((sourcefiles = element.getAttribute("sourcefiles")) != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            StringTokenizer tokenizer = new StringTokenizer(sourcefiles, ",");
            while (tokenizer.hasMoreTokens()) {
                IPath path;
                String name = tokenizer.nextToken().trim();
                if (!JavaCore.isJavaLikeFileName((String)name) || (path = this.makeAbsolutePathFromRelative((IPath)new Path(name))) == null) continue;
                IFile[] files = root.findFilesForLocation(path);
                int i = 0;
                while (i < files.length) {
                    ICompilationUnit el = JavaCore.createCompilationUnitFrom((IFile)files[i]);
                    if (el != null) {
                        res.add(el);
                    }
                    ++i;
                }
            }
        }
        return res.toArray(new IJavaElement[res.size()]);
    }

    public String[] getJavadocCommandHistory() {
        return this.fJavadocCommandHistory;
    }

    public StatusInfo getWizardStatus() {
        return this.fWizardStatus;
    }

    public IJavaElement[] getInitialElements() {
        return this.fInitialElements;
    }

    public IJavaElement[] getSourceElements() {
        return this.fSelectedElements;
    }

    public String getAccess() {
        return this.fAccess;
    }

    public String getAntpath() {
        return this.fAntpath;
    }

    public boolean isFromStandard() {
        return this.fFromStandard;
    }

    public String getDestination() {
        return this.fDestination;
    }

    public String getDocletPath() {
        return this.fDocletpath;
    }

    public String getDocletName() {
        return this.fDocletname;
    }

    public String getStyleSheet() {
        return this.fStylesheet;
    }

    public String getOverview() {
        return this.fOverview;
    }

    public String getAdditionalParams() {
        return this.fAdditionalParams;
    }

    public String getVMParams() {
        return this.fVMParams;
    }

    public IPath[] getClasspath() {
        return this.fClasspath;
    }

    public IPath[] getSourcepath() {
        return this.fSourcepath;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public boolean doOpenInBrowser() {
        return this.fOpenInBrowser;
    }

    public String[] getHRefs() {
        return this.fHRefs;
    }

    public boolean getBoolean(String flag) {
        if (flag.equals("author")) {
            return this.fAuthor;
        }
        if (flag.equals("version")) {
            return this.fVersion;
        }
        if (flag.equals("use")) {
            return this.fUse;
        }
        if (flag.equals("nodeprecated")) {
            return this.fNodeprecated;
        }
        if (flag.equals("nodeprecatedlist")) {
            return this.fNoDeprecatedlist;
        }
        if (flag.equals("noindex")) {
            return this.fNoindex;
        }
        if (flag.equals("notree")) {
            return this.fNotree;
        }
        if (flag.equals("splitindex")) {
            return this.fSplitindex;
        }
        if (flag.equals("nonavbar")) {
            return this.fNonavbar;
        }
        return false;
    }

    private boolean loadBoolean(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.equals("true");
    }

    private String flatPathList(IPath[] paths) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (i > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(paths[i].toOSString());
            ++i;
        }
        return buf.toString();
    }

    private String flatStringList(String[] paths) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (i > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(paths[i]);
            ++i;
        }
        return buf.toString();
    }

    private String[] arrayFromFlatString(String str) {
        StringTokenizer tok = new StringTokenizer(str, File.pathSeparator);
        String[] res = new String[tok.countTokens()];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken();
            ++i;
        }
        return res;
    }

    public IStatus getArgumentArray(List vmArgs, List toolArgs) {
        MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, JavadocExportMessages.JavadocOptionsManager_status_title, null);
        vmArgs.add(this.getJavadocCommandHistory()[0]);
        if (this.fFromStandard) {
            toolArgs.add("-d");
            toolArgs.add(this.fDestination);
        } else {
            toolArgs.add("-doclet");
            toolArgs.add(this.fDocletname);
            toolArgs.add("-docletpath");
            toolArgs.add(this.fDocletpath);
        }
        if (this.fSourcepath.length > 0) {
            toolArgs.add("-sourcepath");
            toolArgs.add(this.flatPathList(this.fSourcepath));
        }
        if (this.fClasspath.length > 0) {
            toolArgs.add("-classpath");
            toolArgs.add(this.flatPathList(this.fClasspath));
        }
        toolArgs.add("-" + this.fAccess);
        if (this.fFromStandard) {
            if (this.fSource.length() > 0 && !this.fSource.equals("-")) {
                toolArgs.add("-source");
                toolArgs.add(this.fSource);
            }
            if (this.fUse) {
                toolArgs.add("-use");
            }
            if (this.fVersion) {
                toolArgs.add("-version");
            }
            if (this.fAuthor) {
                toolArgs.add("-author");
            }
            if (this.fNonavbar) {
                toolArgs.add("-nonavbar");
            }
            if (this.fNoindex) {
                toolArgs.add("-noindex");
            }
            if (this.fNotree) {
                toolArgs.add("-notree");
            }
            if (this.fNodeprecated) {
                toolArgs.add("-nodeprecated");
            }
            if (this.fNoDeprecatedlist) {
                toolArgs.add("-nodeprecatedlist");
            }
            if (this.fSplitindex) {
                toolArgs.add("-splitindex");
            }
            if (this.fTitle.length() != 0) {
                toolArgs.add("-doctitle");
                toolArgs.add(this.fTitle);
            }
            if (this.fStylesheet.length() != 0) {
                toolArgs.add("-stylesheetfile");
                toolArgs.add(this.fStylesheet);
            }
            int i = 0;
            while (i < this.fHRefs.length) {
                toolArgs.add("-link");
                toolArgs.add(this.fHRefs[i]);
                ++i;
            }
        }
        if (this.fAdditionalParams.length() + this.fVMParams.length() != 0) {
            ExecutionArguments tokens = new ExecutionArguments(this.fVMParams, this.fAdditionalParams);
            String[] vmArgsArray = tokens.getVMArgumentsArray();
            int i = 0;
            while (i < vmArgsArray.length) {
                vmArgs.add(vmArgsArray[i]);
                ++i;
            }
            String[] argsArray = tokens.getProgramArgumentsArray();
            int i2 = 0;
            while (i2 < argsArray.length) {
                toolArgs.add(argsArray[i2]);
                ++i2;
            }
        }
        this.addProxyOptions(vmArgs);
        if (this.fOverview.length() != 0) {
            toolArgs.add("-overview");
            toolArgs.add(this.fOverview);
        }
        int i = 0;
        while (i < this.fSelectedElements.length) {
            IJavaElement curr = this.fSelectedElements[i];
            if (curr instanceof IPackageFragment) {
                toolArgs.add(curr.getElementName());
            } else if (curr instanceof ICompilationUnit) {
                IPath p = curr.getResource().getLocation();
                if (p != null) {
                    toolArgs.add(p.toOSString());
                } else {
                    String message = JavadocExportMessages.JavadocOptionsManager_status_non_local;
                    status.add((IStatus)new StatusInfo(2, Messages.format(message, curr.getPath().makeRelative().toString())));
                }
            }
            ++i;
        }
        return status;
    }

    private void addProxyOptions(List vmOptions) {
        String proxyPort;
        String hostPrefix = "-J-Dhttp.proxyHost=";
        String portPrefix = "-J-Dhttp.proxyPort=";
        int i = 0;
        while (i < vmOptions.size()) {
            String curr = (String)vmOptions.get(i);
            if (curr.startsWith(hostPrefix) || curr.startsWith(portPrefix)) {
                return;
            }
            ++i;
        }
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            vmOptions.add(String.valueOf(hostPrefix) + proxyHost);
        }
        if ((proxyPort = System.getProperty("http.proxyPort")) != null) {
            vmOptions.add(String.valueOf(portPrefix) + proxyPort);
        }
    }

    /*
     * Exception decompiling
     */
    public File createXML(IJavaProject[] projects) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 216->219)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateDialogSettings(IDialogSettings dialogSettings, IJavaProject[] checkedProjects) {
        IDialogSettings settings = dialogSettings.addNewSection("javadoc");
        settings.put(JAVADOC_COMMAND_HISTORY, this.flatStringList(this.fJavadocCommandHistory));
        if (this.fJavadocCommandHistory.length > 0) {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            store.setValue("command", this.fJavadocCommandHistory[0]);
        }
        settings.put("fromStandard", this.fFromStandard);
        settings.put("docletname", this.fDocletname);
        settings.put("docletpath", this.fDocletpath);
        settings.put("access", this.fAccess);
        settings.put("use", this.fUse);
        settings.put("author", this.fAuthor);
        settings.put("version", this.fVersion);
        settings.put("nodeprecated", this.fNodeprecated);
        settings.put("nodeprecatedlist", this.fNoDeprecatedlist);
        settings.put("splitindex", this.fSplitindex);
        settings.put("noindex", this.fNoindex);
        settings.put("notree", this.fNotree);
        settings.put("nonavbar", this.fNonavbar);
        settings.put("openinbrowser", this.fOpenInBrowser);
        settings.put("source", this.fSource);
        if (this.fAntpath.length() != 0) {
            settings.put("antpath", this.fAntpath);
        }
        if (this.fDestination.length() != 0) {
            settings.put("destdir", this.fDestination);
        }
        if (this.fAdditionalParams.length() != 0) {
            settings.put("additionalparam", this.fAdditionalParams);
        }
        if (this.fVMParams.length() != 0) {
            settings.put("vmparam", this.fVMParams);
        }
        if (this.fOverview.length() != 0) {
            settings.put("overview", this.fOverview);
        }
        if (this.fStylesheet.length() != 0) {
            settings.put("stylesheetfile", this.fStylesheet);
        }
        if (this.fTitle.length() != 0) {
            settings.put("doctitle", this.fTitle);
        }
        if (checkedProjects.length == 1) {
            this.updateRecentSettings(checkedProjects[0]);
        }
        this.getRecentSettings().store(settings);
    }

    public void setJavadocCommandHistory(String[] javadocCommandHistory) {
        this.fJavadocCommandHistory = javadocCommandHistory;
    }

    public void setAccess(String access) {
        this.fAccess = access;
    }

    public void setDestination(String destination) {
        this.fDestination = destination;
    }

    public void setDocletPath(String docletpath) {
        this.fDocletpath = docletpath;
    }

    public void setDocletName(String docletname) {
        this.fDocletname = docletname;
    }

    public void setStyleSheet(String stylesheet) {
        this.fStylesheet = stylesheet;
    }

    public void setOverview(String overview) {
        this.fOverview = overview;
    }

    public void setAdditionalParams(String params) {
        this.fAdditionalParams = params;
    }

    public void setVMParams(String params) {
        this.fVMParams = params;
    }

    public void setGeneralAntpath(String antpath) {
        this.fAntpath = antpath;
    }

    public void setClasspath(IPath[] classpath) {
        this.fClasspath = classpath;
    }

    public void setSourcepath(IPath[] sourcepath) {
        this.fSourcepath = sourcepath;
    }

    public void setSelectedElements(IJavaElement[] elements) {
        this.fSelectedElements = elements;
    }

    public void setFromStandard(boolean fromStandard) {
        this.fFromStandard = fromStandard;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setOpenInBrowser(boolean openInBrowser) {
        this.fOpenInBrowser = openInBrowser;
    }

    public void setHRefs(String[] hrefs) {
        this.fHRefs = hrefs;
    }

    public void setBoolean(String flag, boolean value) {
        if (flag.equals("author")) {
            this.fAuthor = value;
        } else if (flag.equals("use")) {
            this.fUse = value;
        } else if (flag.equals("version")) {
            this.fVersion = value;
        } else if (flag.equals("nodeprecated")) {
            this.fNodeprecated = value;
        } else if (flag.equals("nodeprecatedlist")) {
            this.fNoDeprecatedlist = value;
        } else if (flag.equals("noindex")) {
            this.fNoindex = value;
        } else if (flag.equals("notree")) {
            this.fNotree = value;
        } else if (flag.equals("splitindex")) {
            this.fSplitindex = value;
        } else if (flag.equals("nonavbar")) {
            this.fNonavbar = value;
        }
    }

    public void setSource(String source) {
        this.fSource = source;
    }

    public String getSource() {
        return this.fSource;
    }

    private IJavaElement[] getInitialElementsFromSelection(List candidates) {
        ArrayList<IJavaElement> res = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < candidates.size()) {
            try {
                IJavaElement elem = this.getSelectableJavaElement(candidates.get(i));
                if (elem != null) {
                    res.add(elem);
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return res.toArray(new IJavaElement[res.size()]);
    }

    private IJavaElement getSelectableJavaElement(Object obj) throws JavaModelException {
        IJavaElement je = null;
        if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            je = (IJavaElement)iAdaptable.getAdapter((Class)clazz);
        }
        if (je != null) {
            switch (je.getElementType()) {
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    if (!this.containsCompilationUnits((IPackageFragmentRoot)je)) break;
                    return je;
                }
                case 4: {
                    if (!this.containsCompilationUnits((IPackageFragment)je)) break;
                    return je;
                }
                default: {
                    ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
                    if (cu == null) break;
                    return cu;
                }
            }
            IJavaProject project = je.getJavaProject();
            if (this.isValidProject(project)) {
                return project;
            }
        }
        return null;
    }

    private boolean isValidProject(IJavaProject project) throws JavaModelException {
        return project != null && project.exists() && project.isOpen();
    }

    private boolean containsCompilationUnits(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getKind() != 1) {
            return false;
        }
        IJavaElement[] elements = root.getChildren();
        int i = 0;
        while (i < elements.length) {
            IPackageFragment fragment;
            if (elements[i] instanceof IPackageFragment && this.containsCompilationUnits(fragment = (IPackageFragment)elements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsCompilationUnits(IPackageFragment pack) throws JavaModelException {
        return pack.getCompilationUnits().length > 0;
    }

    public RecentSettingsStore getRecentSettings() {
        return this.fRecentSettings;
    }

    public void updateRecentSettings(IJavaProject project) {
        this.fRecentSettings.setProjectSettings(project, this.fDestination, this.fAntpath, this.fHRefs);
    }

    private static String initJavadocCommandDefault() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        String cmd = store.getString("command");
        if (cmd != null && cmd.length() > 0) {
            store.setToDefault("command");
            return cmd;
        }
        File file = JavadocOptionsManager.findJavaDocCommand();
        if (file != null) {
            return file.getPath();
        }
        return "";
    }

    private static File findJavaDocCommand() {
        File res;
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null && (res = JavadocOptionsManager.getCommand(install)) != null) {
            return res;
        }
        IVMInstallType[] jreTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < jreTypes.length) {
            IVMInstallType jreType = jreTypes[i];
            IVMInstall[] installs = jreType.getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                File res2 = JavadocOptionsManager.getCommand(installs[k]);
                if (res2 != null) {
                    return res2;
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    private static File getCommand(IVMInstall install) {
        File installLocation = install.getInstallLocation();
        if (installLocation != null) {
            File javaDocCommand = new File(installLocation, "bin/javadoc");
            if (javaDocCommand.isFile()) {
                return javaDocCommand;
            }
            javaDocCommand = new File(installLocation, "bin/javadoc.exe");
            if (javaDocCommand.isFile()) {
                return javaDocCommand;
            }
        }
        return null;
    }
}

