/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public JavaElementHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || canShowMultipleHyperlinks || !(this.fTextEditor instanceof JavaEditor)) {
            return null;
        }
        IAction openAction = this.fTextEditor.getAction("OpenEditor");
        if (openAction == null) {
            return null;
        }
        int offset = region.getOffset();
        IJavaElement input = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fTextEditor, false);
        if (input == null) {
            return null;
        }
        try {
            IJavaElement[] elements = null;
            elements = ((ICodeAssist)input).codeSelect(offset, 0);
            IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
            if (elements != null && elements.length > 0) {
                return new IHyperlink[]{new JavaElementHyperlink(this.selectWord(document, offset), openAction)};
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    private IRegion selectWord(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++offset;
            }
            int end = offset;
            if (start == end) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

