/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.navigator.CommonLayoutActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public class PackageExplorerActionProvider
extends CommonActionProvider {
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String TAG_LAYOUT = "layout";
    private CommonLayoutActionGroup fLayoutActionGroup;
    private boolean fHasFilledViewMenu = false;
    private IExtensionStateModel fStateModel;
    private CCPActionGroup fCCPGroup;

    public void fillActionBars(IActionBars actionBars) {
        if (!this.fHasFilledViewMenu) {
            this.fLayoutActionGroup.fillActionBars(actionBars);
            this.fHasFilledViewMenu = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fCCPGroup != null) {
            this.fCCPGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite config) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (config.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)config.getViewSite();
        }
        this.fStateModel = config.getExtensionStateModel();
        this.fLayoutActionGroup = new CommonLayoutActionGroup(config.getStructuredViewer(), this.fStateModel);
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            this.fCCPGroup = new CCPActionGroup((IViewPart)workbenchSite.getPart());
        }
    }

    public void init(String extensionId, IViewPart viewPart, INavigatorContentService contentService, StructuredViewer structuredViewer) {
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        boolean isCurrentLayoutFlat = true;
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            state = new Integer(store.getInt(TAG_LAYOUT));
        }
        if (state == 2) {
            isCurrentLayoutFlat = true;
        } else if (state == 1) {
            isCurrentLayoutFlat = false;
        }
        this.fStateModel.setBooleanProperty("isLayoutFlat", isCurrentLayoutFlat);
        this.fLayoutActionGroup.setFlatLayout(isCurrentLayoutFlat);
    }
}

