/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NativeLibrariesDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
    public static final String DATA_DO_CREATE = "do_create";
    public static final String DATA_LIBRARY_TO_SELECT = "select_library";
    private IDialogSettings fDialogSettings;
    private TreeListDialogField fLibraryList;
    private IJavaProject fDummyProject;
    private static final int IDX_NEW = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_ADD = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_UP = 5;
    private static final int IDX_DOWN = 6;
    private static final int IDX_LOAD = 8;
    private static final int IDX_SAVE = 9;

    public UserLibraryPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fDummyProject = UserLibraryPreferencePage.getPlaceholderProject();
        this.setTitle(PreferencesMessages.UserLibraryPreferencePage_title);
        this.setDescription(PreferencesMessages.UserLibraryPreferencePage_description);
        this.noDefaultAndApplyButton();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        UserLibraryAdapter adapter = new UserLibraryAdapter();
        String[] stringArray = new String[10];
        stringArray[0] = PreferencesMessages.UserLibraryPreferencePage_libraries_new_button;
        stringArray[1] = PreferencesMessages.UserLibraryPreferencePage_libraries_edit_button;
        stringArray[2] = PreferencesMessages.UserLibraryPreferencePage_libraries_addjar_button;
        stringArray[3] = PreferencesMessages.UserLibraryPreferencePage_libraries_remove_button;
        stringArray[5] = PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_up_button;
        stringArray[6] = PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_down_button;
        stringArray[8] = PreferencesMessages.UserLibraryPreferencePage_libraries_load_button;
        stringArray[9] = PreferencesMessages.UserLibraryPreferencePage_libraries_save_button;
        String[] buttonLabels = stringArray;
        this.fLibraryList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibraryList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_libraries_label);
        String[] names = JavaCore.getUserLibraryNames();
        ArrayList<CPUserLibraryElement> elements = new ArrayList<CPUserLibraryElement>();
        int i = 0;
        while (i < names.length) {
            IPath path = new Path("org.eclipse.jdt.USER_LIBRARY").append(names[i]);
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.fDummyProject);
                elements.add(new CPUserLibraryElement(names[i], container, this.fDummyProject));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        this.fLibraryList.setElements(elements);
        this.fLibraryList.setViewerSorter(new CPListElementSorter());
        this.doSelectionChanged(this.fLibraryList);
    }

    public static IJavaProject getPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            Object selectedLibrary = map.get(DATA_LIBRARY_TO_SELECT);
            boolean createIfNotExists = Boolean.TRUE.equals(map.get(DATA_DO_CREATE));
            if (selectedLibrary instanceof String) {
                int nElements = this.fLibraryList.getSize();
                int i = 0;
                while (i < nElements) {
                    CPUserLibraryElement curr = (CPUserLibraryElement)this.fLibraryList.getElement(i);
                    if (curr.getName().equals(selectedLibrary)) {
                        this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)curr));
                        this.fLibraryList.expandElement(curr, 1);
                        break;
                    }
                    ++i;
                }
                if (createIfNotExists) {
                    CPUserLibraryElement elem = new CPUserLibraryElement((String)selectedLibrary, null, UserLibraryPreferencePage.getPlaceholderProject());
                    this.fLibraryList.addElement(elem);
                    this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)elem));
                }
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.cp_userlibraries_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibraryList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibraryList.getTreeControl(null));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            if (monitor != null) {
                                monitor = new NullProgressMonitor();
                            }
                            UserLibraryPreferencePage.this.updateUserLibararies(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String title = PreferencesMessages.UserLibraryPreferencePage_config_error_title;
            String message = PreferencesMessages.UserLibraryPreferencePage_config_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        return true;
    }

    private void updateUserLibararies(IProgressMonitor monitor) throws CoreException {
        IPath path;
        List list = this.fLibraryList.getElements();
        HashSet<String> oldNames = new HashSet<String>(Arrays.asList(JavaCore.getUserLibraryNames()));
        int nExisting = list.size();
        HashSet<CPUserLibraryElement> newEntries = new HashSet<CPUserLibraryElement>(list.size());
        int i = 0;
        while (i < nExisting) {
            CPUserLibraryElement element = (CPUserLibraryElement)list.get(i);
            boolean contained = oldNames.remove(element.getName());
            if (!contained) {
                newEntries.add(element);
            }
            ++i;
        }
        int len = nExisting + oldNames.size();
        monitor.beginTask(PreferencesMessages.UserLibraryPreferencePage_operation, len);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.jdt.ui", 0, PreferencesMessages.UserLibraryPreferencePage_operation_error, null);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jdt.USER_LIBRARY");
        IJavaProject jproject = this.fDummyProject;
        IJavaProject[] projectInit = new IJavaProject[]{jproject};
        IClasspathContainer[] containerInit = new IClasspathContainer[1];
        int i2 = 0;
        while (i2 < nExisting) {
            CPUserLibraryElement element = (CPUserLibraryElement)list.get(i2);
            path = element.getPath();
            if (newEntries.contains(element) || element.hasChanges(JavaCore.getClasspathContainer((IPath)path, (IJavaProject)jproject))) {
                IClasspathContainer updatedContainer = element.getUpdatedContainer();
                try {
                    initializer.requestClasspathContainerUpdate(path, jproject, updatedContainer);
                    containerInit[0] = updatedContainer;
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])projectInit, (IClasspathContainer[])containerInit, null);
                }
                catch (CoreException e) {
                    multiStatus.add(e.getStatus());
                }
            }
            monitor.worked(1);
            ++i2;
        }
        containerInit[0] = null;
        Iterator<String> iter = oldNames.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            path = new Path("org.eclipse.jdt.USER_LIBRARY").append(name);
            try {
                initializer.requestClasspathContainerUpdate(path, jproject, null);
                JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])projectInit, (IClasspathContainer[])containerInit, null);
            }
            catch (CoreException e) {
                multiStatus.add(e.getStatus());
            }
            monitor.worked(1);
        }
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private CPUserLibraryElement getSingleSelectedLibrary(List selected) {
        if (selected.size() == 1 && selected.get(0) instanceof CPUserLibraryElement) {
            return (CPUserLibraryElement)selected.get(0);
        }
        return null;
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        NativeLibrariesDialog dialog;
        String key = elem.getKey();
        CPListElement selElement = elem.getParent();
        if (key.equals("sourcepath")) {
            IClasspathEntry result = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), selElement.getClasspathEntry());
            if (result != null) {
                selElement.setAttribute("sourcepath", result.getSourceAttachmentPath());
                this.fLibraryList.refresh(elem);
                this.fLibraryList.update(selElement);
            }
        } else if (key.equals("javadoc_location")) {
            String initialLocation = (String)selElement.getAttribute("javadoc_location");
            String elementName = new CPListLabelProvider().getText(selElement);
            try {
                URL locationURL = initialLocation != null ? new URL(initialLocation) : null;
                URL[] result = BuildPathDialogAccess.configureJavadocLocation(this.getShell(), elementName, locationURL);
                if (result != null) {
                    URL newURL = result[0];
                    selElement.setAttribute("javadoc_location", newURL != null ? newURL.toExternalForm() : null);
                    this.fLibraryList.refresh(elem);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (key.equals("accessrules")) {
            AccessRulesDialog dialog2 = new AccessRulesDialog(this.getShell(), selElement, null, false);
            if (dialog2.open() == 0) {
                selElement.setAttribute("accessrules", dialog2.getAccessRules());
                this.fLibraryList.refresh(elem);
            }
        } else if (key.equals(CPListElement.NATIVE_LIB_PATH) && (dialog = new NativeLibrariesDialog(this.getShell(), selElement)).open() == 0) {
            selElement.setAttribute(CPListElement.NATIVE_LIB_PATH, dialog.getNativeLibraryPath());
            this.fLibraryList.refresh(elem);
        }
    }

    protected void doSelectionChanged(TreeListDialogField field) {
        List list = field.getSelectedElements();
        field.enableButton(3, this.canRemove(list));
        field.enableButton(1, this.canEdit(list));
        field.enableButton(2, this.canAdd(list));
        field.enableButton(5, this.canMoveUp(list));
        field.enableButton(6, this.canMoveDown(list));
        field.enableButton(9, field.getSize() > 0);
    }

    protected void doCustomButtonPressed(TreeListDialogField field, int index) {
        if (index == 0) {
            this.editUserLibraryElement(null);
        } else if (index == 2) {
            this.doAdd(field.getSelectedElements());
        } else if (index == 3) {
            this.doRemove(field.getSelectedElements());
        } else if (index == 1) {
            this.doEdit(field.getSelectedElements());
        } else if (index == 9) {
            this.doSave();
        } else if (index == 8) {
            this.doLoad();
        } else if (index == 5) {
            this.doMoveUp(field.getSelectedElements());
        } else if (index == 6) {
            this.doMoveDown(field.getSelectedElements());
        }
    }

    protected void doDoubleClicked(TreeListDialogField field) {
        List selected = field.getSelectedElements();
        if (this.canEdit(selected)) {
            this.doEdit(field.getSelectedElements());
        }
    }

    protected void doKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.doRemove(selection);
        }
    }

    private void doEdit(List selected) {
        if (selected.size() == 1) {
            Object curr = selected.get(0);
            if (curr instanceof CPListElementAttribute) {
                this.editAttributeEntry((CPListElementAttribute)curr);
            } else if (curr instanceof CPUserLibraryElement) {
                this.editUserLibraryElement((CPUserLibraryElement)curr);
            } else if (curr instanceof CPListElement) {
                CPListElement elem = (CPListElement)curr;
                this.editArchiveElement(elem, (CPUserLibraryElement)elem.getParentContainer());
            }
        }
    }

    private void editUserLibraryElement(CPUserLibraryElement element) {
        LibraryNameDialog dialog = new LibraryNameDialog(this.getShell(), element, this.fLibraryList.getElements());
        if (dialog.open() == 0) {
            CPUserLibraryElement newLibrary = dialog.getNewLibrary();
            if (element != null) {
                this.fLibraryList.replaceElement(element, newLibrary);
            } else {
                this.fLibraryList.addElement(newLibrary);
            }
            this.fLibraryList.expandElement(newLibrary, -1);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)newLibrary));
        }
    }

    private void editArchiveElement(CPListElement existingElement, CPUserLibraryElement parent) {
        CPListElement[] elements = this.openExtJarFileDialog(existingElement, parent);
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                if (existingElement != null) {
                    parent.replace(existingElement, elements[i]);
                } else {
                    parent.add(elements[i]);
                }
                ++i;
            }
            this.fLibraryList.refresh(parent);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(Arrays.asList(elements)));
        }
    }

    private void doRemove(List selected) {
        Object selectionAfter = null;
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof CPUserLibraryElement) {
                this.fLibraryList.removeElement(curr);
            } else if (curr instanceof CPListElement) {
                Object parent = ((CPListElement)curr).getParentContainer();
                if (parent instanceof CPUserLibraryElement) {
                    CPUserLibraryElement elem = (CPUserLibraryElement)parent;
                    elem.remove((CPListElement)curr);
                    this.fLibraryList.refresh(elem);
                    selectionAfter = parent;
                }
            } else if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)curr;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                this.fLibraryList.refresh(attrib);
            }
            ++i;
        }
        if (this.fLibraryList.getSelectedElements().isEmpty()) {
            if (selectionAfter != null) {
                this.fLibraryList.selectElements((ISelection)new StructuredSelection(selectionAfter));
            } else {
                this.fLibraryList.selectFirstElement();
            }
        }
    }

    private void doAdd(List list) {
        if (this.canAdd(list)) {
            CPUserLibraryElement element = this.getSingleSelectedLibrary(list);
            this.editArchiveElement(null, element);
        }
    }

    private void doLoad() {
        List existing = this.fLibraryList.getElements();
        LoadSaveDialog dialog = new LoadSaveDialog(this.getShell(), false, existing, this.fDialogSettings);
        if (dialog.open() == 0) {
            HashMap<String, CPUserLibraryElement> map = new HashMap<String, CPUserLibraryElement>(existing.size());
            int k = 0;
            while (k < existing.size()) {
                CPUserLibraryElement elem = (CPUserLibraryElement)existing.get(k);
                map.put(elem.getName(), elem);
                ++k;
            }
            List list = dialog.getLoadedLibraries();
            int i = 0;
            while (i < list.size()) {
                CPUserLibraryElement elem = (CPUserLibraryElement)list.get(i);
                CPUserLibraryElement found = (CPUserLibraryElement)map.get(elem.getName());
                if (found == null) {
                    existing.add(elem);
                    map.put(elem.getName(), elem);
                } else {
                    existing.set(existing.indexOf(found), elem);
                }
                ++i;
            }
            this.fLibraryList.setElements(existing);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(list));
        }
    }

    private void doSave() {
        LoadSaveDialog dialog = new LoadSaveDialog(this.getShell(), true, this.fLibraryList.getElements(), this.fDialogSettings);
        dialog.open();
    }

    private boolean canAdd(List list) {
        return this.getSingleSelectedLibrary(list) != null;
    }

    private boolean canEdit(List list) {
        return list.size() == 1;
    }

    private boolean canRemove(List list) {
        return !list.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CPUserLibraryElement getCommonParent(List list) {
        CPUserLibraryElement parent = null;
        int i = 0;
        int len = list.size();
        while (i < len) {
            Object curr = list.get(i);
            if (!(curr instanceof CPListElement)) return null;
            Object elemParent = ((CPListElement)curr).getParentContainer();
            if (parent == null) {
                if (!(elemParent instanceof CPUserLibraryElement)) return null;
                parent = (CPUserLibraryElement)elemParent;
            } else if (parent != elemParent) {
                return null;
            }
            ++i;
        }
        return parent;
    }

    private void doMoveUp(List list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            parent.moveUp(list);
            this.fLibraryList.refresh(parent);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doMoveDown(List list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            parent.moveDown(list);
            this.fLibraryList.refresh(parent);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private boolean canMoveUp(List list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            CPListElement[] children = parent.getChildren();
            int i = 0;
            int len = Math.min(list.size(), children.length);
            while (i < len) {
                if (!list.contains(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canMoveDown(List list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            CPListElement[] children = parent.getChildren();
            int i = children.length - 1;
            int end = Math.max(0, children.length - list.size());
            while (i >= end) {
                if (!list.contains(children[i])) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing, Object parent) {
        String res;
        String lastUsedPath;
        if (existing != null) {
            lastUsedPath = existing.getPath().removeLastSegments(1).toOSString();
        } else {
            lastUsedPath = this.fDialogSettings.get("org.eclipse.jdt.ui.lastextjar");
            if (lastUsedPath == null) {
                lastUsedPath = "";
            }
        }
        String title = existing == null ? PreferencesMessages.UserLibraryPreferencePage_browsejar_new_title : PreferencesMessages.UserLibraryPreferencePage_browsejar_edit_title;
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        if (existing != null) {
            dialog.setFileName(existing.getPath().lastSegment());
        }
        if ((res = dialog.open()) == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        CPListElement[] elems = new CPListElement[nChosen];
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            CPListElement curr = new CPListElement(parent, null, 1, path, null);
            curr.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(curr));
            curr.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(curr));
            elems[i] = curr;
            ++i;
        }
        this.fDialogSettings.put("org.eclipse.jdt.ui.lastextjar", dialog.getFilterPath());
        return elems;
    }

    public static class LibraryNameDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fNameField;
        private SelectionButtonDialogField fIsSystemField;
        private CPUserLibraryElement fElementToEdit;
        private List fExistingLibraries;

        public LibraryNameDialog(Shell parent, CPUserLibraryElement elementToEdit, List existingLibraries) {
            super(parent);
            if (elementToEdit == null) {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_new_title);
            } else {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_edit_title);
            }
            this.fElementToEdit = elementToEdit;
            this.fExistingLibraries = existingLibraries;
            this.fNameField = new StringDialogField();
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_label);
            this.fIsSystemField = new SelectionButtonDialogField(32);
            this.fIsSystemField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_issystem_label);
            if (elementToEdit != null) {
                this.fNameField.setText(elementToEdit.getName());
                this.fIsSystemField.setSelection(elementToEdit.isSystemLibrary());
            } else {
                this.fNameField.setText("");
                this.fIsSystemField.setSelection(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fNameField, this.fIsSystemField}, true, -1, -1);
            this.fNameField.postSetFocusOnDialogField(parent.getDisplay());
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fNameField) {
                this.updateStatus(this.validateSettings());
            }
        }

        private IStatus validateSettings() {
            String name = this.fNameField.getText();
            if (name.length() == 0) {
                return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_error_entername);
            }
            int i = 0;
            while (i < this.fExistingLibraries.size()) {
                CPUserLibraryElement curr = (CPUserLibraryElement)this.fExistingLibraries.get(i);
                if (curr != this.fElementToEdit && name.equals(curr.getName())) {
                    return new StatusInfo(4, Messages.format(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_error_exists, name));
                }
                ++i;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (status.matches(4)) {
                return new StatusInfo(4, "Name contains invalid characters.");
            }
            return StatusInfo.OK_STATUS;
        }

        public CPUserLibraryElement getNewLibrary() {
            CPListElement[] entries = null;
            if (this.fElementToEdit != null) {
                entries = this.fElementToEdit.getChildren();
            }
            return new CPUserLibraryElement(this.fNameField.getText(), this.fIsSystemField.isSelected(), entries);
        }
    }

    public static class LoadSaveDialog
    extends StatusDialog
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private static final String VERSION1 = "1";
        private static final String CURRENT_VERSION = "2";
        private static final String TAG_ROOT = "eclipse-userlibraries";
        private static final String TAG_VERSION = "version";
        private static final String TAG_LIBRARY = "library";
        private static final String TAG_SOURCEATTACHMENT = "source";
        private static final String TAG_ARCHIVE_PATH = "path";
        private static final String TAG_ARCHIVE = "archive";
        private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
        private static final String TAG_NAME = "name";
        private static final String TAG_JAVADOC = "javadoc";
        private static final String TAG_NATIVELIB_PATHS = "nativelibpaths";
        private static final String TAG_ACCESSRULES = "accessrules";
        private static final String TAG_ACCESSRULE = "accessrule";
        private static final String TAG_RULE_KIND = "kind";
        private static final String TAG_RULE_PATTERN = "pattern";
        private static final String PREF_LASTPATH = "org.eclipse.jdt.ui.lastuserlibrary";
        private static final String PREF_USER_LIBRARY_LOADSAVE_SIZE = "UserLibraryLoadSaveDialog.size";
        private List fExistingLibraries;
        private IDialogSettings fSettings;
        private File fLastFile;
        private StringButtonDialogField fLocationField;
        private CheckedListDialogField fExportImportList;
        private Point fInitialSize;
        private final boolean fIsSave;

        public LoadSaveDialog(Shell shell, boolean isSave, List existingLibraries, IDialogSettings dialogSettings) {
            super(shell);
            this.initializeDialogUnits((Control)shell);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
            this.fExistingLibraries = existingLibraries;
            this.fSettings = dialogSettings;
            this.fLastFile = null;
            this.fIsSave = isSave;
            int defaultWidth = this.convertWidthInCharsToPixels(80);
            int defaultHeigth = this.convertHeightInCharsToPixels(34);
            String lastSize = this.fSettings.get(PREF_USER_LIBRARY_LOADSAVE_SIZE);
            this.fInitialSize = lastSize != null ? StringConverter.asPoint((String)lastSize, (Point)new Point(defaultWidth, defaultHeigth)) : new Point(defaultWidth, defaultHeigth);
            if (this.isSave()) {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_title);
            } else {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_title);
            }
            this.fLocationField = new StringButtonDialogField(this);
            this.fLocationField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_label);
            this.fLocationField.setButtonLabel(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_button);
            this.fLocationField.setDialogFieldListener(this);
            String[] buttonNames = new String[]{PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_selectall_button, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_deselectall_button};
            this.fExportImportList = new CheckedListDialogField(this, buttonNames, (ILabelProvider)new CPListLabelProvider());
            this.fExportImportList.setCheckAllButtonIndex(0);
            this.fExportImportList.setUncheckAllButtonIndex(1);
            this.fExportImportList.setViewerSorter(new CPListElementSorter());
            this.fExportImportList.setDialogFieldListener(this);
            if (this.isSave()) {
                this.fExportImportList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_save_label);
                this.fExportImportList.setElements(this.fExistingLibraries);
                this.fExportImportList.checkAll(true);
            } else {
                this.fExportImportList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_load_label);
            }
            String lastPath = this.fSettings.get(PREF_LASTPATH);
            if (lastPath != null) {
                this.fLocationField.setText(lastPath);
            } else {
                this.fLocationField.setText("");
            }
        }

        protected Point getInitialSize() {
            return this.fInitialSize;
        }

        private boolean isSave() {
            return this.fIsSave;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            DialogField[] fields = this.isSave() ? new DialogField[]{this.fExportImportList, this.fLocationField} : new DialogField[]{this.fLocationField, this.fExportImportList};
            LayoutUtil.doDefaultLayout(composite, fields, true, -1, -1);
            this.fExportImportList.getListControl(null).setLayoutData((Object)new GridData(1808));
            this.fLocationField.postSetFocusOnDialogField(parent.getDisplay());
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void changeControlPressed(DialogField field) {
            String fileName;
            String label = this.isSave() ? PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_filedialog_save_title : PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_filedialog_load_title;
            FileDialog dialog = new FileDialog(this.getShell(), this.isSave() ? 8192 : 4096);
            dialog.setText(label);
            dialog.setFilterExtensions(new String[]{"*.userlibraries", "*.*"});
            String lastPath = this.fLocationField.getText();
            if (lastPath.length() == 0 || !new File(lastPath).exists()) {
                lastPath = this.fSettings.get(PREF_LASTPATH);
            }
            if (lastPath != null) {
                dialog.setFileName(lastPath);
            }
            if ((fileName = dialog.open()) != null) {
                this.fSettings.put(PREF_LASTPATH, fileName);
                this.fLocationField.setText(fileName);
            }
        }

        private IStatus updateShownLibraries(IStatus status) {
            if (!status.isOK()) {
                this.fExportImportList.removeAllElements();
                this.fExportImportList.setEnabled(false);
                this.fLastFile = null;
            } else {
                File file = new File(this.fLocationField.getText());
                if (!file.equals(this.fLastFile)) {
                    this.fLastFile = file;
                    try {
                        List elements = LoadSaveDialog.loadLibraries(file);
                        this.fExportImportList.setElements(elements);
                        this.fExportImportList.checkAll(true);
                        this.fExportImportList.setEnabled(true);
                        if (elements.isEmpty()) {
                            return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_error_empty);
                        }
                    }
                    catch (IOException iOException) {
                        this.fExportImportList.removeAllElements();
                        this.fExportImportList.setEnabled(false);
                        return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_error_invalidfile);
                    }
                }
            }
            return status;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fLocationField) {
                IStatus status = this.validateSettings();
                if (!this.isSave()) {
                    status = this.updateShownLibraries(status);
                }
                this.updateStatus(status);
            } else if (field == this.fExportImportList) {
                this.updateStatus(this.validateSettings());
            }
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
            List selectedElements = this.fExportImportList.getSelectedElements();
            if (selectedElements.size() == 1) {
                Object elem;
                this.fExportImportList.setChecked(elem, !this.fExportImportList.isChecked(elem = selectedElements.get(0)));
            }
        }

        protected void okPressed() {
            if (this.isSave()) {
                File file = new File(this.fLocationField.getText());
                if (file.exists()) {
                    String title = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_overwrite_title;
                    String message = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_overwrite_message;
                    if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                        return;
                    }
                }
                List elements = this.fExportImportList.getCheckedElements();
                IProgressService context = PlatformUI.getWorkbench().getProgressService();
                try {
                    context.run(true, true, new IRunnableWithProgress(this, elements, file){
                        final /* synthetic */ LoadSaveDialog this$1;
                        private final /* synthetic */ List val$elements;
                        private final /* synthetic */ File val$file;
                        {
                            this.this$1 = loadSaveDialog;
                            this.val$elements = list;
                            this.val$file = file;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                LoadSaveDialog.saveLibraries(this.val$elements, this.val$file, monitor);
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                    this.fSettings.put(PREF_LASTPATH, file.getPath());
                }
                catch (InvocationTargetException e) {
                    String errorTitle = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_errordialog_title;
                    String errorMessage = Messages.format(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_errordialog_message, e.getMessage());
                    ExceptionHandler.handle(e, this.getShell(), errorTitle, errorMessage);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                String savedTitle = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_ok_title;
                String savedMessage = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_ok_message;
                MessageDialog.openInformation((Shell)this.getShell(), (String)savedTitle, (String)savedMessage);
            } else {
                HashSet<String> map = new HashSet<String>(this.fExistingLibraries.size());
                int k = 0;
                while (k < this.fExistingLibraries.size()) {
                    CPUserLibraryElement elem = (CPUserLibraryElement)this.fExistingLibraries.get(k);
                    map.add(elem.getName());
                    ++k;
                }
                int nReplaced = 0;
                List elements = this.getLoadedLibraries();
                int i = 0;
                while (i < elements.size()) {
                    CPUserLibraryElement curr = (CPUserLibraryElement)elements.get(i);
                    if (map.contains(curr.getName())) {
                        ++nReplaced;
                    }
                    ++i;
                }
                if (nReplaced > 0) {
                    String replaceTitle = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_title;
                    String replaceMessage = nReplaced == 1 ? PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_message : Messages.format(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_multiple_message, String.valueOf(nReplaced));
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)replaceTitle, (String)replaceMessage)) {
                        return;
                    }
                }
            }
            super.okPressed();
        }

        public boolean close() {
            Point point = this.getShell().getSize();
            this.fSettings.put(PREF_USER_LIBRARY_LOADSAVE_SIZE, StringConverter.asString((Point)point));
            return super.close();
        }

        private IStatus validateSettings() {
            String name = this.fLocationField.getText();
            this.fLastFile = null;
            if (this.isSave()) {
                if (name.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_save_enterlocation);
                }
                File file = new File(name);
                if (file.isDirectory()) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_save_invalid);
                }
                if (this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_error_save_nothingselected);
                }
                this.fLastFile = file;
            } else {
                if (name.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_load_enterlocation);
                }
                if (!new File(name).isFile()) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_load_invalid);
                }
                if (this.fExportImportList.getSize() > 0 && this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_error_load_nothingselected);
                }
            }
            return new StatusInfo();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected static void saveLibraries(List libraries, File file, IProgressMonitor monitor) throws IOException {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try {
                    DocumentBuilder docBuilder = null;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    docBuilder = factory.newDocumentBuilder();
                    Document document = docBuilder.newDocument();
                    Element rootElement = document.createElement(TAG_ROOT);
                    document.appendChild(rootElement);
                    rootElement.setAttribute(TAG_VERSION, CURRENT_VERSION);
                    int i = 0;
                    block9: while (true) {
                        block18: {
                            if (i < libraries.size()) break block18;
                            Transformer transformer = TransformerFactory.newInstance().newTransformer();
                            transformer.setOutputProperty("method", "xml");
                            transformer.setOutputProperty("encoding", "UTF-8");
                            transformer.setOutputProperty("indent", "yes");
                            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                            DOMSource source = new DOMSource(document);
                            StreamResult result = new StreamResult(stream);
                            transformer.transform(source, result);
                            break;
                        }
                        Element libraryElement = document.createElement(TAG_LIBRARY);
                        rootElement.appendChild(libraryElement);
                        CPUserLibraryElement curr = (CPUserLibraryElement)libraries.get(i);
                        libraryElement.setAttribute(TAG_NAME, curr.getName());
                        libraryElement.setAttribute(TAG_SYSTEMLIBRARY, String.valueOf(curr.isSystemLibrary()));
                        CPListElement[] children = curr.getChildren();
                        int k = 0;
                        while (true) {
                            IAccessRule[] accessRules;
                            String nativeLibPath;
                            String javadocLocation;
                            if (k >= children.length) {
                                ++i;
                                continue block9;
                            }
                            CPListElement child = children[k];
                            Element childElement = document.createElement(TAG_ARCHIVE);
                            libraryElement.appendChild(childElement);
                            childElement.setAttribute(TAG_ARCHIVE_PATH, child.getPath().toPortableString());
                            IPath sourceAttachment = (IPath)child.getAttribute("sourcepath");
                            if (sourceAttachment != null) {
                                childElement.setAttribute(TAG_SOURCEATTACHMENT, sourceAttachment.toPortableString());
                            }
                            if ((javadocLocation = (String)child.getAttribute("javadoc_location")) != null) {
                                childElement.setAttribute(TAG_JAVADOC, javadocLocation);
                            }
                            if ((nativeLibPath = (String)child.getAttribute(CPListElement.NATIVE_LIB_PATH)) != null) {
                                childElement.setAttribute(TAG_NATIVELIB_PATHS, nativeLibPath);
                            }
                            if ((accessRules = (IAccessRule[])child.getAttribute(TAG_ACCESSRULES)) != null && accessRules.length > 0) {
                                Element rulesElement = document.createElement(TAG_ACCESSRULES);
                                childElement.appendChild(rulesElement);
                                int n = 0;
                                while (n < accessRules.length) {
                                    IAccessRule rule = accessRules[n];
                                    Element ruleElement = document.createElement(TAG_ACCESSRULE);
                                    rulesElement.appendChild(ruleElement);
                                    ruleElement.setAttribute(TAG_RULE_KIND, String.valueOf(rule.getKind()));
                                    ruleElement.setAttribute(TAG_RULE_PATTERN, rule.getPattern().toPortableString());
                                    ++n;
                                }
                            }
                            ++k;
                        }
                        break;
                    }
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
                catch (TransformerException e) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var23_27 = null;
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
                if (monitor == null) throw throwable;
                monitor.done();
                throw throwable;
            }
            {
                Object var23_28 = null;
            }
            try {}
            catch (IOException iOException) {}
            ((OutputStream)stream).close();
            if (monitor == null) return;
            monitor.done();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static List loadLibraries(File file) throws IOException {
            Element cpElement;
            FileInputStream stream = new FileInputStream(file);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(stream)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((InputStream)stream).close();
                throw throwable;
            }
            {
                Object var4_7 = null;
            }
            ((InputStream)stream).close();
            if (!cpElement.getNodeName().equalsIgnoreCase(TAG_ROOT)) {
                throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
            }
            String version = cpElement.getAttribute(TAG_VERSION);
            NodeList libList = cpElement.getElementsByTagName(TAG_LIBRARY);
            int length = libList.getLength();
            ArrayList<CPUserLibraryElement> result = new ArrayList<CPUserLibraryElement>(length);
            int i = 0;
            while (i < length) {
                Node lib = libList.item(i);
                if (lib instanceof Element) {
                    Element libElement = (Element)lib;
                    String name = libElement.getAttribute(TAG_NAME);
                    boolean isSystem = Boolean.valueOf(libElement.getAttribute(TAG_SYSTEMLIBRARY));
                    CPUserLibraryElement newLibrary = new CPUserLibraryElement(name, isSystem, null);
                    result.add(newLibrary);
                    NodeList archiveList = libElement.getElementsByTagName(TAG_ARCHIVE);
                    int k = 0;
                    while (k < archiveList.getLength()) {
                        Node archiveNode = archiveList.item(k);
                        if (archiveNode instanceof Element) {
                            Element ruleParentElement;
                            NodeList ruleElements;
                            int nRuleElements;
                            NodeList rulesParentNodes;
                            Element archiveElement = (Element)archiveNode;
                            String pathString = archiveElement.getAttribute(TAG_ARCHIVE_PATH);
                            IPath path = version.equals(VERSION1) ? Path.fromOSString((String)pathString) : Path.fromPortableString((String)pathString);
                            CPListElement newArchive = new CPListElement(newLibrary, null, 1, path, null);
                            newLibrary.add(newArchive);
                            if (archiveElement.hasAttribute(TAG_SOURCEATTACHMENT)) {
                                String sourceAttachString = archiveElement.getAttribute(TAG_SOURCEATTACHMENT);
                                IPath sourceAttach = version.equals(VERSION1) ? Path.fromOSString((String)sourceAttachString) : Path.fromPortableString((String)sourceAttachString);
                                newArchive.setAttribute("sourcepath", sourceAttach);
                            }
                            if (archiveElement.hasAttribute(TAG_JAVADOC)) {
                                String javadoc = archiveElement.getAttribute(TAG_JAVADOC);
                                newArchive.setAttribute("javadoc_location", javadoc);
                            }
                            if (archiveElement.hasAttribute(TAG_NATIVELIB_PATHS)) {
                                String nativeLibPath = archiveElement.getAttribute(TAG_NATIVELIB_PATHS);
                                newArchive.setAttribute(CPListElement.NATIVE_LIB_PATH, nativeLibPath);
                            }
                            if ((rulesParentNodes = archiveElement.getElementsByTagName(TAG_ACCESSRULES)).getLength() > 0 && rulesParentNodes.item(0) instanceof Element && (nRuleElements = (ruleElements = (ruleParentElement = (Element)rulesParentNodes.item(0)).getElementsByTagName(TAG_ACCESSRULE)).getLength()) > 0) {
                                ArrayList<IAccessRule> resultingRules = new ArrayList<IAccessRule>(nRuleElements);
                                int n = 0;
                                while (true) {
                                    if (n >= nRuleElements) {
                                        newArchive.setAttribute(TAG_ACCESSRULES, resultingRules.toArray(new IAccessRule[resultingRules.size()]));
                                        break;
                                    }
                                    Node node = ruleElements.item(n);
                                    if (node instanceof Element) {
                                        Element ruleElement = (Element)node;
                                        try {
                                            int kind = Integer.parseInt(ruleElement.getAttribute(TAG_RULE_KIND));
                                            IPath pattern = Path.fromPortableString((String)ruleElement.getAttribute(TAG_RULE_PATTERN));
                                            resultingRules.add(JavaCore.newAccessRule((IPath)pattern, (int)kind));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    ++n;
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            return result;
        }

        public List getLoadedLibraries() {
            return this.fExportImportList.getCheckedElements();
        }
    }

    private class UserLibraryAdapter
    implements ITreeListAdapter {
        private final Object[] EMPTY = new Object[0];

        UserLibraryAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            UserLibraryPreferencePage.this.doCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            UserLibraryPreferencePage.this.doSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            UserLibraryPreferencePage.this.doDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            UserLibraryPreferencePage.this.doKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            CPListElementAttribute attribute;
            if (element instanceof CPUserLibraryElement) {
                CPUserLibraryElement elem = (CPUserLibraryElement)element;
                return elem.getChildren();
            }
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            if (element instanceof CPListElementAttribute && "accessrules".equals((attribute = (CPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return this.EMPTY;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getParentContainer();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }
    }
}

