/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class JavaMethodCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private int fContextInformationPosition;
    private LazyJavaCompletionProposal.FormatterPrefs fFormatterPrefs;

    public JavaMethodCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == '(') {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (this.needsLinkedMode()) {
            this.setUpLinkedMode(document, ')');
        }
    }

    protected boolean needsLinkedMode() {
        return this.hasArgumentList() && this.hasParameters() && !this.isEmptyConstructorProposal();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.isEmptyConstructorProposal()) {
            return "";
        }
        if (this.hasArgumentList()) {
            return String.valueOf(this.fProposal.getName());
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 6 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 12) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    private boolean computeHasParameters() throws IllegalArgumentException {
        return Signature.getParameterCount((char[])this.fProposal.getSignature()) > 0;
    }

    protected boolean hasArgumentList() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        boolean noOverwrite = preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        char[] completion = this.fProposal.getCompletion();
        return !this.isInJavadoc() && completion.length > 0 && (noOverwrite || completion[completion.length - 1] == ')');
    }

    protected final LazyJavaCompletionProposal.FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            this.fFormatterPrefs = new LazyJavaCompletionProposal.FormatterPrefs(this.fInvocationContext.getProject());
        }
        return this.fFormatterPrefs;
    }

    protected String computeReplacementString() {
        if (!this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        if (this.isEmptyConstructorProposal()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProposal.getName());
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            buffer.append(" ");
        }
        buffer.append("(");
        if (this.hasParameters()) {
            this.setCursorPosition(buffer.length());
            if (prefs.afterOpeningParen) {
                buffer.append(" ");
            }
        } else if (prefs.inEmptyList) {
            buffer.append(" ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private boolean isEmptyConstructorProposal() {
        char[] completion = this.fProposal.getCompletion();
        return completion.length == 1 && completion[0] == ')';
    }

    protected ProposalInfo computeProposalInfo() {
        IJavaProject project = this.fInvocationContext.getProject();
        if (project != null) {
            return new MethodProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    public void setContextInformationPosition(int contextInformationPosition) {
        this.fContextInformationPosition = contextInformationPosition;
    }

    protected String computeSortString() {
        char[] name = this.fProposal.getName();
        char[] parameterList = Signature.toCharArray((char[])this.fProposal.getSignature(), null, null, (boolean)false, (boolean)false);
        int parameterCount = Signature.getParameterCount((char[])this.fProposal.getSignature()) % 10;
        StringBuffer buf = new StringBuffer(name.length + 2 + parameterList.length);
        buf.append(name);
        buf.append('\u0000');
        buf.append(parameterCount);
        buf.append(parameterList);
        return buf.toString();
    }

    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        String word = this.getDisplayString();
        if (this.isInJavadoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        }
        return this.isPrefix(prefix, word);
    }
}

