/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.text.java.AbstractProposalSorter;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.text.Assert;
import org.osgi.framework.Bundle;

public final class ProposalSorterHandle {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String PERFORMANCE_EVENT = String.valueOf(JavaPlugin.getPluginId()) + "/perf/content_assist_sorters/extensions";
    private static final boolean MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)PERFORMANCE_EVENT);
    private static final String SORT = "sort";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final IConfigurationElement fElement;
    private AbstractProposalSorter fSorter;

    ProposalSorterHandle(IConfigurationElement element) throws InvalidRegistryObjectException {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fElement = element;
        this.fId = element.getAttributeAsIs(ID);
        this.checkNotNull(this.fId, ID);
        String name = element.getAttribute(NAME);
        this.fName = name == null ? this.fId : name;
        String activateAttribute = element.getAttributeAsIs(ACTIVATE);
        this.fActivate = Boolean.valueOf(activateAttribute);
        this.fClass = element.getAttributeAsIs(CLASS);
        this.checkNotNull(this.fClass, CLASS);
    }

    private void checkNotNull(Object obj, String attribute) throws InvalidRegistryObjectException {
        if (obj == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getNamespace(), attribute};
            String message = MessageFormat.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, null);
            JavaPlugin.log((IStatus)status);
            throw new InvalidRegistryObjectException();
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    private synchronized AbstractProposalSorter getSorter() throws CoreException, InvalidRegistryObjectException {
        if (this.fSorter == null && (this.fActivate || this.isPluginLoaded())) {
            this.fSorter = this.createSorter();
        }
        return this.fSorter;
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    private AbstractProposalSorter createSorter() throws CoreException, InvalidRegistryObjectException {
        return (AbstractProposalSorter)this.fElement.createExecutableExtension(CLASS);
    }

    public void sortProposals(ContentAssistInvocationContext context, List proposals) {
        Status status;
        try {
            AbstractProposalSorter sorter = this.getSorter();
            PerformanceStats stats = this.startMeter(SORT, sorter);
            sorter.beginSorting(context);
            Collections.sort(proposals, sorter);
            sorter.endSorting();
            status = this.stopMeter(stats, SORT);
            if (status == null) {
                return;
            }
            status = this.createAPIViolationStatus(SORT);
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        JavaPlugin.log((IStatus)status);
    }

    private IStatus stopMeter(PerformanceStats stats, String operation) {
        if (MEASURE_PERFORMANCE) {
            stats.endRun();
            if (stats.isFailure()) {
                return this.createPerformanceStatus(operation);
            }
        }
        return null;
    }

    private PerformanceStats startMeter(String context, AbstractProposalSorter sorter) {
        PerformanceStats stats;
        if (MEASURE_PERFORMANCE) {
            stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)sorter);
            stats.startRun(context);
        } else {
            stats = null;
        }
        return stats;
    }

    private Status createExceptionStatus(InvalidRegistryObjectException x) {
        String disable = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, JavaPlugin.getPluginId(), 0, String.valueOf(disable) + " " + reason, (Throwable)x);
    }

    private Status createExceptionStatus(CoreException x) {
        String disable = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, JavaPlugin.getPluginId(), 0, String.valueOf(disable) + " " + reason, (Throwable)x);
    }

    private Status createExceptionStatus(RuntimeException x) {
        String disable = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_runime_ex;
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(disable) + " " + reason, (Throwable)x);
    }

    private Status createAPIViolationStatus(String operation) {
        String disable = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = MessageFormat.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_API, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(disable) + " " + reason, null);
    }

    private Status createPerformanceStatus(String operation) {
        String disable = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = MessageFormat.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_performance, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(disable) + " " + reason, null);
    }

    private String createBlameMessage() {
        Object[] args = new Object[]{this.getName(), this.getId()};
        String disable = MessageFormat.format(JavaTextMessages.ProposalSorterHandle_blame, args);
        return disable;
    }

    public String getErrorMessage() {
        return null;
    }
}

