/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jdt.internal.ui.text.javadoc.IJavaDocTagConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavadocCompletionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;

public class JavaDocCompletionEvaluator
implements IJavadocCompletionProcessor,
IJavaDocTagConstants,
IHtmlTagConstants {
    private static final String[] fgHTMLProposals = new String[HTML_GENERAL_TAGS.length * 2];
    private IDocument fDocument;
    private int fCurrentPos;
    private int fCurrentLength;
    private String fErrorMessage;
    private List fResult;
    private boolean fRestrictToMatchingCase;

    public JavaDocCompletionEvaluator() {
        String tag = null;
        int index = 0;
        int offset = 0;
        while (index < fgHTMLProposals.length) {
            tag = HTML_GENERAL_TAGS[offset];
            JavaDocCompletionEvaluator.fgHTMLProposals[index++] = String.valueOf('<') + tag + '>';
            JavaDocCompletionEvaluator.fgHTMLProposals[index++] = "</" + tag + '>';
            ++offset;
        }
        this.fResult = new ArrayList();
    }

    private static boolean isWordPart(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '#' || ch == '.' || ch == '/';
    }

    private static int findCharBeforeWord(IDocument doc, int lineBeginPos, int pos) {
        int currPos = pos - 1;
        if (currPos > lineBeginPos) {
            try {
                while (currPos > lineBeginPos && JavaDocCompletionEvaluator.isWordPart(doc.getChar(currPos))) {
                    --currPos;
                }
                return currPos;
            }
            catch (BadLocationException badLocationException) {}
        }
        return pos;
    }

    private static int findClosingCharacter(IDocument doc, int pos, int end, char endChar) throws BadLocationException {
        int curr = pos;
        while (curr < end && doc.getChar(curr) != endChar) {
            ++curr;
        }
        if (curr < end) {
            return curr + 1;
        }
        return pos;
    }

    private static int findReplaceEndPos(IDocument doc, String newText, String oldText, int pos) {
        if (oldText.length() == 0 || oldText.equals(newText)) {
            return pos;
        }
        try {
            IRegion lineInfo = doc.getLineInformationOfOffset(pos);
            int end = lineInfo.getOffset() + lineInfo.getLength();
            return JavaDocCompletionEvaluator.findClosingCharacter(doc, pos, end, '>');
        }
        catch (BadLocationException badLocationException) {
            return pos;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IJavaCompletionProposal[] computeCompletionProposals(ICompilationUnit cu, int offset, int length, int flags) {
        this.fCurrentPos = offset;
        this.fCurrentLength = length;
        this.fRestrictToMatchingCase = (flags & 1) != 0;
        FileEditorInput editorInput = new FileEditorInput((IFile)cu.getResource());
        this.fDocument = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
        if (this.fDocument == null) {
            return null;
        }
        try {
            try {
                this.evalProposals();
                IJavaCompletionProposal[] iJavaCompletionProposalArray = this.fResult.toArray(new JavaCompletionProposal[this.fResult.size()]);
                Object var7_7 = null;
                this.fResult.clear();
                return iJavaCompletionProposalArray;
            }
            catch (JavaModelException e) {
                this.fErrorMessage = e.getLocalizedMessage();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fResult.clear();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.fResult.clear();
            return null;
        }
    }

    private void evalProposals() throws JavaModelException {
        try {
            IRegion info = this.fDocument.getLineInformationOfOffset(this.fCurrentPos);
            int lineBeginPos = info.getOffset();
            int word1Begin = JavaDocCompletionEvaluator.findCharBeforeWord(this.fDocument, lineBeginPos, this.fCurrentPos);
            if (word1Begin == this.fCurrentPos) {
                return;
            }
            char firstChar = this.fDocument.getChar(word1Begin);
            if (firstChar == '<') {
                String prefix = this.fDocument.get(word1Begin, this.fCurrentPos - word1Begin);
                this.addProposals(prefix, fgHTMLProposals, "org.eclipse.jdt.ui.html_tag_obj.gif");
                return;
            }
            if (!Character.isWhitespace(firstChar)) {
                return;
            }
            String prefix = this.fDocument.get(word1Begin + 1, this.fCurrentPos - word1Begin - 1);
            this.addAllTags(prefix);
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean prefixMatches(String prefix, String proposal) {
        if (this.fRestrictToMatchingCase) {
            return proposal.startsWith(prefix);
        }
        if (proposal.length() >= prefix.length()) {
            return prefix.equalsIgnoreCase(proposal.substring(0, prefix.length()));
        }
        return false;
    }

    private void addAllTags(String prefix) {
        String htmlPrefix = "<" + prefix;
        int i = 0;
        while (i < fgHTMLProposals.length) {
            String curr = fgHTMLProposals[i];
            if (this.prefixMatches(htmlPrefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, curr, JavaPluginImages.get("org.eclipse.jdt.ui.html_tag_obj.gif"), 0));
            }
            ++i;
        }
    }

    private void addProposals(String prefix, String[] choices, String imageName) {
        int i = 0;
        while (i < choices.length) {
            String curr = choices[i];
            if (this.prefixMatches(prefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, curr, JavaPluginImages.get(imageName), 0));
            }
            ++i;
        }
    }

    private JavaCompletionProposal createCompletion(String newText, String oldText, String labelText, Image image, int severity) {
        int offset = this.fCurrentPos - oldText.length();
        int length = this.fCurrentLength + oldText.length();
        if (this.fCurrentLength == 0) {
            length = JavaDocCompletionEvaluator.findReplaceEndPos(this.fDocument, newText, oldText, this.fCurrentPos) - offset;
        }
        JavaCompletionProposal proposal = new JavaCompletionProposal(newText, offset, length, image, labelText, severity, true);
        proposal.setTriggerCharacters(new char[]{'>'});
        return proposal;
    }

    public IContextInformation[] computeContextInformation(ICompilationUnit cu, int offset) {
        this.fErrorMessage = null;
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }
}

