/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingProblem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension4;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class PropertiesSpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private ITextEditor fEditor;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;

    public PropertiesSpellingReconcileStrategy(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return;
        }
        try {
            SpellingContext context = new SpellingContext();
            context.setContentType(this.getContentType());
            SpellingProblemCollector collector = new SpellingProblemCollector(model);
            EditorsUI.getSpellingService().check(this.fDocument, context, (ISpellingProblemCollector)collector, this.fProgressMonitor);
        }
        catch (CoreException coreException) {}
    }

    private IContentType getContentType() throws CoreException {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider instanceof IDocumentProviderExtension4) {
            return ((IDocumentProviderExtension4)documentProvider).getContentType((Object)this.fEditor.getEditorInput());
        }
        return null;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map fAddAnnotations;

        public SpellingProblemCollector(IAnnotationModel annotationModel) {
            this.fAnnotationModel = annotationModel;
        }

        public void accept(SpellingProblem problem) {
            try {
                IEditorInput editorInput;
                int line = PropertiesSpellingReconcileStrategy.this.fDocument.getLineOfOffset(problem.getOffset()) + 1;
                String word = PropertiesSpellingReconcileStrategy.this.fDocument.get(problem.getOffset(), problem.getLength());
                boolean dictionaryMatch = false;
                boolean sentenceStart = false;
                if (problem instanceof JavaSpellingProblem) {
                    dictionaryMatch = ((JavaSpellingProblem)problem).isDictionaryMatch();
                    sentenceStart = ((JavaSpellingProblem)problem).isSentenceStart();
                }
                if ((editorInput = PropertiesSpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                    CoreSpellingProblem iProblem = new CoreSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength() - 1, line, problem.getMessage(), word, dictionaryMatch, sentenceStart, PropertiesSpellingReconcileStrategy.this.fDocument, editorInput.getName());
                    this.fAddAnnotations.put(new CompilationUnitDocumentProvider.ProblemAnnotation((IProblem)iProblem, null), new Position(problem.getOffset(), problem.getLength()));
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public void beginCollecting() {
            this.fAddAnnotations = new HashMap();
        }

        public void endCollecting() {
            Annotation annotation;
            ArrayList<Annotation> removeAnnotations = new ArrayList<Annotation>();
            Iterator<Object> iter = this.fAnnotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                annotation = (Annotation)iter.next();
                if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(annotation.getType())) continue;
                removeAnnotations.add(annotation);
            }
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(removeAnnotations.toArray(new Annotation[removeAnnotations.size()]), this.fAddAnnotations);
            } else {
                iter = removeAnnotations.iterator();
                while (iter.hasNext()) {
                    this.fAnnotationModel.removeAnnotation((Annotation)iter.next());
                }
                iter = this.fAddAnnotations.keySet().iterator();
                while (iter.hasNext()) {
                    annotation = (Annotation)iter.next();
                    this.fAnnotationModel.addAnnotation(annotation, (Position)this.fAddAnnotations.get(annotation));
                }
            }
            this.fAddAnnotations = null;
        }
    }
}

