/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ArchiveFileFilter
extends ViewerFilter {
    public static final String[] FILTER_EXTENSIONS = new String[]{"*.jar;*.zip"};
    private static final String[] fgArchiveExtensions = new String[]{"jar", "zip"};
    private List fExcludes;
    private boolean fRecursive;

    public ArchiveFileFilter(IFile[] excludedFiles, boolean recusive) {
        this.fExcludes = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
        this.fRecursive = recusive;
    }

    public ArchiveFileFilter(List excludedFiles, boolean recusive) {
        this.fExcludes = excludedFiles;
        this.fRecursive = recusive;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes != null && this.fExcludes.contains(element)) {
                return false;
            }
            return ArchiveFileFilter.isArchivePath(((IFile)element).getFullPath());
        }
        if (element instanceof IContainer) {
            if (!this.fRecursive) {
                return true;
            }
            if (element instanceof IProject && !((IProject)element).isOpen()) {
                return false;
            }
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
        return false;
    }

    public static boolean isArchivePath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            return ArchiveFileFilter.isArchiveFileExtension(ext);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String ext) {
        int i = 0;
        while (i < fgArchiveExtensions.length) {
            if (ext.equalsIgnoreCase(fgArchiveExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

