/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTree
extends Composite {
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected TreeViewer treeViewer;
    protected Composite filterComposite;
    private PatternFilter patternFilter;
    protected String initialText = "";
    private Job refreshJob;
    protected boolean showFilterControls;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DCLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "$nl$/icons/full/dtool16/clear_co.gif")) != null) {
            JFaceResources.getImageRegistry().put(DCLEAR_ICON, descriptor);
        }
    }

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.patternFilter = filter;
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(parent, treeStyle);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(parent.getFont());
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = new GridLayout(2, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.createTreeControl(this, treeStyle);
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        this.createClearText(parent);
        this.filterToolBar.update(false);
        this.filterToolBar.getControl().setVisible(false);
        return parent;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = new TreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredTree.this.refreshJob.cancel();
            }
        });
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        int i = 0;
        if (i < items.length) {
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, items[i].getData()) && this.patternFilter.isElementSelectable(items[i].getData())) {
                return items[i];
            }
            return this.getFirstMatchingItem(items[i].getItems());
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                block13: {
                    IStatus iStatus;
                    block14: {
                        boolean initial;
                        if (FilteredTree.this.treeViewer.getControl().isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        String text = FilteredTree.this.getFilterString();
                        if (text == null) {
                            return Status.OK_STATUS;
                        }
                        boolean bl = initial = FilteredTree.this.initialText != null && FilteredTree.this.initialText.equals(text);
                        if (initial) {
                            FilteredTree.this.patternFilter.setPattern(null);
                        } else if (text != null) {
                            FilteredTree.this.patternFilter.setPattern(text);
                        }
                        try {
                            FilteredTree.this.treeViewer.getControl().setRedraw(false);
                            FilteredTree.this.treeViewer.refresh(true);
                            if (text.length() > 0 && !initial) {
                                IStructuredContentProvider provider = (IStructuredContentProvider)FilteredTree.this.treeViewer.getContentProvider();
                                Object[] elements = provider.getElements(FilteredTree.this.treeViewer.getInput());
                                int i = 0;
                                while (true) {
                                    if (i >= elements.length) {
                                        TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                                        if (items.length > 0) {
                                            FilteredTree.this.treeViewer.getTree().showItem(items[0]);
                                        }
                                        FilteredTree.this.updateToolbar(true);
                                        break block13;
                                    }
                                    FilteredTree.this.treeViewer.setExpandedState(elements[i], true);
                                    if (monitor.isCanceled()) {
                                        iStatus = Status.CANCEL_STATUS;
                                        Object var7_9 = null;
                                        break block14;
                                    }
                                    ++i;
                                }
                            }
                            FilteredTree.this.updateToolbar(false);
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            FilteredTree.this.treeViewer.getControl().setRedraw(true);
                            throw throwable;
                        }
                    }
                    FilteredTree.this.treeViewer.getControl().setRedraw(true);
                    return iStatus;
                }
                Object var7_11 = null;
                FilteredTree.this.treeViewer.getControl().setRedraw(true);
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    protected void updateToolbar(boolean visible) {
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(visible);
        }
    }

    protected void createFilterText(Composite parent) {
        this.filterText = new Text(parent, 2052);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTree.this.filterText.getText();
                e.result = filterTextString.length() == 0 ? FilteredTree.this.initialText : filterTextString;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = FilteredTree.this.filterText.getDisplay();
                display.asyncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (!4.access$0(this.this$1).filterText.isDisposed() && 4.access$0(this.this$1).getInitialText().equals(4.access$0(this.this$1).filterText.getText().trim())) {
                            4.access$0(this.this$1).filterText.selectAll();
                        }
                    }
                });
            }

            static /* synthetic */ FilteredTree access$0(4 var0) {
                return var0.FilteredTree.this;
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredTree.this.treeViewer.getTree().setFocus();
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (FilteredTree.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        TreeItem item;
                        boolean textChanged;
                        boolean hasFocus = FilteredTree.this.getViewer().getTree().setFocus();
                        boolean bl = textChanged = !FilteredTree.this.getInitialText().equals(FilteredTree.this.filterText.getText().trim());
                        if (hasFocus && textChanged && FilteredTree.this.filterText.getText().trim().length() > 0 && (item = FilteredTree.this.getFirstMatchingItem(FilteredTree.this.getViewer().getTree().getItems())) != null) {
                            FilteredTree.this.getViewer().getTree().setSelection(new TreeItem[]{item});
                            ISelection sel = FilteredTree.this.getViewer().getSelection();
                            FilteredTree.this.getViewer().setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredTree.this.textChanged();
            }
        });
        this.filterText.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void textChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null) {
            this.filterComposite.setBackground(background);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(background);
        }
    }

    private void createClearText(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800100);
        this.filterToolBar = new ToolBarManager(toolBar);
        Action clearTextAction = new Action("", 1){

            public void run() {
                FilteredTree.this.clearText();
            }
        };
        clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
        clearTextAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
        clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DCLEAR_ICON));
        this.filterToolBar.add((IAction)clearTextAction);
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        this.setFilterText(this.initialText);
        this.textChanged();
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object element, FilteredTree tree, PatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!"".equals(filterText) && !initialText.equals(filterText)) {
            boolean initial;
            boolean bl = initial = initialText != null && initialText.equals(filterText);
            if (initial) {
                filter.setPattern(null);
            } else if (filterText != null) {
                filter.setPattern(filterText);
            }
            if (filter.isElementVisible((Viewer)tree.getViewer(), element) && filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }
}

