/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;

public class WorkbenchControlAnimator
extends ControlAnimator {
    private UIJob slideJob;
    private Control control;
    private int endY;
    private boolean[] finished;
    private int LONG_DELAY = 1000;
    private int SHORT_DELAY = 25;

    public void setVisible(boolean visible, Control control) {
        this.control = control;
        this.finished = new boolean[1];
        this.setAnimationState(visible ? 1 : 3);
        Rectangle parentBounds = control.getParent().getBounds();
        int bottom = parentBounds.y + parentBounds.height;
        int n = this.endY = visible ? bottom - control.getBounds().height : bottom;
        if (this.slideJob != null) {
            this.slideJob.cancel();
        }
        this.slideJob = this.getSlideJob();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbenchControlAnimator.this.slideJob = null;
            }
        });
        if (this.getAnimationState() == 1) {
            this.slideJob.schedule(this.LONG_DELAY);
        } else {
            this.slideJob.schedule(this.SHORT_DELAY);
        }
    }

    private UIJob getSlideJob() {
        UIJob slideJob = new UIJob("Sliding Message"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled() && !WorkbenchControlAnimator.this.control.isDisposed()) {
                    Point loc = WorkbenchControlAnimator.this.control.getLocation();
                    switch (WorkbenchControlAnimator.this.getAnimationState()) {
                        case 1: {
                            --loc.y;
                            if (loc.y >= WorkbenchControlAnimator.this.endY) {
                                WorkbenchControlAnimator.this.control.setLocation(loc);
                                break;
                            }
                            ((WorkbenchControlAnimator)WorkbenchControlAnimator.this).finished[0] = true;
                            WorkbenchControlAnimator.this.setAnimationState(2);
                            break;
                        }
                        case 3: {
                            ++loc.y;
                            if (loc.y <= WorkbenchControlAnimator.this.endY) {
                                WorkbenchControlAnimator.this.control.setLocation(loc);
                                break;
                            }
                            ((WorkbenchControlAnimator)WorkbenchControlAnimator.this).finished[0] = true;
                            WorkbenchControlAnimator.this.setAnimationState(0);
                            break;
                        }
                    }
                    if (!WorkbenchControlAnimator.this.finished[0]) {
                        WorkbenchControlAnimator.this.getSlideJob().schedule(5L);
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        return slideJob;
    }
}

